/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import org.apache.poi.ss.formula.SheetNameFormatter;

public class SheetRangeAndWorkbookIndexFormatter {
    private SheetRangeAndWorkbookIndexFormatter() {
    }

    public static String format(StringBuilder sb2, int workbookIndex, String firstSheetName, String lastSheetName) {
        if (SheetRangeAndWorkbookIndexFormatter.anySheetNameNeedsEscaping(firstSheetName, lastSheetName)) {
            return SheetRangeAndWorkbookIndexFormatter.formatWithDelimiting(sb2, workbookIndex, firstSheetName, lastSheetName);
        }
        return SheetRangeAndWorkbookIndexFormatter.formatWithoutDelimiting(sb2, workbookIndex, firstSheetName, lastSheetName);
    }

    private static String formatWithDelimiting(StringBuilder sb2, int workbookIndex, String firstSheetName, String lastSheetName) {
        sb2.append('\'');
        if (workbookIndex >= 0) {
            sb2.append('[');
            sb2.append(workbookIndex);
            sb2.append(']');
        }
        SheetNameFormatter.appendAndEscape(sb2, firstSheetName);
        if (lastSheetName != null) {
            sb2.append(':');
            SheetNameFormatter.appendAndEscape(sb2, lastSheetName);
        }
        sb2.append('\'');
        return sb2.toString();
    }

    private static String formatWithoutDelimiting(StringBuilder sb2, int workbookIndex, String firstSheetName, String lastSheetName) {
        if (workbookIndex >= 0) {
            sb2.append('[');
            sb2.append(workbookIndex);
            sb2.append(']');
        }
        sb2.append(firstSheetName);
        if (lastSheetName != null) {
            sb2.append(':');
            sb2.append(lastSheetName);
        }
        return sb2.toString();
    }

    private static boolean anySheetNameNeedsEscaping(String firstSheetName, String lastSheetName) {
        boolean anySheetNameNeedsDelimiting = SheetNameFormatter.needsDelimiting(firstSheetName);
        return anySheetNameNeedsDelimiting |= SheetNameFormatter.needsDelimiting(lastSheetName);
    }
}

