/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.Locale;
import org.apache.poi.hssf.record.PaletteRecord;
import org.apache.poi.hssf.util.HSSFColor;

public final class HSSFPalette {
    private PaletteRecord _palette;

    protected HSSFPalette(PaletteRecord palette) {
        this._palette = palette;
    }

    public HSSFColor getColor(short index) {
        if (index == HSSFColor.HSSFColorPredefined.AUTOMATIC.getIndex()) {
            return HSSFColor.HSSFColorPredefined.AUTOMATIC.getColor();
        }
        byte[] b2 = this._palette.getColor(index);
        return b2 == null ? null : new CustomColor(index, b2);
    }

    public HSSFColor getColor(int index) {
        return this.getColor((short)index);
    }

    public HSSFColor findColor(byte red, byte green, byte blue) {
        byte[] b2 = this._palette.getColor(8);
        short i2 = 8;
        while (b2 != null) {
            if (b2[0] == red && b2[1] == green && b2[2] == blue) {
                return new CustomColor(i2, b2);
            }
            i2 = (short)(i2 + 1);
            b2 = this._palette.getColor(i2);
        }
        return null;
    }

    public HSSFColor findSimilarColor(byte red, byte green, byte blue) {
        return this.findSimilarColor(this.unsignedInt(red), this.unsignedInt(green), this.unsignedInt(blue));
    }

    public HSSFColor findSimilarColor(int red, int green, int blue) {
        HSSFColor result = null;
        int minColorDistance = Integer.MAX_VALUE;
        byte[] b2 = this._palette.getColor(8);
        short i2 = 8;
        while (b2 != null) {
            int colorDistance = Math.abs(red - this.unsignedInt(b2[0])) + Math.abs(green - this.unsignedInt(b2[1])) + Math.abs(blue - this.unsignedInt(b2[2]));
            if (colorDistance < minColorDistance) {
                minColorDistance = colorDistance;
                result = this.getColor(i2);
            }
            i2 = (short)(i2 + 1);
            b2 = this._palette.getColor(i2);
        }
        return result;
    }

    private int unsignedInt(byte b2) {
        return 0xFF & b2;
    }

    public void setColorAtIndex(short index, byte red, byte green, byte blue) {
        this._palette.setColor(index, red, green, blue);
    }

    public HSSFColor addColor(byte red, byte green, byte blue) {
        byte[] b2 = this._palette.getColor(8);
        for (short i2 = 8; i2 < 64; i2 = (short)(i2 + 1)) {
            if (b2 == null) {
                this.setColorAtIndex(i2, red, green, blue);
                return this.getColor(i2);
            }
            b2 = this._palette.getColor(i2);
        }
        throw new RuntimeException("Could not find free color index");
    }

    private static final class CustomColor
    extends HSSFColor {
        private short _byteOffset;
        private byte _red;
        private byte _green;
        private byte _blue;

        public CustomColor(short byteOffset, byte[] colors) {
            this(byteOffset, colors[0], colors[1], colors[2]);
        }

        private CustomColor(short byteOffset, byte red, byte green, byte blue) {
            this._byteOffset = byteOffset;
            this._red = red;
            this._green = green;
            this._blue = blue;
        }

        @Override
        public short getIndex() {
            return this._byteOffset;
        }

        @Override
        public short[] getTriplet() {
            return new short[]{(short)(this._red & 0xFF), (short)(this._green & 0xFF), (short)(this._blue & 0xFF)};
        }

        @Override
        public String getHexString() {
            return this.getGnumericPart(this._red) + ":" + this.getGnumericPart(this._green) + ":" + this.getGnumericPart(this._blue);
        }

        private String getGnumericPart(byte color) {
            String s2;
            if (color == 0) {
                s2 = "0";
            } else {
                int c2 = color & 0xFF;
                c2 = c2 << 8 | c2;
                s2 = Integer.toHexString(c2).toUpperCase(Locale.ROOT);
                while (s2.length() < 4) {
                    s2 = "0" + s2;
                }
            }
            return s2;
        }
    }
}

