/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.regression;

import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.moment.SecondMoment;
import org.apache.commons.math3.stat.regression.AbstractMultipleLinearRegression;

public class OLSMultipleLinearRegression
extends AbstractMultipleLinearRegression {
    private QRDecomposition qr = null;
    private final double threshold;

    public OLSMultipleLinearRegression() {
        this(0.0);
    }

    public OLSMultipleLinearRegression(double threshold) {
        this.threshold = threshold;
    }

    public void newSampleData(double[] y2, double[][] x2) throws MathIllegalArgumentException {
        this.validateSampleData(x2, y2);
        this.newYSampleData(y2);
        this.newXSampleData(x2);
    }

    public void newSampleData(double[] data, int nobs, int nvars) {
        super.newSampleData(data, nobs, nvars);
        this.qr = new QRDecomposition(this.getX(), this.threshold);
    }

    public RealMatrix calculateHat() {
        RealMatrix Q = this.qr.getQ();
        int p2 = this.qr.getR().getColumnDimension();
        int n2 = Q.getColumnDimension();
        Array2DRowRealMatrix augI = new Array2DRowRealMatrix(n2, n2);
        double[][] augIData = augI.getDataRef();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int j2 = 0; j2 < n2; ++j2) {
                augIData[i2][j2] = i2 == j2 && i2 < p2 ? 1.0 : 0.0;
            }
        }
        return Q.multiply(augI).multiply(Q.transpose());
    }

    public double calculateTotalSumOfSquares() {
        if (this.isNoIntercept()) {
            return StatUtils.sumSq(this.getY().toArray());
        }
        return new SecondMoment().evaluate(this.getY().toArray());
    }

    public double calculateResidualSumOfSquares() {
        RealVector residuals = this.calculateResiduals();
        return residuals.dotProduct(residuals);
    }

    public double calculateRSquared() {
        return 1.0 - this.calculateResidualSumOfSquares() / this.calculateTotalSumOfSquares();
    }

    public double calculateAdjustedRSquared() {
        double n2 = this.getX().getRowDimension();
        if (this.isNoIntercept()) {
            return 1.0 - (1.0 - this.calculateRSquared()) * (n2 / (n2 - (double)this.getX().getColumnDimension()));
        }
        return 1.0 - this.calculateResidualSumOfSquares() * (n2 - 1.0) / (this.calculateTotalSumOfSquares() * (n2 - (double)this.getX().getColumnDimension()));
    }

    protected void newXSampleData(double[][] x2) {
        super.newXSampleData(x2);
        this.qr = new QRDecomposition(this.getX(), this.threshold);
    }

    protected RealVector calculateBeta() {
        return this.qr.getSolver().solve(this.getY());
    }

    protected RealMatrix calculateBetaVariance() {
        int p2 = this.getX().getColumnDimension();
        RealMatrix Raug = this.qr.getR().getSubMatrix(0, p2 - 1, 0, p2 - 1);
        RealMatrix Rinv = new LUDecomposition(Raug).getSolver().getInverse();
        return Rinv.multiply(Rinv.transpose());
    }
}

