/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedCost;
import net.sf.mpxj.TimephasedItem;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.TimescaleUnits;

public final class TimephasedUtility {
    public ArrayList<Duration> segmentWork(ProjectCalendar projectCalendar, List<TimephasedWork> work, TimescaleUnits rangeUnits, List<DateRange> dateList) {
        ArrayList<Duration> result = new ArrayList<Duration>(dateList.size());
        int lastStartIndex = 0;
        for (DateRange range : dateList) {
            int startIndex;
            int n2 = startIndex = lastStartIndex == -1 ? -1 : this.getStartIndex(range, work, lastStartIndex);
            if (startIndex == -1) {
                result.add(Duration.getInstance(0, TimeUnit.HOURS));
                continue;
            }
            result.add(this.getRangeDuration(projectCalendar, rangeUnits, range, work, startIndex));
            lastStartIndex = startIndex;
        }
        return result;
    }

    public ArrayList<Duration> segmentBaselineWork(ProjectFile file, List<TimephasedWork> work, TimescaleUnits rangeUnits, ArrayList<DateRange> dateList) {
        return this.segmentWork(file.getBaselineCalendar(), work, rangeUnits, dateList);
    }

    public ArrayList<Double> segmentCost(ProjectCalendar projectCalendar, List<TimephasedCost> cost, TimescaleUnits rangeUnits, ArrayList<DateRange> dateList) {
        ArrayList<Double> result = new ArrayList<Double>(dateList.size());
        int lastStartIndex = 0;
        for (DateRange range : dateList) {
            int startIndex;
            int n2 = startIndex = lastStartIndex == -1 ? -1 : this.getStartIndex(range, cost, lastStartIndex);
            if (startIndex == -1) {
                result.add(NumberHelper.DOUBLE_ZERO);
                continue;
            }
            result.add(this.getRangeCost(projectCalendar, rangeUnits, range, cost, startIndex));
            lastStartIndex = startIndex;
        }
        return result;
    }

    public ArrayList<Double> segmentBaselineCost(ProjectFile file, List<TimephasedCost> cost, TimescaleUnits rangeUnits, ArrayList<DateRange> dateList) {
        return this.segmentCost(file.getBaselineCalendar(), cost, rangeUnits, dateList);
    }

    private <T extends TimephasedItem<?>> int getStartIndex(DateRange range, List<T> assignments, int startIndex) {
        int result = -1;
        if (assignments != null) {
            long rangeStart = range.getStart().getTime();
            long rangeEnd = range.getEnd().getTime();
            for (int loop = startIndex; loop < assignments.size(); ++loop) {
                TimephasedItem assignment = (TimephasedItem)assignments.get(loop);
                int compareResult = DateHelper.compare(assignment.getStart(), assignment.getFinish(), rangeStart);
                if (compareResult > 0) continue;
                if (compareResult == 0) {
                    result = loop;
                    break;
                }
                compareResult = DateHelper.compare(assignment.getStart(), assignment.getFinish(), rangeEnd);
                if (compareResult < 0) continue;
                result = loop;
                break;
            }
        }
        return result;
    }

    private Duration getRangeDuration(ProjectCalendar projectCalendar, TimescaleUnits rangeUnits, DateRange range, List<TimephasedWork> assignments, int startIndex) {
        Duration result;
        switch (rangeUnits) {
            case MINUTES: 
            case HOURS: {
                result = this.getRangeDurationSubDay(projectCalendar, rangeUnits, range, assignments, startIndex);
                break;
            }
            default: {
                result = this.getRangeDurationWholeDay(projectCalendar, rangeUnits, range, assignments, startIndex);
            }
        }
        return result;
    }

    private Duration getRangeDurationSubDay(ProjectCalendar projectCalendar, TimescaleUnits rangeUnits, DateRange range, List<TimephasedWork> assignments, int startIndex) {
        throw new UnsupportedOperationException("Please request this functionality from the MPXJ maintainer");
    }

    private Duration getRangeDurationWholeDay(ProjectCalendar projectCalendar, TimescaleUnits rangeUnits, DateRange range, List<TimephasedWork> assignments, int startIndex) {
        int totalDays = 0;
        double totalWork = 0.0;
        TimephasedWork assignment = assignments.get(startIndex);
        boolean done = false;
        do {
            long assignmentStart;
            long startDate;
            if ((startDate = range.getStart().getTime()) < (assignmentStart = assignment.getStart().getTime())) {
                startDate = assignmentStart;
            }
            long rangeEndDate = range.getEnd().getTime();
            long traEndDate = assignment.getFinish().getTime();
            Calendar cal = DateHelper.popCalendar(startDate);
            Date calendarDate = cal.getTime();
            while (startDate < rangeEndDate && startDate < traEndDate) {
                if (projectCalendar == null || projectCalendar.isWorkingDate(calendarDate)) {
                    ++totalDays;
                }
                cal.add(6, 1);
                startDate = cal.getTimeInMillis();
                calendarDate = cal.getTime();
            }
            DateHelper.pushCalendar(cal);
            done = true;
            totalWork += ((Duration)assignment.getAmountPerDay()).getDuration() * (double)totalDays;
            if (startDate >= rangeEndDate || ++startIndex >= assignments.size()) continue;
            assignment = assignments.get(startIndex);
            totalDays = 0;
            done = false;
        } while (!done);
        return Duration.getInstance(totalWork, ((Duration)assignment.getAmountPerDay()).getUnits());
    }

    private Double getRangeCost(ProjectCalendar projectCalendar, TimescaleUnits rangeUnits, DateRange range, List<TimephasedCost> assignments, int startIndex) {
        Double result;
        switch (rangeUnits) {
            case MINUTES: 
            case HOURS: {
                result = this.getRangeCostSubDay(projectCalendar, rangeUnits, range, assignments, startIndex);
                break;
            }
            default: {
                result = this.getRangeCostWholeDay(projectCalendar, rangeUnits, range, assignments, startIndex);
            }
        }
        return result;
    }

    private Double getRangeCostWholeDay(ProjectCalendar projectCalendar, TimescaleUnits rangeUnits, DateRange range, List<TimephasedCost> assignments, int startIndex) {
        int totalDays = 0;
        double totalCost = 0.0;
        TimephasedCost assignment = assignments.get(startIndex);
        boolean done = false;
        do {
            long assignmentStart;
            long startDate;
            if ((startDate = range.getStart().getTime()) < (assignmentStart = assignment.getStart().getTime())) {
                startDate = assignmentStart;
            }
            long rangeEndDate = range.getEnd().getTime();
            long traEndDate = assignment.getFinish().getTime();
            Calendar cal = DateHelper.popCalendar(startDate);
            Date calendarDate = cal.getTime();
            while (startDate < rangeEndDate && startDate < traEndDate) {
                if (projectCalendar == null || projectCalendar.isWorkingDate(calendarDate)) {
                    ++totalDays;
                }
                cal.add(6, 1);
                startDate = cal.getTimeInMillis();
                calendarDate = cal.getTime();
            }
            DateHelper.pushCalendar(cal);
            done = true;
            totalCost += ((Number)assignment.getAmountPerDay()).doubleValue() * (double)totalDays;
            if (startDate >= rangeEndDate || ++startIndex >= assignments.size()) continue;
            assignment = assignments.get(startIndex);
            totalDays = 0;
            done = false;
        } while (!done);
        return totalCost;
    }

    private Double getRangeCostSubDay(ProjectCalendar projectCalendar, TimescaleUnits rangeUnits, DateRange range, List<TimephasedCost> assignments, int startIndex) {
        throw new UnsupportedOperationException("Please request this functionality from the MPXJ maintainer");
    }
}

