/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectField;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.reader.UniversalProjectReader;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ProjectCleanUtility {
    private ProjectFile m_project;
    private DirectoryEntry m_projectDir;

    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Usage: ProjectCleanUtility <input file name> <output file name>");
            } else {
                System.out.println("Clean started.");
                long start = System.currentTimeMillis();
                ProjectCleanUtility clean = new ProjectCleanUtility();
                clean.process(args[0], args[1]);
                long elapsed = System.currentTimeMillis() - start;
                System.out.println("Clean completed in " + elapsed + "ms");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void process(String input, String output) throws MPXJException, IOException {
        this.m_project = new UniversalProjectReader().read(input);
        if (this.m_project.getProjectProperties().getFileType().equals("MPP")) {
            this.processMPP(input, output);
        } else {
            this.processFile(input, output);
        }
    }

    private void processFile(String input, String output) throws IOException {
        FileInputStream is = new FileInputStream(input);
        byte[] data = new byte[is.available()];
        is.read(data);
        is.close();
        this.processReplacements(data, this.m_project.getTasks(), false, false, TaskField.NAME);
        this.processReplacements(data, this.m_project.getResources(), false, false, ResourceField.NAME);
        FileOutputStream os = new FileOutputStream(output);
        os.write(data);
        os.flush();
        os.close();
    }

    private void processMPP(String input, String output) throws IOException {
        String varDataFileName;
        String projectDirName;
        int mppFileType = NumberHelper.getInt(this.m_project.getProjectProperties().getMppFileType());
        switch (mppFileType) {
            case 8: {
                projectDirName = "   1";
                varDataFileName = "FixDeferFix   0";
                break;
            }
            case 9: {
                projectDirName = "   19";
                varDataFileName = "Var2Data";
                break;
            }
            case 12: {
                projectDirName = "   112";
                varDataFileName = "Var2Data";
                break;
            }
            case 14: {
                projectDirName = "   114";
                varDataFileName = "Var2Data";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported file type " + mppFileType);
            }
        }
        FileInputStream is = new FileInputStream(input);
        POIFSFileSystem fs = new POIFSFileSystem(is);
        is.close();
        DirectoryNode root = fs.getRoot();
        this.m_projectDir = (DirectoryEntry)root.getEntry(projectDirName);
        this.processFile((DirectoryEntry)this.m_projectDir.getEntry("TBkndTask"), varDataFileName, this.m_project.getTasks(), true, TaskField.NAME);
        this.processFile((DirectoryEntry)this.m_projectDir.getEntry("TBkndRsc"), varDataFileName, this.m_project.getResources(), true, ResourceField.NAME, ResourceField.INITIALS);
        List<ProjectProperties> projectProperties = Arrays.asList(this.m_project.getProjectProperties());
        this.processFile(this.m_projectDir, "Props", projectProperties, true, ProjectField.PROJECT_TITLE);
        this.processFile(root, "\u0005SummaryInformation", projectProperties, false, ProjectField.PROJECT_TITLE, ProjectField.SUBJECT, ProjectField.AUTHOR, ProjectField.KEYWORDS, ProjectField.COMMENTS, ProjectField.LAST_AUTHOR);
        this.processFile(root, "\u0005DocumentSummaryInformation", projectProperties, false, ProjectField.MANAGER, ProjectField.COMPANY, ProjectField.CATEGORY);
        FileOutputStream os = new FileOutputStream(output);
        fs.writeFilesystem(os);
        os.flush();
        os.close();
        fs.close();
    }

    private void processReplacements(byte[] data, List<? extends FieldContainer> items, boolean unicode, boolean nulTerminated, FieldType ... fields) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (FieldContainer fieldContainer : items) {
            for (FieldType field : fields) {
                this.mapText((String)fieldContainer.getCachedValue(field), replacements);
            }
        }
        ArrayList keys = new ArrayList(replacements.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        for (String findText : keys) {
            String replaceText = (String)replacements.get(findText);
            this.replaceData(data, findText, replaceText, unicode, nulTerminated);
        }
    }

    private byte[] extractFile(DirectoryEntry parentDirectory, String fileName) throws IOException {
        DocumentEntry targetFile = (DocumentEntry)parentDirectory.getEntry(fileName);
        DocumentInputStream dis = new DocumentInputStream(targetFile);
        int dataSize = dis.available();
        byte[] data = new byte[dataSize];
        dis.read(data);
        dis.close();
        targetFile.delete();
        return data;
    }

    private void processFile(DirectoryEntry parentDirectory, String fileName, List<? extends FieldContainer> items, boolean unicode, FieldType ... fields) throws IOException {
        byte[] data = this.extractFile(parentDirectory, fileName);
        this.processReplacements(data, items, unicode, true, fields);
        parentDirectory.createDocument(fileName, new ByteArrayInputStream(data));
    }

    private void mapText(String oldText, Map<String, String> replacements) {
        char c2 = '\u0000';
        if (oldText != null && oldText.length() != 0 && !replacements.containsKey(oldText)) {
            StringBuilder newText = new StringBuilder(oldText.length());
            for (int loop = 0; loop < oldText.length(); ++loop) {
                char c3 = oldText.charAt(loop);
                if (Character.isUpperCase(c3)) {
                    newText.append('X');
                    continue;
                }
                if (Character.isLowerCase(c3)) {
                    newText.append('x');
                    continue;
                }
                if (Character.isDigit(c3)) {
                    newText.append('0');
                    continue;
                }
                if (Character.isLetter(c3)) {
                    if (c2 == '\u0000') {
                        c2 = c3;
                    }
                    newText.append(c2);
                    continue;
                }
                newText.append(c3);
            }
            replacements.put(oldText, newText.toString());
        }
    }

    private void replaceData(byte[] data, String findText, String replaceText, boolean unicode, boolean nulTerminated) {
        boolean replaced = false;
        byte[] findBytes = this.getBytes(findText, unicode, nulTerminated);
        byte[] replaceBytes = this.getBytes(replaceText, unicode, nulTerminated);
        int endIndex = data.length - findBytes.length;
        for (int index = 0; index <= endIndex; ++index) {
            if (!this.compareBytes(findBytes, data, index)) continue;
            System.arraycopy(replaceBytes, 0, data, index, replaceBytes.length);
            index += replaceBytes.length;
            System.out.println(findText + " -> " + replaceText);
            replaced = true;
        }
        if (!replaced) {
            System.out.println("Failed to find " + findText);
        }
    }

    private byte[] getBytes(String value, boolean unicode, boolean nulTerminated) {
        byte[] result;
        if (unicode) {
            byte[] bytes;
            int start = 0;
            try {
                bytes = value.getBytes("UTF-16");
            }
            catch (UnsupportedEncodingException e2) {
                bytes = value.getBytes();
            }
            if (bytes.length > 2 && bytes[0] == -2 && bytes[1] == -1) {
                start = 2;
            }
            result = new byte[bytes.length - start];
            for (int loop = start; loop < bytes.length - 1; loop += 2) {
                result[loop - start] = bytes[loop + 1];
                result[loop + 1 - start] = bytes[loop];
            }
        } else {
            int length = nulTerminated ? value.length() + 1 : value.length();
            result = new byte[length];
            System.arraycopy(value.getBytes(), 0, result, 0, value.length());
        }
        return result;
    }

    private boolean compareBytes(byte[] lhs, byte[] rhs, int rhsOffset) {
        boolean result = true;
        for (int loop = 0; loop < lhs.length; ++loop) {
            if (lhs[loop] == rhs[rhsOffset + loop]) continue;
            result = false;
            break;
        }
        return result;
    }
}

