/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.synchro;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.synchro.MapRow;
import net.sf.mpxj.synchro.StreamReader;
import net.sf.mpxj.synchro.SynchroLogger;

abstract class TableReader {
    protected final StreamReader m_stream;
    private final List<MapRow> m_rows = new ArrayList<MapRow>();

    public TableReader(StreamReader stream) {
        this.m_stream = stream;
    }

    public List<MapRow> getRows() {
        return this.m_rows;
    }

    public TableReader read() throws IOException {
        int tableHeader = this.m_stream.readInt();
        if (tableHeader != 967791738) {
            throw new IllegalArgumentException("Unexpected file format");
        }
        int recordCount = this.m_stream.readInt();
        for (int loop = 0; loop < recordCount; ++loop) {
            int rowMagicNumber = this.m_stream.readInt();
            if (rowMagicNumber != this.rowMagicNumber()) {
                throw new IllegalArgumentException("Unexpected file format");
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            if (this.hasUUID()) {
                this.readUUID(this.m_stream, map);
            }
            this.readRow(this.m_stream, map);
            SynchroLogger.log("READER", this.getClass(), map);
            this.m_rows.add(new MapRow(map));
        }
        int tableTrailer = this.m_stream.readInt();
        if (tableTrailer != 1872356374) {
            throw new IllegalArgumentException("Unexpected file format");
        }
        this.postTrailer(this.m_stream);
        return this;
    }

    protected boolean hasUUID() {
        return true;
    }

    protected void readUUID(StreamReader stream, Map<String, Object> map) throws IOException {
        int unknown0Size = stream.getMajorVersion() > 5 ? 8 : 16;
        map.put("UNKNOWN0", stream.readBytes(unknown0Size));
        map.put("UUID", stream.readUUID());
    }

    protected void postTrailer(StreamReader stream) throws IOException {
    }

    protected abstract int rowMagicNumber();

    protected abstract void readRow(StreamReader var1, Map<String, Object> var2) throws IOException;
}

