/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.synchro;

import java.io.IOException;
import java.util.Map;
import net.sf.mpxj.synchro.CommentaryReader;
import net.sf.mpxj.synchro.StreamReader;
import net.sf.mpxj.synchro.TableReader;
import net.sf.mpxj.synchro.UserFieldReader;

class ResourceReader
extends TableReader {
    public ResourceReader(StreamReader stream) {
        super(stream);
    }

    @Override
    protected void readRow(StreamReader stream, Map<String, Object> map) throws IOException {
        int unknown3BlockSize = this.m_stream.getMajorVersion() > 5 ? 56 : 64;
        map.put("NAME", stream.readString());
        map.put("DESCRIPTION", stream.readString());
        Integer supplyReferenceFlag = stream.readInteger();
        map.put("SUPPLY_REFERENCE_FLAG", supplyReferenceFlag);
        if (supplyReferenceFlag != 0) {
            map.put("SUPPLY_REFERENCE", stream.readString());
        }
        map.put("UNKNOWN1", stream.readBytes(48));
        map.put("RESOURCES", stream.readTable(ResourceReader.class));
        map.put("UNKNOWN2", stream.readBytes(20));
        map.put("URL", stream.readString());
        map.put("USER_FIELDS", stream.readTableConditional(UserFieldReader.class));
        map.put("ID", stream.readString());
        map.put("EMAIL", stream.readString());
        map.put("UNKNOWN3", stream.readUnknownTable(unknown3BlockSize, 1880862653));
        map.put("UNKNOWN4", stream.readBytes(30));
        map.put("COMMENTARY", stream.readTableConditional(CommentaryReader.class));
        map.put("UNKNOWN5", stream.readBytes(48));
        Integer unknown6Flag = stream.readInteger();
        map.put("UNKNOWN6_FLAG", unknown6Flag);
        if (unknown6Flag != 0) {
            map.put("UNKNOWN6", stream.readBytes(70));
            map.put("UNKNOWN7", stream.readString());
            map.put("UNKNOWN8", stream.readBytes(4));
        }
        map.put("UNKNOWN9", stream.readBytes(12));
        if (this.m_stream.getMajorVersion() > 5) {
            map.put("UNKNOWN10", stream.readBytes(12));
        }
        map.put("UNIQUE_ID", stream.readInteger());
    }

    @Override
    protected int rowMagicNumber() {
        return 1470651441;
    }
}

