/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.synchro;

import java.io.IOException;
import java.util.Map;
import net.sf.mpxj.Duration;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.synchro.StreamReader;
import net.sf.mpxj.synchro.TableReader;

class PredecessorReader
extends TableReader {
    private static final RelationType[] RELATION_TYPES = new RelationType[]{null, RelationType.FINISH_START, RelationType.START_FINISH, RelationType.START_START, RelationType.FINISH_FINISH};

    public PredecessorReader(StreamReader stream) {
        super(stream);
    }

    @Override
    protected void readRow(StreamReader stream, Map<String, Object> map) throws IOException {
        boolean lagIsNegative;
        map.put("PREDECESSOR_UUID", stream.readUUID());
        map.put("RELATION_TYPE", this.getRelationType(stream.readInt()));
        map.put("UNKNOWN1", stream.readBytes(4));
        map.put("LAG", stream.readDuration());
        map.put("UNKNOWN2", stream.readBytes(4));
        if (stream.getCombinedVersion() < 601) {
            lagIsNegative = stream.readInt() == 2;
            map.put("LAG_IS_NEGATIVE", lagIsNegative);
            map.put("CALENDAR_UUID", stream.readUUID());
            map.put("UNKNOWN3", stream.readBytes(8));
        } else {
            map.put("CALENDAR_UUID", stream.readUUID());
            lagIsNegative = stream.readInt() == 2;
            map.put("LAG_IS_NEGATIVE", lagIsNegative);
        }
        if (lagIsNegative) {
            Duration lag = (Duration)map.get("LAG");
            map.put("LAG", Duration.getInstance(-lag.getDuration(), lag.getUnits()));
        }
    }

    @Override
    protected int rowMagicNumber() {
        return 82306001;
    }

    private RelationType getRelationType(int type) {
        RelationType result = type > 0 && type < RELATION_TYPES.length ? RELATION_TYPES[type] : RelationType.FINISH_START;
        return result;
    }
}

