/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.synchro;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.UUID;
import net.sf.mpxj.Duration;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.common.DateHelper;

final class DatatypeConverter {
    private static final int NULL_SECONDS = -1824493569;

    DatatypeConverter() {
    }

    public static String getSimpleString(byte[] data, int offset) {
        char c2;
        StringBuilder buffer = new StringBuilder();
        int loop = 0;
        while (offset + loop < data.length && (c2 = (char)data[offset + loop]) != '\u0000') {
            buffer.append(c2);
            ++loop;
        }
        return buffer.toString();
    }

    public static final int getInt(byte[] data, int offset) {
        int result = 0;
        int i2 = offset;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            result |= (data[i2] & 0xFF) << shiftBy;
            ++i2;
        }
        return result;
    }

    public static final int getShort(byte[] data, int offset) {
        int result = 0;
        int i2 = offset;
        for (int shiftBy = 0; shiftBy < 16; shiftBy += 8) {
            result |= (data[i2] & 0xFF) << shiftBy;
            ++i2;
        }
        return result;
    }

    public static final long getLong(byte[] data, int offset) {
        long result = 0L;
        int i2 = offset;
        for (int shiftBy = 0; shiftBy < 64; shiftBy += 8) {
            result |= (long)(data[i2] & 0xFF) << shiftBy;
            ++i2;
        }
        return result;
    }

    public static final int getInt(InputStream is) throws IOException {
        byte[] data = new byte[4];
        is.read(data);
        return DatatypeConverter.getInt(data, 0);
    }

    public static final Integer getInteger(InputStream is) throws IOException {
        return DatatypeConverter.getInt(is);
    }

    public static final int getShort(InputStream is) throws IOException {
        byte[] data = new byte[2];
        is.read(data);
        return DatatypeConverter.getShort(data, 0);
    }

    public static final long getLong(InputStream is) throws IOException {
        byte[] data = new byte[8];
        is.read(data);
        return DatatypeConverter.getLong(data, 0);
    }

    public static final String getString(InputStream is) throws IOException {
        String result;
        int length;
        int type = is.read();
        if (type == 255) {
            length = 255;
        } else {
            if (type != 1) {
                throw new IllegalArgumentException("Unexpected string format");
            }
            length = is.read();
        }
        Charset charset = CharsetHelper.UTF8;
        if (length == 255 && (length = DatatypeConverter.getShort(is)) == 65534) {
            charset = CharsetHelper.UTF16LE;
            length = is.read() * 2;
        }
        if (length == 0) {
            result = null;
        } else {
            byte[] stringData = new byte[length];
            is.read(stringData);
            result = new String(stringData, charset);
        }
        return result;
    }

    public static boolean getBoolean(InputStream is) throws IOException {
        int value = is.read();
        return value != 0;
    }

    public static final UUID getUUID(InputStream is) throws IOException {
        byte[] data = new byte[16];
        is.read(data);
        long long1 = 0L;
        long1 |= (long)(data[3] & 0xFF) << 56;
        long1 |= (long)(data[2] & 0xFF) << 48;
        long1 |= (long)(data[1] & 0xFF) << 40;
        long1 |= (long)(data[0] & 0xFF) << 32;
        long1 |= (long)(data[5] & 0xFF) << 24;
        long1 |= (long)(data[4] & 0xFF) << 16;
        long1 |= (long)(data[7] & 0xFF) << 8;
        long1 |= (long)(data[6] & 0xFF) << 0;
        long long2 = 0L;
        long2 |= (long)(data[8] & 0xFF) << 56;
        long2 |= (long)(data[9] & 0xFF) << 48;
        long2 |= (long)(data[10] & 0xFF) << 40;
        long2 |= (long)(data[11] & 0xFF) << 32;
        long2 |= (long)(data[12] & 0xFF) << 24;
        long2 |= (long)(data[13] & 0xFF) << 16;
        long2 |= (long)(data[14] & 0xFF) << 8;
        return new UUID(long1, long2 |= (long)(data[15] & 0xFF) << 0);
    }

    public static final Date getDate(InputStream is) throws IOException {
        long timeInSeconds = DatatypeConverter.getInt(is);
        if (timeInSeconds == -1824493569L) {
            return null;
        }
        timeInSeconds -= 3600L;
        return DateHelper.getDateFromLong(timeInSeconds *= 1000L);
    }

    public static final Date getTime(InputStream is) throws IOException {
        int timeValue = DatatypeConverter.getInt(is);
        timeValue -= 86400;
        return DateHelper.getTimeFromMinutesPastMidnight(timeValue /= 60);
    }

    public static final Duration getDuration(InputStream is) throws IOException {
        int durationInSeconds = DatatypeConverter.getInt(is);
        if (durationInSeconds == -1824493569) {
            return null;
        }
        double durationInHours = durationInSeconds;
        return Duration.getInstance(durationInHours /= 3600.0, TimeUnit.HOURS);
    }

    public static final Double getDouble(InputStream is) throws IOException {
        double result = Double.longBitsToDouble(DatatypeConverter.getLong(is));
        if (Double.isNaN(result)) {
            result = 0.0;
        }
        return result;
    }
}

