/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sdef;

import java.util.Date;
import net.sf.mpxj.Duration;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.sdef.AbstractSDEFRecord;
import net.sf.mpxj.sdef.Context;
import net.sf.mpxj.sdef.DateField;
import net.sf.mpxj.sdef.DoubleField;
import net.sf.mpxj.sdef.DurationField;
import net.sf.mpxj.sdef.SDEFField;
import net.sf.mpxj.sdef.StringField;

class ProgressRecord
extends AbstractSDEFRecord {
    private static final SDEFField[] FIELDS = new SDEFField[]{new StringField("Activity ID", 10), new DateField("Actual Start Date"), new DateField("Actual Finish Date"), new DurationField("Remaining Duration", 3), new DoubleField("Activity Cost", 12), new DoubleField("Cost to Date", 12), new DoubleField("Stored Material", 12), new DateField("Early Start Date"), new DateField("Early Finish Date"), new DateField("Late Start Date"), new DateField("Late Finish Date"), new StringField("Float Sign", 1), new DurationField("Total Float", 3)};

    ProgressRecord() {
    }

    @Override
    protected SDEFField[] getFieldDefinitions() {
        return FIELDS;
    }

    @Override
    public void process(Context context) {
        Double totalCost = this.getDouble(4);
        Double costToDate = this.getDouble(5);
        Double remainingCost = NumberHelper.getDouble(totalCost) - NumberHelper.getDouble(costToDate);
        Duration totalFloat = this.getDuration(12);
        if ("-".equals(this.getString(11))) {
            totalFloat = Duration.getInstance(-totalFloat.getDuration(), TimeUnit.DAYS);
        }
        Task task = context.getTask(this.getString(0));
        task.setActualStart(this.getDate(1));
        task.setActualFinish(this.getDate(2));
        task.setRemainingDuration(this.getDuration(3));
        task.setCost(this.getDouble(4));
        task.setRemainingCost(remainingCost);
        task.setCost(1, this.getDouble(6));
        task.setEarlyStart(this.getDate(7));
        task.setEarlyFinish(this.getDate(8));
        task.setLateStart(this.getDate(9));
        task.setLateFinish(this.getDate(10));
        task.setTotalSlack(totalFloat);
        Date start = task.getActualStart() == null ? task.getEarlyStart() : task.getActualStart();
        Date finish = task.getActualFinish() == null ? task.getEarlyFinish() : task.getActualFinish();
        double percentComplete = 0.0;
        if (task.getActualFinish() == null) {
            Duration duration = task.getDuration();
            Duration remainingDuration = task.getRemainingDuration();
            if (duration != null && remainingDuration != null) {
                double durationValue = duration.getDuration();
                double remainingDurationValue = remainingDuration.getDuration();
                if (durationValue != 0.0 && remainingDurationValue < durationValue) {
                    percentComplete = (durationValue - remainingDurationValue) * 100.0 / durationValue;
                }
            }
        } else {
            percentComplete = 100.0;
        }
        task.setStart(start);
        task.setFinish(finish);
        task.setPercentageComplete(percentComplete);
    }
}

