/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sage;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.reader.AbstractProjectReader;

public final class SageReader
extends AbstractProjectReader {
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private List<ProjectListener> m_projectListeners;
    private Map<String, Task> m_taskMap;
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("MM/dd/yyyy");
        }
    };
    private static final Map<String, RelationType> RELATION_TYPE_MAP = new HashMap<String, RelationType>();

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    @Override
    public ProjectFile read(InputStream is) throws MPXJException {
        try {
            String line;
            this.m_projectFile = new ProjectFile();
            this.m_projectFile.getProjectProperties().setFileApplication("Sage");
            this.m_projectFile.getProjectProperties().setFileType("SCHEDULE_GRID");
            this.m_eventManager = this.m_projectFile.getEventManager();
            this.m_taskMap = new HashMap<String, Task>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            this.processTasks(lines);
            this.processPredecessors(lines);
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (IOException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            this.m_eventManager = null;
            this.m_taskMap = null;
        }
    }

    private void processTasks(List<String> lines) {
        int index = this.skipToSection(lines, "**** Schedule Grid ****");
        if (index == lines.size()) {
            return;
        }
        while (index < lines.size()) {
            String line;
            if ((line = lines.get(index++)).isEmpty()) {
                return;
            }
            this.processTask(line);
        }
    }

    private void processPredecessors(List<String> lines) {
        int index = this.skipToSection(lines, "**** Predecessors ****");
        if (index == lines.size()) {
            return;
        }
        while (index < lines.size()) {
            String line;
            if ((line = lines.get(index++)).isEmpty()) {
                return;
            }
            this.processPredecessor(line);
        }
    }

    private int skipToSection(List<String> lines, String section) {
        String line;
        int index = 0;
        while (index < lines.size() && !(line = lines.get(index++)).equals(section)) {
        }
        return index;
    }

    private void processTask(String line) {
        String[] columns = line.split("\t");
        Task task = this.m_projectFile.addTask();
        task.setText(1, this.parseID(columns, 0));
        task.setName(this.getText(columns, 1));
        task.setDuration(this.parseDuration(columns, 2));
        this.setConstraint(task, ConstraintType.MUST_START_ON, columns, 4);
        this.setConstraint(task, ConstraintType.START_NO_EARLIER_THAN, columns, 5);
        this.setConstraint(task, ConstraintType.FINISH_NO_LATER_THAN, columns, 6);
        task.setStart(this.parseDate(columns, 7));
        task.setFinish(this.parseDate(columns, 8));
        task.setLateStart(this.parseDate(columns, 9));
        task.setLateFinish(this.parseDate(columns, 10));
        task.setTotalSlack(this.parseDuration(columns, 11));
        task.setBaselineDuration(this.parseDuration(columns, 12));
        task.setBaselineStart(this.parseDate(columns, 13));
        task.setBaselineFinish(this.parseDate(columns, 14));
        task.setText(2, this.getText(columns, 16));
        task.setNotes(this.getText(columns, 17));
        this.m_taskMap.put(task.getText(1), task);
        this.m_eventManager.fireTaskReadEvent(task);
    }

    private void processPredecessor(String line) {
        String[] columns = line.split("\t");
        Task task = this.m_taskMap.get(this.parseID(columns, 0));
        if (task == null) {
            return;
        }
        Task predecessor = this.m_taskMap.get(this.parseID(columns, 1));
        if (predecessor == null) {
            return;
        }
        RelationType type = this.parseRelationType(columns, 2);
        Duration lag = this.parseDuration(columns, 3);
        task.addPredecessor(predecessor, type, lag);
    }

    private String parseID(String[] columns, int index) {
        String id2 = this.getText(columns, index);
        if (id2 != null && id2.indexOf(46) == -1) {
            id2 = id2 + ".000";
        }
        return id2;
    }

    private String getText(String[] columns, int index) {
        String result = null;
        if (index < columns.length) {
            result = columns[index];
        }
        return result;
    }

    private Date parseDate(String[] columns, int index) {
        Date result;
        String date = this.getText(columns, index);
        if (date == null || date.isEmpty()) {
            result = null;
        } else {
            try {
                result = DATE_FORMAT.get().parse(date);
            }
            catch (ParseException e2) {
                result = null;
            }
        }
        return result;
    }

    private Duration parseDuration(String[] columns, int index) {
        Duration result = null;
        String duration = this.getText(columns, index);
        if (duration != null && !duration.isEmpty()) {
            result = Duration.getInstance(Integer.parseInt(duration), TimeUnit.DAYS);
        }
        return result;
    }

    private RelationType parseRelationType(String[] columns, int index) {
        RelationType result = null;
        String text = this.getText(columns, index);
        if (text != null) {
            result = RELATION_TYPE_MAP.get(text);
        }
        if (result == null) {
            result = RelationType.FINISH_START;
        }
        return result;
    }

    private void setConstraint(Task task, ConstraintType type, String[] columns, int index) {
        Date date = this.parseDate(columns, index);
        if (date != null) {
            task.setConstraintType(type);
            task.setConstraintDate(date);
        }
    }

    static {
        RELATION_TYPE_MAP.put("1", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("2", RelationType.START_START);
        RELATION_TYPE_MAP.put("3", RelationType.START_FINISH);
        RELATION_TYPE_MAP.put("4", RelationType.FINISH_FINISH);
    }
}

