/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.StreamHelper;
import net.sf.mpxj.reader.ProjectReader;

public abstract class AbstractProjectReader
implements ProjectReader {
    @Override
    public ProjectFile read(String fileName) throws MPXJException {
        ProjectFile projectFile;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            ProjectFile projectFile2 = this.read(fis);
            fis.close();
            fis = null;
            projectFile = projectFile2;
        }
        catch (IOException ex) {
            try {
                throw new MPXJException("Error reading file", ex);
            }
            catch (Throwable throwable) {
                StreamHelper.closeQuietly(fis);
                throw throwable;
            }
        }
        StreamHelper.closeQuietly(fis);
        return projectFile;
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        ProjectFile projectFile;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ProjectFile projectFile2 = this.read(fis);
            fis.close();
            projectFile = projectFile2;
        }
        catch (IOException ex) {
            try {
                throw new MPXJException("Error reading file", ex);
            }
            catch (Throwable throwable) {
                StreamHelper.closeQuietly(fis);
                throw throwable;
            }
        }
        StreamHelper.closeQuietly(fis);
        return projectFile;
    }
}

