/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera.suretrak;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.FileHelper;
import net.sf.mpxj.common.FixedLengthInputStream;
import net.sf.mpxj.common.StreamHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.primavera.common.Blast;
import net.sf.mpxj.primavera.suretrak.SureTrakDatabaseReader;
import net.sf.mpxj.reader.AbstractProjectReader;

public final class SureTrakSTXFileReader
extends AbstractProjectReader {
    private List<ProjectListener> m_projectListeners;

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        ProjectFile projectFile;
        File tempDir = null;
        try {
            StreamHelper.skip(stream, 32772L);
            tempDir = FileHelper.createTempDir();
            while (stream.available() > 0) {
                this.extractFile(stream, tempDir);
            }
            projectFile = SureTrakDatabaseReader.setProjectNameAndRead(tempDir);
        }
        catch (IOException ex) {
            try {
                throw new MPXJException("Failed to parse file", ex);
            }
            catch (Throwable throwable) {
                FileHelper.deleteQuietly(tempDir);
                throw throwable;
            }
        }
        FileHelper.deleteQuietly(tempDir);
        return projectFile;
    }

    private void extractFile(InputStream stream, File dir) throws IOException {
        byte[] dataSize = new byte[4];
        byte[] header = new byte[4];
        byte[] fileName = new byte[260];
        stream.read(dataSize);
        stream.read(header);
        stream.read(fileName);
        int dataSizeValue = this.getInt(dataSize, 0);
        String fileNameValue = this.getString(fileName, 0);
        File file = new File(dir, fileNameValue);
        if (dataSizeValue == 0) {
            FileHelper.createNewFile(file);
        } else {
            FileOutputStream os = new FileOutputStream(file);
            FixedLengthInputStream inputStream = new FixedLengthInputStream(stream, dataSizeValue);
            Blast blast = new Blast();
            blast.blast(inputStream, os);
            ((OutputStream)os).close();
        }
    }

    public int getInt(byte[] data, int offset) {
        int result = 0;
        int i2 = offset;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            result |= (data[i2] & 0xFF) << shiftBy;
            ++i2;
        }
        return result;
    }

    public String getString(byte[] data, int offset) {
        char c2;
        StringBuilder buffer = new StringBuilder();
        int loop = 0;
        while (offset + loop < data.length && (c2 = (char)data[offset + loop]) != '\u0000') {
            buffer.append(c2);
            ++loop;
        }
        return buffer.toString();
    }
}

