/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.ActivityCode;
import net.sf.mpxj.ActivityCodeContainer;
import net.sf.mpxj.ActivityCodeValue;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.Availability;
import net.sf.mpxj.AvailabilityTable;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.DataType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarDateRanges;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.primavera.ActivitySorter;
import net.sf.mpxj.primavera.ExternalPredecessorRelation;
import net.sf.mpxj.primavera.PercentCompleteType;
import net.sf.mpxj.primavera.Record;
import net.sf.mpxj.primavera.Row;
import net.sf.mpxj.primavera.UserFieldCounters;
import net.sf.mpxj.primavera.UserFieldDataType;

final class PrimaveraReader {
    private ProjectFile m_project;
    private EventManager m_eventManager;
    private Map<Integer, Integer> m_clashMap = new HashMap<Integer, Integer>();
    private DateFormat m_calendarTimeFormat = new SimpleDateFormat("HH:mm");
    private Integer m_defaultCalendarID;
    private final UserFieldCounters m_taskUdfCounters;
    private final UserFieldCounters m_resourceUdfCounters;
    private final UserFieldCounters m_assignmentUdfCounters;
    private Map<FieldType, String> m_resourceFields;
    private Map<FieldType, String> m_wbsFields;
    private Map<FieldType, String> m_taskFields;
    private Map<FieldType, String> m_assignmentFields;
    private List<ExternalPredecessorRelation> m_externalPredecessors = new ArrayList<ExternalPredecessorRelation>();
    private final boolean m_matchPrimaveraWBS;
    private final boolean m_wbsIsFullPath;
    private Map<Integer, String> m_udfFields = new HashMap<Integer, String>();
    private Map<String, Map<Integer, List<Row>>> m_udfValues = new HashMap<String, Map<Integer, List<Row>>>();
    private Map<Integer, ActivityCodeValue> m_activityCodeMap = new HashMap<Integer, ActivityCodeValue>();
    private Map<Integer, List<Integer>> m_activityCodeAssignments = new HashMap<Integer, List<Integer>>();
    private static final Map<String, ResourceType> RESOURCE_TYPE_MAP = new HashMap<String, ResourceType>();
    private static final Map<String, ConstraintType> CONSTRAINT_TYPE_MAP;
    private static final Map<String, Priority> PRIORITY_MAP;
    private static final Map<String, RelationType> RELATION_TYPE_MAP;
    private static final Map<String, TaskType> TASK_TYPE_MAP;
    private static final Map<String, Boolean> MILESTONE_MAP;
    private static final Map<String, TimeUnit> TIME_UNIT_MAP;
    private static final Map<String, CurrencySymbolPosition> CURRENCY_SYMBOL_POSITION_MAP;
    private static final Map<String, Boolean> STATICTYPE_UDF_MAP;
    private static final Map<String, FieldTypeClass> FIELD_TYPE_MAP;
    private static final long EXCEPTION_EPOCH = -2209161599935L;

    public PrimaveraReader(UserFieldCounters taskUdfCounters, UserFieldCounters resourceUdfCounters, UserFieldCounters assignmentUdfCounters, Map<FieldType, String> resourceFields, Map<FieldType, String> wbsFields, Map<FieldType, String> taskFields, Map<FieldType, String> assignmentFields, Map<FieldType, String> aliases, boolean matchPrimaveraWBS, boolean wbsIsFullPath) {
        this.m_project = new ProjectFile();
        this.m_eventManager = this.m_project.getEventManager();
        ProjectConfig config = this.m_project.getProjectConfig();
        config.setAutoTaskUniqueID(false);
        config.setAutoResourceUniqueID(false);
        config.setAutoAssignmentUniqueID(false);
        config.setAutoWBS(false);
        this.m_resourceFields = resourceFields;
        this.m_wbsFields = wbsFields;
        this.m_taskFields = taskFields;
        this.m_assignmentFields = assignmentFields;
        this.applyAliases(aliases);
        this.m_taskUdfCounters = taskUdfCounters;
        this.m_taskUdfCounters.reset();
        this.m_resourceUdfCounters = resourceUdfCounters;
        this.m_resourceUdfCounters.reset();
        this.m_assignmentUdfCounters = assignmentUdfCounters;
        this.m_assignmentUdfCounters.reset();
        this.m_matchPrimaveraWBS = matchPrimaveraWBS;
        this.m_wbsIsFullPath = wbsIsFullPath;
    }

    public ProjectFile getProject() {
        return this.m_project;
    }

    public List<ExternalPredecessorRelation> getExternalPredecessors() {
        return this.m_externalPredecessors;
    }

    public void processProjectProperties(List<Row> rows, Integer projectID) {
        if (!rows.isEmpty()) {
            Row row = rows.get(0);
            ProjectProperties properties = this.m_project.getProjectProperties();
            properties.setCreationDate(row.getDate("create_date"));
            properties.setFinishDate(row.getDate("plan_end_date"));
            properties.setName(row.getString("proj_short_name"));
            properties.setStartDate(row.getDate("plan_start_date"));
            properties.setDefaultTaskType(TASK_TYPE_MAP.get(row.getString("def_duration_type")));
            properties.setStatusDate(row.getDate("last_recalc_date"));
            properties.setFiscalYearStartMonth(row.getInteger("fy_start_month_num"));
            properties.setUniqueID(projectID == null ? null : projectID.toString());
            properties.setExportFlag(row.getBoolean("export_flag"));
            this.m_defaultCalendarID = row.getInteger("clndr_id");
        }
    }

    public void processActivityCodes(List<Row> types, List<Row> typeValues, List<Row> assignments) {
        ActivityCode code;
        ActivityCodeContainer container = this.m_project.getActivityCodes();
        HashMap<Integer, ActivityCode> map = new HashMap<Integer, ActivityCode>();
        for (Row row : types) {
            code = new ActivityCode(row.getInteger("actv_code_type_id"), row.getString("actv_code_type"));
            container.add(code);
            map.put(code.getUniqueID(), code);
        }
        for (Row row : typeValues) {
            code = (ActivityCode)map.get(row.getInteger("actv_code_type_id"));
            if (code == null) continue;
            ActivityCodeValue value = code.addValue(row.getInteger("actv_code_id"), row.getString("short_name"), row.getString("actv_code_name"));
            this.m_activityCodeMap.put(value.getUniqueID(), value);
        }
        for (Row row : typeValues) {
            ActivityCodeValue child = this.m_activityCodeMap.get(row.getInteger("actv_code_id"));
            ActivityCodeValue parent = this.m_activityCodeMap.get(row.getInteger("parent_actv_code_id"));
            if (parent == null || child == null) continue;
            child.setParent(parent);
        }
        for (Row row : assignments) {
            Integer taskID = row.getInteger("task_id");
            List<Integer> list = this.m_activityCodeAssignments.get(taskID);
            if (list == null) {
                list = new ArrayList<Integer>();
                this.m_activityCodeAssignments.put(taskID, list);
            }
            list.add(row.getInteger("actv_code_id"));
        }
    }

    public void processUserDefinedFields(List<Row> fields, List<Row> values) {
        String tableName;
        HashMap<Integer, String> tableNameMap = new HashMap<Integer, String>();
        for (Row row : fields) {
            Integer fieldId = row.getInteger("udf_type_id");
            tableName = row.getString("table_name");
            tableNameMap.put(fieldId, tableName);
            FieldTypeClass fieldType = FIELD_TYPE_MAP.get(tableName);
            if (fieldType == null) continue;
            String fieldDataType = row.getString("logical_data_type");
            String fieldName = row.getString("udf_type_label");
            this.m_udfFields.put(fieldId, fieldName);
            this.addUserDefinedField(fieldType, UserFieldDataType.valueOf(fieldDataType), fieldName);
        }
        for (Row row : values) {
            Integer id2;
            List<Row> list;
            Integer typeID = row.getInteger("udf_type_id");
            tableName = (String)tableNameMap.get(typeID);
            Map<Integer, List<Row>> tableData = this.m_udfValues.get(tableName);
            if (tableData == null) {
                tableData = new HashMap<Integer, List<Row>>();
                this.m_udfValues.put(tableName, tableData);
            }
            if ((list = tableData.get(id2 = row.getInteger("fk_id"))) == null) {
                list = new ArrayList<Row>();
                tableData.put(id2, list);
            }
            list.add(row);
        }
    }

    public void processCalendars(List<Row> rows) {
        ProjectCalendar projectCalendar;
        HashMap<ProjectCalendar, Integer> baseCalendarMap = new HashMap<ProjectCalendar, Integer>();
        for (Row row : rows) {
            ProjectCalendar calendar = this.processCalendar(row);
            Integer baseCalendarID = row.getInteger("base_clndr_id");
            if (baseCalendarID == null) continue;
            baseCalendarMap.put(calendar, baseCalendarID);
        }
        for (Map.Entry entry : baseCalendarMap.entrySet()) {
            ProjectCalendar baseCalendar = this.m_project.getCalendarByUniqueID((Integer)entry.getValue());
            if (baseCalendar == null) continue;
            ((ProjectCalendar)entry.getKey()).setParent(baseCalendar);
        }
        ProjectConfig config = this.m_project.getProjectConfig();
        config.setAutoCalendarUniqueID(true);
        config.updateCalendarUniqueCounter();
        if (this.m_defaultCalendarID != null && (projectCalendar = this.m_project.getCalendarByUniqueID(this.m_defaultCalendarID)) != null) {
            this.m_project.setDefaultCalendar(projectCalendar);
        }
    }

    public ProjectCalendar processCalendar(Row row) {
        ProjectCalendar calendar = this.m_project.addCalendar();
        Integer id2 = row.getInteger("clndr_id");
        calendar.setUniqueID(id2);
        calendar.setName(row.getString("clndr_name"));
        try {
            calendar.setMinutesPerDay((int)NumberHelper.getDouble(row.getDouble("day_hr_cnt")) * 60);
            calendar.setMinutesPerWeek((int)(NumberHelper.getDouble(row.getDouble("week_hr_cnt")) * 60.0));
            calendar.setMinutesPerMonth((int)(NumberHelper.getDouble(row.getDouble("month_hr_cnt")) * 60.0));
            calendar.setMinutesPerYear((int)(NumberHelper.getDouble(row.getDouble("year_hr_cnt")) * 60.0));
        }
        catch (ClassCastException ex) {
            return calendar;
        }
        String calendarData = row.getString("clndr_data");
        if (calendarData != null && !calendarData.isEmpty()) {
            Record root = Record.getRecord(calendarData);
            if (root != null) {
                this.processCalendarDays(calendar, root);
                this.processCalendarExceptions(calendar, root);
            }
        } else {
            DateRange defaultHourRange = new DateRange(DateHelper.getTime(8, 0), DateHelper.getTime(16, 0));
            for (Day day : Day.values()) {
                if (day != Day.SATURDAY && day != Day.SUNDAY) {
                    calendar.setWorkingDay(day, true);
                    ProjectCalendarHours hours = calendar.addCalendarHours(day);
                    hours.addRange(defaultHourRange);
                    continue;
                }
                calendar.setWorkingDay(day, false);
            }
        }
        this.m_eventManager.fireCalendarReadEvent(calendar);
        return calendar;
    }

    private void processCalendarDays(ProjectCalendar calendar, Record root) {
        Record daysOfWeek = root.getChild("DaysOfWeek");
        if (daysOfWeek != null) {
            for (Record dayRecord : daysOfWeek.getChildren()) {
                this.processCalendarHours(calendar, dayRecord);
            }
        }
    }

    private void processCalendarHours(ProjectCalendar calendar, Record dayRecord) {
        Day day = Day.getInstance(Integer.parseInt(dayRecord.getField()));
        List<Record> recHours = dayRecord.getChildren();
        if (recHours.size() == 0) {
            calendar.setWorkingDay(day, false);
        } else {
            calendar.setWorkingDay(day, true);
            ProjectCalendarHours hours = calendar.addCalendarHours(day);
            for (Record recWorkingHours : recHours) {
                this.addHours(hours, recWorkingHours);
            }
        }
    }

    private void addHours(ProjectCalendarDateRanges ranges, Record hoursRecord) {
        if (hoursRecord.getValue() != null) {
            String[] wh = hoursRecord.getValue().split("\\|");
            try {
                String endText;
                String startText;
                if (wh[0].equals("s")) {
                    startText = wh[1];
                    endText = wh[3];
                } else {
                    startText = wh[3];
                    endText = wh[1];
                }
                if (endText.equals("00:00")) {
                    endText = "24:00";
                }
                Date start = this.m_calendarTimeFormat.parse(startText);
                Date end = this.m_calendarTimeFormat.parse(endText);
                ranges.addRange(new DateRange(start, end));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private void processCalendarExceptions(ProjectCalendar calendar, Record root) {
        Record exceptions = root.getChild("Exceptions");
        if (exceptions != null) {
            for (Record exception : exceptions.getChildren()) {
                long daysFromEpoch = Integer.parseInt(exception.getValue().split("\\|")[1]);
                Date startEx = DateHelper.getDateFromLong(-2209161599935L + daysFromEpoch * 86400000L);
                ProjectCalendarException pce = calendar.addCalendarException(startEx, startEx);
                for (Record exceptionHours : exception.getChildren()) {
                    this.addHours(pce, exceptionHours);
                }
            }
        }
    }

    public void processResources(List<Row> rows) {
        for (Row row : rows) {
            Resource resource = this.m_project.addResource();
            this.processFields(this.m_resourceFields, row, resource);
            resource.setResourceCalendar(this.getResourceCalendar(row.getInteger("clndr_id")));
            TimeUnit timeUnit = TIME_UNIT_MAP.get(row.getString("cost_qty_type"));
            resource.setStandardRateUnits(timeUnit);
            resource.setOvertimeRateUnits(timeUnit);
            this.populateUserDefinedFieldValues("RSRC", FieldTypeClass.RESOURCE, resource, resource.getUniqueID());
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private ProjectCalendar getResourceCalendar(Integer calendarID) {
        ProjectCalendar calendar;
        ProjectCalendar result = null;
        if (calendarID != null && (calendar = this.m_project.getCalendarByUniqueID(calendarID)) != null) {
            if (!calendar.isDerived()) {
                ProjectCalendar resourceCalendar = this.m_project.addCalendar();
                resourceCalendar.setParent(calendar);
                resourceCalendar.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
                result = resourceCalendar;
            } else if (calendar.getResource() == null) {
                result = calendar;
            } else {
                ProjectCalendar copy = this.m_project.addCalendar();
                copy.copy(calendar);
                result = copy;
            }
        }
        return result;
    }

    public void processResourceRates(List<Row> rows) {
        Collections.sort(rows, new Comparator<Row>(){

            @Override
            public int compare(Row r1, Row r2) {
                Integer id2;
                Integer id1 = r1.getInteger("rsrc_id");
                int cmp = NumberHelper.compare(id1, id2 = r2.getInteger("rsrc_id"));
                if (cmp != 0) {
                    return cmp;
                }
                Date d1 = r1.getDate("start_date");
                Date d2 = r2.getDate("start_date");
                return DateHelper.compare(d1, d2);
            }
        });
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            Resource resource;
            Row row = rows.get(i2);
            Integer resourceID = row.getInteger("rsrc_id");
            Rate standardRate = new Rate(row.getDouble("cost_per_qty"), TimeUnit.HOURS);
            TimeUnit standardRateFormat = TimeUnit.HOURS;
            Rate overtimeRate = new Rate(0.0, TimeUnit.HOURS);
            TimeUnit overtimeRateFormat = TimeUnit.HOURS;
            Double costPerUse = NumberHelper.getDouble(0.0);
            Double maxUnits = NumberHelper.getDouble(NumberHelper.getDouble(row.getDouble("max_qty_per_hr")) * 100.0);
            Date startDate = row.getDate("start_date");
            Date endDate = DateHelper.LAST_DATE;
            if (i2 + 1 < rows.size()) {
                Row nextRow = rows.get(i2 + 1);
                int nextResourceID = nextRow.getInt("rsrc_id");
                if (resourceID == nextResourceID) {
                    endDate = nextRow.getDate("start_date");
                }
            }
            if ((resource = this.m_project.getResourceByUniqueID(resourceID)) == null) continue;
            CostRateTable costRateTable = resource.getCostRateTable(0);
            if (costRateTable == null) {
                costRateTable = new CostRateTable();
                resource.setCostRateTable(0, costRateTable);
            }
            CostRateTableEntry entry = new CostRateTableEntry(standardRate, standardRateFormat, overtimeRate, overtimeRateFormat, costPerUse, endDate);
            costRateTable.add(entry);
            AvailabilityTable availabilityTable = resource.getAvailability();
            Availability newAvailability = new Availability(startDate, endDate, maxUnits);
            availabilityTable.add(newAvailability);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processTasks(List<Row> wbs, List<Row> tasks) {
        ProjectProperties projectProperties = this.m_project.getProjectProperties();
        String projectName = projectProperties.getName();
        HashSet<Integer> uniqueIDs = new HashSet<Integer>();
        HashSet<Task> wbsTasks = new HashSet<Task>();
        if (!wbs.isEmpty()) {
            projectProperties.setProjectTitle(wbs.get(0).getString("wbs_name"));
        }
        for (Row row : wbs) {
            Task task = this.m_project.addTask();
            task.setProject(projectName);
            task.setSummary(true);
            this.processFields(this.m_wbsFields, row, task);
            this.populateUserDefinedFieldValues("PROJWBS", FieldTypeClass.TASK, task, task.getUniqueID());
            uniqueIDs.add(task.getUniqueID());
            wbsTasks.add(task);
            this.m_eventManager.fireTaskReadEvent(task);
        }
        FieldType activityIDField = this.getActivityIDField(this.m_wbsFields);
        this.m_project.getChildTasks().clear();
        for (Row row : wbs) {
            Task task = this.m_project.getTaskByUniqueID(row.getInteger("wbs_id"));
            Task parentTask = this.m_project.getTaskByUniqueID(row.getInteger("parent_wbs_id"));
            if (parentTask == null) {
                this.m_project.getChildTasks().add(task);
                continue;
            }
            this.m_project.getChildTasks().remove(task);
            parentTask.getChildTasks().add(task);
            if (this.m_wbsIsFullPath) {
                task.setWBS(parentTask.getWBS() + "." + task.getWBS());
            }
            if (activityIDField == null) continue;
            task.set(activityIDField, task.getWBS());
        }
        boolean bl = true;
        this.m_clashMap.clear();
        for (Row row : tasks) {
            Integer parentTaskID = row.getInteger("wbs_id");
            Task parentTask = this.m_project.getTaskByUniqueID(parentTaskID);
            Task task = parentTask == null ? this.m_project.addTask() : parentTask.addTask();
            task.setProject(projectName);
            this.processFields(this.m_taskFields, row, task);
            task.setMilestone(BooleanHelper.getBoolean(MILESTONE_MAP.get(row.getString("task_type"))));
            task.setIgnoreResourceCalendar(!"TT_Rsrc".equals(row.getString("task_type")));
            task.setPercentageComplete(this.calculatePercentComplete(row));
            if (this.m_matchPrimaveraWBS && parentTask != null) {
                task.setWBS(parentTask.getWBS());
            }
            Integer uniqueID = task.getUniqueID();
            this.populateUserDefinedFieldValues("TASK", FieldTypeClass.TASK, task, uniqueID);
            this.populateActivityCodes(task);
            if (uniqueIDs.contains(uniqueID)) {
                void var8_11;
                while (uniqueIDs.contains((int)var8_11)) {
                    ++var8_11;
                }
                Integer newUniqueID = (int)var8_11;
                this.m_clashMap.put(uniqueID, newUniqueID);
                uniqueID = newUniqueID;
                task.setUniqueID(uniqueID);
            }
            uniqueIDs.add(uniqueID);
            Integer calId = row.getInteger("clndr_id");
            ProjectCalendar cal = this.m_project.getCalendarByUniqueID(calId);
            task.setCalendar(cal);
            Date startDate = row.getDate("act_start_date") == null ? row.getDate("restart_date") : row.getDate("act_start_date");
            task.setStart(startDate);
            Date endDate = row.getDate("act_end_date") == null ? row.getDate("reend_date") : row.getDate("act_end_date");
            task.setFinish(endDate);
            Duration work = Duration.add(task.getActualWork(), task.getRemainingWork(), projectProperties);
            task.setWork(work);
            this.m_eventManager.fireTaskReadEvent(task);
        }
        new ActivitySorter(TaskField.TEXT1, wbsTasks).sort(this.m_project);
        this.updateStructure();
        this.updateDates();
        this.updateWork();
    }

    private void populateActivityCodes(Task task) {
        List<Integer> list = this.m_activityCodeAssignments.get(task.getUniqueID());
        if (list != null) {
            for (Integer id2 : list) {
                ActivityCodeValue value = this.m_activityCodeMap.get(id2);
                if (value == null) continue;
                task.addActivityCode(value);
            }
        }
    }

    private FieldType getActivityIDField(Map<FieldType, String> map) {
        FieldType result = null;
        for (Map.Entry<FieldType, String> entry : map.entrySet()) {
            if (!entry.getValue().equals("task_code")) continue;
            result = entry.getKey();
            break;
        }
        return result;
    }

    private void addUserDefinedField(FieldTypeClass fieldType, UserFieldDataType dataType, String name) {
        try {
            switch (fieldType) {
                case TASK: {
                    TaskField taskField;
                    while (this.m_taskFields.containsKey(taskField = this.m_taskUdfCounters.nextField(TaskField.class, dataType)) || this.m_wbsFields.containsKey(taskField)) {
                    }
                    this.m_project.getCustomFields().getCustomField(taskField).setAlias(name);
                    break;
                }
                case RESOURCE: {
                    ResourceField resourceField;
                    while (this.m_resourceFields.containsKey(resourceField = this.m_resourceUdfCounters.nextField(ResourceField.class, dataType))) {
                    }
                    this.m_project.getCustomFields().getCustomField(resourceField).setAlias(name);
                    break;
                }
                case ASSIGNMENT: {
                    AssignmentField assignmentField;
                    while (this.m_assignmentFields.containsKey(assignmentField = this.m_assignmentUdfCounters.nextField(AssignmentField.class, dataType))) {
                    }
                    this.m_project.getCustomFields().getCustomField(assignmentField).setAlias(name);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addUDFValue(FieldTypeClass fieldType, FieldContainer container, Row row) {
        Integer fieldId = row.getInteger("udf_type_id");
        String fieldName = this.m_udfFields.get(fieldId);
        Object value = null;
        FieldType field = this.m_project.getCustomFields().getFieldByAlias(fieldType, fieldName);
        if (field != null) {
            DataType fieldDataType = field.getDataType();
            switch (fieldDataType) {
                case DATE: {
                    value = row.getDate("udf_date");
                    break;
                }
                case CURRENCY: 
                case NUMERIC: {
                    value = row.getDouble("udf_number");
                    break;
                }
                case GUID: 
                case INTEGER: {
                    value = row.getInteger("udf_code_id");
                    break;
                }
                case BOOLEAN: {
                    String text = row.getString("udf_text");
                    if (text != null) {
                        value = STATICTYPE_UDF_MAP.get(text);
                        if (value != null) break;
                        value = row.getBoolean("udf_text");
                        break;
                    }
                    value = row.getBoolean("udf_number");
                    break;
                }
                default: {
                    value = row.getString("udf_text");
                }
            }
            container.set(field, value);
        }
    }

    private void populateUserDefinedFieldValues(String tableName, FieldTypeClass type, FieldContainer container, Integer uniqueID) {
        List<Row> udf;
        Map<Integer, List<Row>> tableData = this.m_udfValues.get(tableName);
        if (tableData != null && (udf = tableData.get(uniqueID)) != null) {
            for (Row r2 : udf) {
                this.addUDFValue(type, container, r2);
            }
        }
    }

    private void populateField(FieldContainer container, FieldType target, FieldType baseline, FieldType actual) {
        Object value = container.getCachedValue(actual);
        if (value == null) {
            value = container.getCachedValue(baseline);
        }
        container.set(target, value);
    }

    private void updateStructure() {
        int id2 = 1;
        Integer outlineLevel = 1;
        for (Task task : this.m_project.getChildTasks()) {
            id2 = this.updateStructure(id2, task, outlineLevel);
        }
    }

    private int updateStructure(int id2, Task task, Integer outlineLevel) {
        task.setID(id2++);
        task.setOutlineLevel(outlineLevel);
        outlineLevel = outlineLevel + 1;
        for (Task childTask : task.getChildTasks()) {
            id2 = this.updateStructure(id2, childTask, outlineLevel);
        }
        return id2;
    }

    private void updateDates() {
        for (Task task : this.m_project.getChildTasks()) {
            this.updateDates(task);
        }
    }

    private void updateDates(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            int finished = 0;
            Date plannedStartDate = parentTask.getStart();
            Date plannedFinishDate = parentTask.getFinish();
            Date actualStartDate = parentTask.getActualStart();
            Date actualFinishDate = parentTask.getActualFinish();
            Date earlyStartDate = parentTask.getEarlyStart();
            Date earlyFinishDate = parentTask.getEarlyFinish();
            Date lateStartDate = parentTask.getLateStart();
            Date lateFinishDate = parentTask.getLateFinish();
            Date baselineStartDate = parentTask.getBaselineStart();
            Date baselineFinishDate = parentTask.getBaselineFinish();
            Date remainingEarlyStartDate = parentTask.getRemainingEarlyStart();
            Date remainingEarlyFinishDate = parentTask.getRemainingEarlyFinish();
            for (Task task : parentTask.getChildTasks()) {
                this.updateDates(task);
                plannedStartDate = DateHelper.min(plannedStartDate, task.getStart());
                plannedFinishDate = DateHelper.max(plannedFinishDate, task.getFinish());
                actualStartDate = DateHelper.min(actualStartDate, task.getActualStart());
                actualFinishDate = DateHelper.max(actualFinishDate, task.getActualFinish());
                earlyStartDate = DateHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = DateHelper.max(earlyFinishDate, task.getEarlyFinish());
                remainingEarlyStartDate = DateHelper.min(remainingEarlyStartDate, task.getRemainingEarlyStart());
                remainingEarlyFinishDate = DateHelper.max(remainingEarlyFinishDate, task.getRemainingEarlyFinish());
                lateStartDate = DateHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = DateHelper.max(lateFinishDate, task.getLateFinish());
                baselineStartDate = DateHelper.min(baselineStartDate, task.getBaselineStart());
                baselineFinishDate = DateHelper.max(baselineFinishDate, task.getBaselineFinish());
                if (task.getActualFinish() == null) continue;
                ++finished;
            }
            parentTask.setStart(plannedStartDate);
            parentTask.setFinish(plannedFinishDate);
            parentTask.setActualStart(actualStartDate);
            parentTask.setEarlyStart(earlyStartDate);
            parentTask.setEarlyFinish(earlyFinishDate);
            parentTask.setRemainingEarlyStart(remainingEarlyStartDate);
            parentTask.setRemainingEarlyFinish(remainingEarlyFinishDate);
            parentTask.setLateStart(lateStartDate);
            parentTask.setLateFinish(lateFinishDate);
            parentTask.setBaselineStart(baselineStartDate);
            parentTask.setBaselineFinish(baselineFinishDate);
            if (finished == parentTask.getChildTasks().size()) {
                parentTask.setActualFinish(actualFinishDate);
            }
            Duration baselineDuration = null;
            if (baselineStartDate != null && baselineFinishDate != null) {
                baselineDuration = this.m_project.getDefaultCalendar().getWork(baselineStartDate, baselineFinishDate, TimeUnit.HOURS);
                parentTask.setBaselineDuration(baselineDuration);
            }
            Duration remainingDuration = null;
            if (parentTask.getActualFinish() == null) {
                Date finishDate;
                Date startDate = parentTask.getEarlyStart();
                if (startDate == null) {
                    startDate = baselineStartDate;
                }
                if ((finishDate = parentTask.getEarlyFinish()) == null) {
                    finishDate = baselineFinishDate;
                }
                if (startDate != null && finishDate != null) {
                    remainingDuration = this.m_project.getDefaultCalendar().getWork(startDate, finishDate, TimeUnit.HOURS);
                }
            } else {
                remainingDuration = Duration.getInstance(0, TimeUnit.HOURS);
            }
            parentTask.setRemainingDuration(remainingDuration);
            if (baselineDuration != null && remainingDuration != null && baselineDuration.getDuration() != 0.0) {
                double durationPercentComplete = (baselineDuration.getDuration() - remainingDuration.getDuration()) / baselineDuration.getDuration() * 100.0;
                if (durationPercentComplete < 0.0) {
                    durationPercentComplete = 0.0;
                } else if (durationPercentComplete > 100.0) {
                    durationPercentComplete = 100.0;
                }
                parentTask.setPercentageComplete(durationPercentComplete);
            }
        }
    }

    private void updateWork() {
        for (Task task : this.m_project.getChildTasks()) {
            this.updateWork(task);
        }
    }

    private void updateWork(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            ProjectProperties properties = this.m_project.getProjectProperties();
            Duration actualWork = null;
            Duration baselineWork = null;
            Duration remainingWork = null;
            Duration work = null;
            for (Task task : parentTask.getChildTasks()) {
                this.updateWork(task);
                actualWork = Duration.add(actualWork, task.getActualWork(), properties);
                baselineWork = Duration.add(baselineWork, task.getBaselineWork(), properties);
                remainingWork = Duration.add(remainingWork, task.getRemainingWork(), properties);
                work = Duration.add(work, task.getWork(), properties);
            }
            parentTask.setActualWork(actualWork);
            parentTask.setBaselineWork(baselineWork);
            parentTask.setRemainingWork(remainingWork);
            parentTask.setWork(work);
        }
    }

    public void processPredecessors(List<Row> rows) {
        for (Row row : rows) {
            Object relation;
            Integer currentID = this.mapTaskID(row.getInteger("task_id"));
            Integer predecessorID = this.mapTaskID(row.getInteger("pred_task_id"));
            Task currentTask = this.m_project.getTaskByUniqueID(currentID);
            Task predecessorTask = this.m_project.getTaskByUniqueID(predecessorID);
            RelationType type = RELATION_TYPE_MAP.get(row.getString("pred_type"));
            Duration lag = row.getDuration("lag_hr_cnt");
            if (currentTask == null) continue;
            Integer uniqueID = row.getInteger("task_pred_id");
            if (predecessorTask != null) {
                relation = currentTask.addPredecessor(predecessorTask, type, lag);
                ((Relation)relation).setUniqueID(uniqueID);
                this.m_eventManager.fireRelationReadEvent((Relation)relation);
                continue;
            }
            relation = new ExternalPredecessorRelation(predecessorID, currentTask, type, lag);
            this.m_externalPredecessors.add((ExternalPredecessorRelation)relation);
            ((ExternalPredecessorRelation)relation).setUniqueID(uniqueID);
        }
    }

    public void processAssignments(List<Row> rows) {
        for (Row row : rows) {
            Task task = this.m_project.getTaskByUniqueID(this.mapTaskID(row.getInteger("task_id")));
            Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("rsrc_id"));
            if (task == null || resource == null) continue;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            this.processFields(this.m_assignmentFields, row, assignment);
            this.populateField(assignment, AssignmentField.START, AssignmentField.BASELINE_START, AssignmentField.ACTUAL_START);
            this.populateField(assignment, AssignmentField.FINISH, AssignmentField.BASELINE_FINISH, AssignmentField.ACTUAL_FINISH);
            Duration remainingWork = row.getDuration("remain_qty");
            Duration actualOvertimeWork = row.getDuration("act_ot_qty");
            Duration actualRegularWork = row.getDuration("act_reg_qty");
            Duration actualWork = Duration.add(actualOvertimeWork, actualRegularWork, this.m_project.getProjectProperties());
            Duration totalWork = Duration.add(actualWork, remainingWork, this.m_project.getProjectProperties());
            assignment.setActualWork(actualWork);
            assignment.setWork(totalWork);
            Double remainingCost = row.getDouble("remain_cost");
            Double actualOvertimeCost = row.getDouble("act_ot_cost");
            Double actualRegularCost = row.getDouble("act_reg_cost");
            double actualCost = NumberHelper.getDouble(actualOvertimeCost) + NumberHelper.getDouble(actualRegularCost);
            double totalCost = actualCost + NumberHelper.getDouble(remainingCost);
            assignment.setActualCost(NumberHelper.getDouble(actualCost));
            assignment.setCost(NumberHelper.getDouble(totalCost));
            double units = resource.getType() == ResourceType.MATERIAL ? (totalWork == null ? 0.0 : totalWork.getDuration() * 100.0) : NumberHelper.getDouble(row.getDouble("target_qty_per_hr")) * 100.0;
            assignment.setUnits(NumberHelper.getDouble(units));
            this.populateUserDefinedFieldValues("TASKRSRC", FieldTypeClass.ASSIGNMENT, assignment, assignment.getUniqueID());
            this.m_eventManager.fireAssignmentReadEvent(assignment);
        }
        this.updateTaskCosts();
    }

    private void updateTaskCosts() {
        for (Task task : this.m_project.getChildTasks()) {
            this.updateTaskCosts(task);
        }
    }

    private void updateTaskCosts(Task parentTask) {
        double baselineCost = 0.0;
        double actualCost = 0.0;
        double remainingCost = 0.0;
        double cost = 0.0;
        for (Task child : parentTask.getChildTasks()) {
            this.updateTaskCosts(child);
            baselineCost += NumberHelper.getDouble(child.getBaselineCost());
            actualCost += NumberHelper.getDouble(child.getActualCost());
            remainingCost += NumberHelper.getDouble(child.getRemainingCost());
            cost += NumberHelper.getDouble(child.getCost());
        }
        List<ResourceAssignment> resourceAssignments = parentTask.getResourceAssignments();
        for (ResourceAssignment assignment : resourceAssignments) {
            baselineCost += NumberHelper.getDouble(assignment.getBaselineCost());
            actualCost += NumberHelper.getDouble(assignment.getActualCost());
            remainingCost += NumberHelper.getDouble(assignment.getRemainingCost());
            cost += NumberHelper.getDouble(assignment.getCost());
        }
        parentTask.setBaselineCost(NumberHelper.getDouble(baselineCost));
        parentTask.setActualCost(NumberHelper.getDouble(actualCost));
        parentTask.setRemainingCost(NumberHelper.getDouble(remainingCost));
        parentTask.setCost(NumberHelper.getDouble(cost));
    }

    public void processDefaultCurrency(Row row) {
        ProjectProperties properties = this.m_project.getProjectProperties();
        properties.setCurrencySymbol(row.getString("curr_symbol"));
        properties.setSymbolPosition(CURRENCY_SYMBOL_POSITION_MAP.get(row.getString("pos_curr_fmt_type")));
        properties.setCurrencyDigits(row.getInteger("decimal_digit_cnt"));
        properties.setThousandsSeparator(row.getString("digit_group_symbol").charAt(0));
        properties.setDecimalSeparator(row.getString("decimal_symbol").charAt(0));
    }

    private void processFields(Map<FieldType, String> map, Row row, FieldContainer container) {
        for (Map.Entry<FieldType, String> entry : map.entrySet()) {
            Object value;
            FieldType field = entry.getKey();
            String name = entry.getValue();
            switch (field.getDataType()) {
                case INTEGER: {
                    value = row.getInteger(name);
                    break;
                }
                case BOOLEAN: {
                    value = row.getBoolean(name);
                    break;
                }
                case DATE: {
                    value = row.getDate(name);
                    break;
                }
                case CURRENCY: 
                case NUMERIC: 
                case PERCENTAGE: {
                    value = row.getDouble(name);
                    break;
                }
                case DELAY: 
                case WORK: 
                case DURATION: {
                    value = row.getDuration(name);
                    break;
                }
                case RESOURCE_TYPE: {
                    value = RESOURCE_TYPE_MAP.get(row.getString(name));
                    break;
                }
                case TASK_TYPE: {
                    value = TASK_TYPE_MAP.get(row.getString(name));
                    break;
                }
                case CONSTRAINT: {
                    value = CONSTRAINT_TYPE_MAP.get(row.getString(name));
                    break;
                }
                case PRIORITY: {
                    value = PRIORITY_MAP.get(row.getString(name));
                    break;
                }
                case GUID: {
                    value = row.getUUID(name);
                    break;
                }
                default: {
                    value = row.getString(name);
                }
            }
            container.set(field, value);
        }
    }

    private Integer mapTaskID(Integer id2) {
        Integer mappedID = this.m_clashMap.get(id2);
        if (mappedID == null) {
            mappedID = id2;
        }
        return mappedID;
    }

    private void applyAliases(Map<FieldType, String> aliases) {
        CustomFieldContainer fields = this.m_project.getCustomFields();
        for (Map.Entry<FieldType, String> entry : aliases.entrySet()) {
            fields.getCustomField(entry.getKey()).setAlias(entry.getValue());
        }
    }

    private Number calculatePercentComplete(Row row) {
        Number result;
        switch (PercentCompleteType.getInstance(row.getString("complete_pct_type"))) {
            case UNITS: {
                result = this.calculateUnitsPercentComplete(row);
                break;
            }
            case DURATION: {
                result = this.calculateDurationPercentComplete(row);
                break;
            }
            default: {
                result = this.calculatePhysicalPercentComplete(row);
            }
        }
        return result;
    }

    private Number calculatePhysicalPercentComplete(Row row) {
        return row.getDouble("phys_complete_pct");
    }

    private Number calculateUnitsPercentComplete(Row row) {
        double actualEquipmentQuantity;
        double result = 0.0;
        double actualWorkQuantity = NumberHelper.getDouble(row.getDouble("act_work_qty"));
        double numerator = actualWorkQuantity + (actualEquipmentQuantity = NumberHelper.getDouble(row.getDouble("act_equip_qty")));
        if (numerator != 0.0) {
            double remainingEquipmentQuantity;
            double remainingWorkQuantity = NumberHelper.getDouble(row.getDouble("remain_work_qty"));
            double denominator = remainingWorkQuantity + actualWorkQuantity + (remainingEquipmentQuantity = NumberHelper.getDouble(row.getDouble("remain_equip_qty"))) + actualEquipmentQuantity;
            result = denominator == 0.0 ? 0.0 : numerator * 100.0 / denominator;
        }
        return NumberHelper.getDouble(result);
    }

    private Number calculateDurationPercentComplete(Row row) {
        double result = 0.0;
        double targetDuration = row.getDuration("target_drtn_hr_cnt").getDuration();
        double remainingDuration = row.getDuration("remain_drtn_hr_cnt").getDuration();
        if (targetDuration == 0.0) {
            if (remainingDuration == 0.0 && "TK_Complete".equals(row.getString("status_code"))) {
                result = 100.0;
            }
        } else if (remainingDuration < targetDuration) {
            result = (targetDuration - remainingDuration) * 100.0 / targetDuration;
        }
        return NumberHelper.getDouble(result);
    }

    public static Map<FieldType, String> getDefaultResourceFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(ResourceField.UNIQUE_ID, "rsrc_id");
        map.put(ResourceField.GUID, "guid");
        map.put(ResourceField.NAME, "rsrc_name");
        map.put(ResourceField.CODE, "employee_code");
        map.put(ResourceField.EMAIL_ADDRESS, "email_addr");
        map.put(ResourceField.NOTES, "rsrc_notes");
        map.put(ResourceField.CREATED, "create_date");
        map.put(ResourceField.TYPE, "rsrc_type");
        map.put(ResourceField.INITIALS, "rsrc_short_name");
        map.put(ResourceField.PARENT_ID, "parent_rsrc_id");
        return map;
    }

    public static Map<FieldType, String> getDefaultWbsFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(TaskField.UNIQUE_ID, "wbs_id");
        map.put(TaskField.GUID, "guid");
        map.put(TaskField.NAME, "wbs_name");
        map.put(TaskField.BASELINE_COST, "orig_cost");
        map.put(TaskField.REMAINING_COST, "indep_remain_total_cost");
        map.put(TaskField.REMAINING_WORK, "indep_remain_work_qty");
        map.put(TaskField.DEADLINE, "anticip_end_date");
        map.put(TaskField.DATE1, "suspend_date");
        map.put(TaskField.DATE2, "resume_date");
        map.put(TaskField.TEXT1, "task_code");
        map.put(TaskField.WBS, "wbs_short_name");
        return map;
    }

    public static Map<FieldType, String> getDefaultTaskFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(TaskField.UNIQUE_ID, "task_id");
        map.put(TaskField.GUID, "guid");
        map.put(TaskField.NAME, "task_name");
        map.put(TaskField.ACTUAL_DURATION, "act_drtn_hr_cnt");
        map.put(TaskField.REMAINING_DURATION, "remain_drtn_hr_cnt");
        map.put(TaskField.ACTUAL_WORK, "act_work_qty");
        map.put(TaskField.REMAINING_WORK, "remain_work_qty");
        map.put(TaskField.BASELINE_WORK, "target_work_qty");
        map.put(TaskField.BASELINE_DURATION, "target_drtn_hr_cnt");
        map.put(TaskField.DURATION, "target_drtn_hr_cnt");
        map.put(TaskField.CONSTRAINT_DATE, "cstr_date");
        map.put(TaskField.ACTUAL_START, "act_start_date");
        map.put(TaskField.ACTUAL_FINISH, "act_end_date");
        map.put(TaskField.LATE_START, "late_start_date");
        map.put(TaskField.LATE_FINISH, "late_end_date");
        map.put(TaskField.EARLY_START, "early_start_date");
        map.put(TaskField.EARLY_FINISH, "early_end_date");
        map.put(TaskField.REMAINING_EARLY_START, "restart_date");
        map.put(TaskField.REMAINING_EARLY_FINISH, "reend_date");
        map.put(TaskField.BASELINE_START, "target_start_date");
        map.put(TaskField.BASELINE_FINISH, "target_end_date");
        map.put(TaskField.CONSTRAINT_TYPE, "cstr_type");
        map.put(TaskField.SECONDARY_CONSTRAINT_DATE, "cstr_date2");
        map.put(TaskField.SECONDARY_CONSTRAINT_TYPE, "cstr_type2");
        map.put(TaskField.PRIORITY, "priority_type");
        map.put(TaskField.CREATED, "create_date");
        map.put(TaskField.TYPE, "duration_type");
        map.put(TaskField.FREE_SLACK, "free_float_hr_cnt");
        map.put(TaskField.TOTAL_SLACK, "total_float_hr_cnt");
        map.put(TaskField.TEXT1, "task_code");
        map.put(TaskField.TEXT2, "task_type");
        map.put(TaskField.TEXT3, "status_code");
        map.put(TaskField.NUMBER1, "rsrc_id");
        return map;
    }

    public static Map<FieldType, String> getDefaultAssignmentFieldMap() {
        LinkedHashMap<FieldType, String> map = new LinkedHashMap<FieldType, String>();
        map.put(AssignmentField.UNIQUE_ID, "taskrsrc_id");
        map.put(AssignmentField.GUID, "guid");
        map.put(AssignmentField.REMAINING_WORK, "remain_qty");
        map.put(AssignmentField.BASELINE_WORK, "target_qty");
        map.put(AssignmentField.ACTUAL_OVERTIME_WORK, "act_ot_qty");
        map.put(AssignmentField.BASELINE_COST, "target_cost");
        map.put(AssignmentField.ACTUAL_OVERTIME_COST, "act_ot_cost");
        map.put(AssignmentField.REMAINING_COST, "remain_cost");
        map.put(AssignmentField.ACTUAL_START, "act_start_date");
        map.put(AssignmentField.ACTUAL_FINISH, "act_end_date");
        map.put(AssignmentField.BASELINE_START, "target_start_date");
        map.put(AssignmentField.BASELINE_FINISH, "target_end_date");
        map.put(AssignmentField.ASSIGNMENT_DELAY, "target_lag_drtn_hr_cnt");
        return map;
    }

    public static Map<FieldType, String> getDefaultAliases() {
        HashMap<FieldType, String> map = new HashMap<FieldType, String>();
        map.put(TaskField.DATE1, "Suspend Date");
        map.put(TaskField.DATE2, "Resume Date");
        map.put(TaskField.TEXT1, "Code");
        map.put(TaskField.TEXT2, "Activity Type");
        map.put(TaskField.TEXT3, "Status");
        map.put(TaskField.NUMBER1, "Primary Resource Unique ID");
        return map;
    }

    static {
        RESOURCE_TYPE_MAP.put(null, ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("RT_Labor", ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("RT_Mat", ResourceType.MATERIAL);
        RESOURCE_TYPE_MAP.put("RT_Equip", ResourceType.COST);
        CONSTRAINT_TYPE_MAP = new HashMap<String, ConstraintType>();
        CONSTRAINT_TYPE_MAP.put("CS_MSO", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MSOB", ConstraintType.START_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MSOA", ConstraintType.START_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MEO", ConstraintType.MUST_FINISH_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MEOB", ConstraintType.FINISH_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_MEOA", ConstraintType.FINISH_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("CS_ALAP", ConstraintType.AS_LATE_AS_POSSIBLE);
        CONSTRAINT_TYPE_MAP.put("CS_MANDSTART", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MANDFIN", ConstraintType.MUST_FINISH_ON);
        CONSTRAINT_TYPE_MAP.put("CS_MANDSTART", ConstraintType.MANDATORY_START);
        CONSTRAINT_TYPE_MAP.put("CS_MANDFIN", ConstraintType.MANDATORY_FINISH);
        PRIORITY_MAP = new HashMap<String, Priority>();
        PRIORITY_MAP.put("PT_Top", Priority.getInstance(900));
        PRIORITY_MAP.put("PT_High", Priority.getInstance(600));
        PRIORITY_MAP.put("PT_Normal", Priority.getInstance(500));
        PRIORITY_MAP.put("PT_Low", Priority.getInstance(400));
        PRIORITY_MAP.put("PT_Lowest", Priority.getInstance(100));
        RELATION_TYPE_MAP = new HashMap<String, RelationType>();
        RELATION_TYPE_MAP.put("PR_FS", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("PR_FF", RelationType.FINISH_FINISH);
        RELATION_TYPE_MAP.put("PR_SS", RelationType.START_START);
        RELATION_TYPE_MAP.put("PR_SF", RelationType.START_FINISH);
        TASK_TYPE_MAP = new HashMap<String, TaskType>();
        TASK_TYPE_MAP.put("DT_FixedDrtn", TaskType.FIXED_DURATION);
        TASK_TYPE_MAP.put("DT_FixedQty", TaskType.FIXED_UNITS);
        TASK_TYPE_MAP.put("DT_FixedDUR2", TaskType.FIXED_WORK);
        TASK_TYPE_MAP.put("DT_FixedRate", TaskType.FIXED_WORK);
        MILESTONE_MAP = new HashMap<String, Boolean>();
        MILESTONE_MAP.put("TT_Task", Boolean.FALSE);
        MILESTONE_MAP.put("TT_Rsrc", Boolean.FALSE);
        MILESTONE_MAP.put("TT_LOE", Boolean.FALSE);
        MILESTONE_MAP.put("TT_Mile", Boolean.TRUE);
        MILESTONE_MAP.put("TT_FinMile", Boolean.TRUE);
        MILESTONE_MAP.put("TT_WBS", Boolean.FALSE);
        TIME_UNIT_MAP = new HashMap<String, TimeUnit>();
        TIME_UNIT_MAP.put("QT_Minute", TimeUnit.MINUTES);
        TIME_UNIT_MAP.put("QT_Hour", TimeUnit.HOURS);
        TIME_UNIT_MAP.put("QT_Day", TimeUnit.DAYS);
        TIME_UNIT_MAP.put("QT_Week", TimeUnit.WEEKS);
        TIME_UNIT_MAP.put("QT_Month", TimeUnit.MONTHS);
        TIME_UNIT_MAP.put("QT_Year", TimeUnit.YEARS);
        CURRENCY_SYMBOL_POSITION_MAP = new HashMap<String, CurrencySymbolPosition>();
        CURRENCY_SYMBOL_POSITION_MAP.put("#1.1", CurrencySymbolPosition.BEFORE);
        CURRENCY_SYMBOL_POSITION_MAP.put("1.1#", CurrencySymbolPosition.AFTER);
        CURRENCY_SYMBOL_POSITION_MAP.put("# 1.1", CurrencySymbolPosition.BEFORE_WITH_SPACE);
        CURRENCY_SYMBOL_POSITION_MAP.put("1.1 #", CurrencySymbolPosition.AFTER_WITH_SPACE);
        STATICTYPE_UDF_MAP = new HashMap<String, Boolean>();
        STATICTYPE_UDF_MAP.put("UDF_G0", Boolean.FALSE);
        STATICTYPE_UDF_MAP.put("UDF_G1", Boolean.FALSE);
        STATICTYPE_UDF_MAP.put("UDF_G2", Boolean.FALSE);
        STATICTYPE_UDF_MAP.put("UDF_G3", Boolean.TRUE);
        STATICTYPE_UDF_MAP.put("UDF_G4", Boolean.TRUE);
        FIELD_TYPE_MAP = new HashMap<String, FieldTypeClass>();
        FIELD_TYPE_MAP.put("PROJWBS", FieldTypeClass.TASK);
        FIELD_TYPE_MAP.put("TASK", FieldTypeClass.TASK);
        FIELD_TYPE_MAP.put("RSRC", FieldTypeClass.RESOURCE);
        FIELD_TYPE_MAP.put("TASKRSRC", FieldTypeClass.ASSIGNMENT);
    }
}

