/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.DataType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.primavera.DatatypeConverter;
import net.sf.mpxj.primavera.UserFieldDataType;
import net.sf.mpxj.primavera.schema.APIBusinessObjects;
import net.sf.mpxj.primavera.schema.ActivityType;
import net.sf.mpxj.primavera.schema.CalendarType;
import net.sf.mpxj.primavera.schema.CurrencyType;
import net.sf.mpxj.primavera.schema.ObjectFactory;
import net.sf.mpxj.primavera.schema.ProjectType;
import net.sf.mpxj.primavera.schema.RelationshipType;
import net.sf.mpxj.primavera.schema.ResourceAssignmentType;
import net.sf.mpxj.primavera.schema.UDFAssignmentType;
import net.sf.mpxj.primavera.schema.UDFTypeType;
import net.sf.mpxj.primavera.schema.WBSType;
import net.sf.mpxj.primavera.schema.WorkTimeType;
import net.sf.mpxj.writer.AbstractProjectWriter;

public final class PrimaveraPMFileWriter
extends AbstractProjectWriter {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private static final String NILLABLE_STYLESHEET = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><xsl:output method=\"xml\" indent=\"yes\"/><xsl:template match=\"node()[not(@xsi:nil = 'true')]|@*\"><xsl:copy><xsl:apply-templates select=\"node()|@*\"/></xsl:copy></xsl:template></xsl:stylesheet>";
    private static final Integer PROJECT_OBJECT_ID;
    private static final String PROJECT_ID = "PROJECT";
    private static final String RESOURCE_ID_PREFIX = "RESOURCE-";
    private static final String DEFAULT_WBS_CODE = "WBS";
    private static final Integer DEFAULT_CURRENCY_ID;
    private static final String[] DAY_NAMES;
    private static final Map<RelationType, String> RELATION_TYPE_MAP;
    private static final Map<TaskType, String> DURATION_TYPE_MAP;
    private static final Map<ConstraintType, String> CONSTRAINT_TYPE_MAP;
    private static final Map<String, String> ACTIVITY_TYPE_MAP;
    private ProjectFile m_projectFile;
    private ObjectFactory m_factory;
    private APIBusinessObjects m_apibo;
    private ProjectType m_project;
    private int m_wbsSequence;
    private int m_relationshipObjectID;
    private TaskField m_activityIDField;
    private TaskField m_activityTypeField;
    private List<CustomField> m_sortedCustomFieldsList;

    public void setActivityIdField(TaskField field) {
        this.m_activityIDField = field;
    }

    public TaskField getActivityIdField() {
        return this.m_activityIDField;
    }

    public void setActivityTypeField(TaskField field) {
        this.m_activityTypeField = field;
    }

    public TaskField getActivityTypeField() {
        return this.m_activityTypeField;
    }

    @Override
    public void write(ProjectFile projectFile, OutputStream stream) throws IOException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            TransformerFactory transFact = TransformerFactory.newInstance();
            TransformerHandler handler = ((SAXTransformerFactory)transFact).newTransformerHandler(new StreamSource(new ByteArrayInputStream(NILLABLE_STYLESHEET.getBytes())));
            handler.setResult(new StreamResult(stream));
            Transformer transformer = handler.getTransformer();
            try {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_projectFile = projectFile;
            Marshaller marshaller = CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.schemaLocation", "");
            this.m_factory = new ObjectFactory();
            this.m_apibo = this.m_factory.createAPIBusinessObjects();
            this.configureCustomFields();
            this.populateSortedCustomFieldsList();
            this.writeCurrency();
            this.writeUserFieldDefinitions();
            this.writeProjectProperties();
            this.writeCalendars();
            this.writeResources();
            this.writeTasks();
            this.writeAssignments();
            marshaller.marshal((Object)this.m_apibo, handler);
        }
        catch (JAXBException ex) {
            throw new IOException(ex.toString());
        }
        catch (TransformerConfigurationException ex) {
            throw new IOException(ex.toString());
        }
        finally {
            this.m_projectFile = null;
            this.m_factory = null;
            this.m_apibo = null;
            this.m_project = null;
            this.m_wbsSequence = 0;
            this.m_relationshipObjectID = 0;
            this.m_sortedCustomFieldsList = null;
        }
    }

    private void writeCurrency() {
        ProjectProperties props = this.m_projectFile.getProjectProperties();
        CurrencyType currency = this.m_factory.createCurrencyType();
        this.m_apibo.getCurrency().add(currency);
        String positiveSymbol = this.getCurrencyFormat(props.getSymbolPosition());
        String negativeSymbol = "(" + positiveSymbol + ")";
        currency.setDecimalPlaces(props.getCurrencyDigits());
        currency.setDecimalSymbol(this.getSymbolName(props.getDecimalSeparator()));
        currency.setDigitGroupingSymbol(this.getSymbolName(props.getThousandsSeparator()));
        currency.setExchangeRate(1.0);
        currency.setId("CUR");
        currency.setName("Default Currency");
        currency.setNegativeSymbol(negativeSymbol);
        currency.setObjectId(DEFAULT_CURRENCY_ID);
        currency.setPositiveSymbol(positiveSymbol);
        currency.setSymbol(props.getCurrencySymbol());
    }

    private String getSymbolName(char c2) {
        String result = null;
        switch (c2) {
            case ',': {
                result = "Comma";
                break;
            }
            case '.': {
                result = "Period";
            }
        }
        return result;
    }

    private String getCurrencyFormat(CurrencySymbolPosition position) {
        String result;
        switch (position) {
            case AFTER: {
                result = "1.1#";
                break;
            }
            case AFTER_WITH_SPACE: {
                result = "1.1 #";
                break;
            }
            case BEFORE_WITH_SPACE: {
                result = "# 1.1";
                break;
            }
            default: {
                result = "#1.1";
            }
        }
        return result;
    }

    private void writeUserFieldDefinitions() {
        for (CustomField cf : this.m_sortedCustomFieldsList) {
            if (cf.getFieldType() == null || cf.getFieldType().getDataType() == null) continue;
            UDFTypeType udf = this.m_factory.createUDFTypeType();
            udf.setObjectId(FieldTypeHelper.getFieldID(cf.getFieldType()));
            udf.setDataType(UserFieldDataType.inferUserFieldDataType(cf.getFieldType().getDataType()));
            udf.setSubjectArea(UserFieldDataType.inferUserFieldSubjectArea(cf.getFieldType()));
            udf.setTitle(cf.getAlias());
            this.m_apibo.getUDFType().add(udf);
        }
    }

    private void writeProjectProperties() {
        this.m_project = this.m_factory.createProjectType();
        this.m_apibo.getProject().add(this.m_project);
        ProjectProperties mpxj = this.m_projectFile.getProjectProperties();
        Task rootTask = this.m_projectFile.getTaskByUniqueID(0);
        UUID guid = rootTask == null ? null : rootTask.getGUID();
        this.m_project.setActivityDefaultActivityType("Task Dependent");
        this.m_project.setActivityDefaultCalendarObjectId(this.getCalendarUniqueID(this.m_projectFile.getDefaultCalendar()));
        this.m_project.setActivityDefaultDurationType("Fixed Duration and Units");
        this.m_project.setActivityDefaultPercentCompleteType("Duration");
        this.m_project.setActivityDefaultPricePerUnit(NumberHelper.DOUBLE_ZERO);
        this.m_project.setActivityIdBasedOnSelectedActivity(Boolean.TRUE);
        this.m_project.setActivityIdIncrement(10);
        this.m_project.setActivityIdPrefix("A");
        this.m_project.setActivityIdSuffix(1000);
        this.m_project.setActivityPercentCompleteBasedOnActivitySteps(Boolean.FALSE);
        this.m_project.setAddActualToRemaining(Boolean.FALSE);
        this.m_project.setAllowNegativeActualUnitsFlag(Boolean.FALSE);
        this.m_project.setAssignmentDefaultDrivingFlag(Boolean.TRUE);
        this.m_project.setAssignmentDefaultRateType("Price / Unit");
        this.m_project.setCheckOutStatus(Boolean.FALSE);
        this.m_project.setCostQuantityRecalculateFlag(Boolean.FALSE);
        this.m_project.setCreateDate(mpxj.getCreationDate());
        this.m_project.setCriticalActivityFloatLimit(NumberHelper.DOUBLE_ZERO);
        this.m_project.setCriticalActivityPathType("Critical Float");
        this.m_project.setDataDate(this.m_projectFile.getProjectProperties().getStatusDate());
        this.m_project.setDefaultPriceTimeUnits("Hour");
        this.m_project.setDiscountApplicationPeriod("Month");
        this.m_project.setEarnedValueComputeType("Activity Percent Complete");
        this.m_project.setEarnedValueETCComputeType("ETC = Remaining Cost for Activity");
        this.m_project.setEarnedValueETCUserValue(0.88);
        this.m_project.setEarnedValueUserPercent(0.06);
        this.m_project.setEnableSummarization(Boolean.TRUE);
        this.m_project.setFiscalYearStartMonth(1);
        this.m_project.setFinishDate(mpxj.getFinishDate());
        this.m_project.setGUID(DatatypeConverter.printUUID(guid));
        this.m_project.setId(PROJECT_ID);
        this.m_project.setLastUpdateDate(mpxj.getLastSaved());
        this.m_project.setLevelingPriority(10);
        this.m_project.setLinkActualToActualThisPeriod(Boolean.TRUE);
        this.m_project.setLinkPercentCompleteWithActual(Boolean.TRUE);
        this.m_project.setLinkPlannedAndAtCompletionFlag(Boolean.TRUE);
        this.m_project.setName(mpxj.getName() == null ? PROJECT_ID : mpxj.getName());
        this.m_project.setObjectId(PROJECT_OBJECT_ID);
        this.m_project.setPlannedStartDate(mpxj.getStartDate());
        this.m_project.setPrimaryResourcesCanMarkActivitiesAsCompleted(Boolean.TRUE);
        this.m_project.setResetPlannedToRemainingFlag(Boolean.FALSE);
        this.m_project.setResourceCanBeAssignedToSameActivityMoreThanOnce(Boolean.TRUE);
        this.m_project.setResourcesCanAssignThemselvesToActivities(Boolean.TRUE);
        this.m_project.setResourcesCanEditAssignmentPercentComplete(Boolean.FALSE);
        this.m_project.setResourcesCanMarkAssignmentAsCompleted(Boolean.FALSE);
        this.m_project.setResourcesCanViewInactiveActivities(Boolean.FALSE);
        this.m_project.setRiskLevel("Medium");
        this.m_project.setStartDate(mpxj.getStartDate());
        this.m_project.setStatus("Active");
        this.m_project.setStrategicPriority(500);
        this.m_project.setSummarizeToWBSLevel(2);
        this.m_project.setSummaryLevel("Assignment Level");
        this.m_project.setUseProjectBaselineForEarnedValue(Boolean.TRUE);
        this.m_project.setWBSCodeSeparator(".");
        this.m_project.getUDF().addAll(this.writeUDFType(FieldTypeClass.PROJECT, mpxj));
    }

    private void writeCalendars() {
        for (ProjectCalendar calendar : this.m_projectFile.getCalendars()) {
            this.writeCalendar(calendar);
        }
    }

    private void writeCalendar(ProjectCalendar mpxj) {
        CalendarType xml = this.m_factory.createCalendarType();
        this.m_apibo.getCalendar().add(xml);
        String type = mpxj.getResource() == null ? "Global" : "Resource";
        xml.setBaseCalendarObjectId(this.getCalendarUniqueID(mpxj.getParent()));
        xml.setIsPersonal(mpxj.getResource() == null ? Boolean.FALSE : Boolean.TRUE);
        xml.setName(mpxj.getName());
        xml.setObjectId(mpxj.getUniqueID());
        xml.setType(type);
        CalendarType.StandardWorkWeek xmlStandardWorkWeek = this.m_factory.createCalendarTypeStandardWorkWeek();
        xml.setStandardWorkWeek(xmlStandardWorkWeek);
        for (Day day : EnumSet.allOf(Day.class)) {
            CalendarType.StandardWorkWeek.StandardWorkHours xmlHours = this.m_factory.createCalendarTypeStandardWorkWeekStandardWorkHours();
            xmlStandardWorkWeek.getStandardWorkHours().add(xmlHours);
            xmlHours.setDayOfWeek(this.getDayName(day));
            for (DateRange range : mpxj.getHours(day)) {
                WorkTimeType xmlWorkTime = this.m_factory.createWorkTimeType();
                xmlHours.getWorkTime().add(xmlWorkTime);
                xmlWorkTime.setStart(range.getStart());
                xmlWorkTime.setFinish(this.getEndTime(range.getEnd()));
            }
        }
        CalendarType.HolidayOrExceptions xmlExceptions = this.m_factory.createCalendarTypeHolidayOrExceptions();
        xml.setHolidayOrExceptions(xmlExceptions);
        if (!mpxj.getCalendarExceptions().isEmpty()) {
            Calendar calendar = DateHelper.popCalendar();
            for (ProjectCalendarException mpxjException : mpxj.getCalendarExceptions()) {
                calendar.setTime(mpxjException.getFromDate());
                while (calendar.getTimeInMillis() < mpxjException.getToDate().getTime()) {
                    CalendarType.HolidayOrExceptions.HolidayOrException xmlException = this.m_factory.createCalendarTypeHolidayOrExceptionsHolidayOrException();
                    xmlExceptions.getHolidayOrException().add(xmlException);
                    xmlException.setDate(calendar.getTime());
                    for (DateRange range : mpxjException) {
                        WorkTimeType xmlHours = this.m_factory.createWorkTimeType();
                        xmlException.getWorkTime().add(xmlHours);
                        xmlHours.setStart(range.getStart());
                        if (range.getEnd() == null) continue;
                        xmlHours.setFinish(this.getEndTime(range.getEnd()));
                    }
                    calendar.add(6, 1);
                }
            }
            DateHelper.pushCalendar(calendar);
        }
    }

    private void writeResources() {
        for (Resource resource : this.m_projectFile.getResources()) {
            if (resource.getUniqueID() == 0) continue;
            this.writeResource(resource);
        }
    }

    private void writeResource(Resource mpxj) {
        net.sf.mpxj.primavera.schema.ResourceType xml = this.m_factory.createResourceType();
        this.m_apibo.getResource().add(xml);
        xml.setAutoComputeActuals(Boolean.TRUE);
        xml.setCalculateCostFromUnits(Boolean.TRUE);
        xml.setCalendarObjectId(this.getCalendarUniqueID(mpxj.getResourceCalendar()));
        xml.setCurrencyObjectId(DEFAULT_CURRENCY_ID);
        xml.setDefaultUnitsPerTime(1.0);
        xml.setEmailAddress(mpxj.getEmailAddress());
        xml.setGUID(DatatypeConverter.printUUID(mpxj.getGUID()));
        xml.setId(RESOURCE_ID_PREFIX + mpxj.getUniqueID());
        xml.setIsActive(Boolean.TRUE);
        xml.setMaxUnitsPerTime(this.getPercentage(mpxj.getMaxUnits()));
        xml.setName(mpxj.getName());
        xml.setObjectId(mpxj.getUniqueID());
        xml.setParentObjectId(mpxj.getParentID());
        xml.setResourceNotes(mpxj.getNotes());
        xml.setResourceType(this.getResourceType(mpxj));
        xml.getUDF().addAll(this.writeUDFType(FieldTypeClass.RESOURCE, mpxj));
    }

    private void writeTasks() {
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.writeTask(task);
        }
    }

    private void writeChildTasks(Task parent) {
        for (Task task : parent.getChildTasks()) {
            this.writeTask(task);
        }
    }

    private void writeTask(Task task) {
        if (!task.getNull()) {
            if (this.extractAndConvertTaskType(task) == null || task.getSummary()) {
                this.writeWBS(task);
            } else {
                this.writeActivity(task);
            }
        }
    }

    private void writeWBS(Task mpxj) {
        if (mpxj.getUniqueID() != 0) {
            WBSType xml = this.m_factory.createWBSType();
            this.m_project.getWBS().add(xml);
            String code = mpxj.getWBS();
            code = code == null || code.length() == 0 ? DEFAULT_WBS_CODE : code;
            Task parentTask = mpxj.getParentTask();
            Integer parentObjectID = parentTask == null ? null : parentTask.getUniqueID();
            xml.setCode(code);
            xml.setGUID(DatatypeConverter.printUUID(mpxj.getGUID()));
            xml.setName(mpxj.getName());
            xml.setObjectId(mpxj.getUniqueID());
            xml.setParentObjectId(parentObjectID);
            xml.setProjectObjectId(PROJECT_OBJECT_ID);
            xml.setSequenceNumber(this.m_wbsSequence++);
            xml.setStatus("Active");
        }
        this.writeChildTasks(mpxj);
    }

    private void writeActivity(Task mpxj) {
        ActivityType xml = this.m_factory.createActivityType();
        this.m_project.getActivity().add(xml);
        Task parentTask = mpxj.getParentTask();
        Integer parentObjectID = parentTask == null ? null : parentTask.getUniqueID();
        xml.setActualStartDate(mpxj.getActualStart());
        xml.setActualFinishDate(mpxj.getActualFinish());
        xml.setAtCompletionDuration(this.getDuration(mpxj.getDuration()));
        xml.setCalendarObjectId(this.getCalendarUniqueID(mpxj.getCalendar()));
        xml.setDurationPercentComplete(this.getPercentage(mpxj.getPercentageComplete()));
        xml.setDurationType(DURATION_TYPE_MAP.get(mpxj.getType()));
        xml.setFinishDate(mpxj.getFinish());
        xml.setGUID(DatatypeConverter.printUUID(mpxj.getGUID()));
        xml.setId(this.getActivityID(mpxj));
        xml.setName(mpxj.getName());
        xml.setObjectId(mpxj.getUniqueID());
        xml.setPercentComplete(this.getPercentage(mpxj.getPercentageComplete()));
        xml.setPercentCompleteType("Duration");
        xml.setPrimaryConstraintType(CONSTRAINT_TYPE_MAP.get(mpxj.getConstraintType()));
        xml.setPrimaryConstraintDate(mpxj.getConstraintDate());
        xml.setPlannedDuration(this.getDuration(mpxj.getDuration()));
        xml.setPlannedFinishDate(mpxj.getBaselineFinish());
        xml.setPlannedStartDate(mpxj.getBaselineStart());
        xml.setProjectObjectId(PROJECT_OBJECT_ID);
        xml.setRemainingDuration(this.getDuration(mpxj.getRemainingDuration()));
        xml.setRemainingLateStartDate(mpxj.getLateStart());
        xml.setRemainingLateFinishDate(mpxj.getLateFinish());
        xml.setRemainingEarlyStartDate(mpxj.getEarlyStart());
        xml.setRemainingEarlyFinishDate(mpxj.getEarlyFinish());
        xml.setRemainingLaborCost(NumberHelper.DOUBLE_ZERO);
        xml.setRemainingLaborUnits(NumberHelper.DOUBLE_ZERO);
        xml.setRemainingNonLaborCost(NumberHelper.DOUBLE_ZERO);
        xml.setRemainingNonLaborUnits(NumberHelper.DOUBLE_ZERO);
        xml.setStartDate(mpxj.getStart());
        xml.setStatus(this.getActivityStatus(mpxj));
        xml.setType(this.extractAndConvertTaskType(mpxj));
        xml.setWBSObjectId(parentObjectID);
        xml.getUDF().addAll(this.writeUDFType(FieldTypeClass.TASK, mpxj));
        this.writePredecessors(mpxj);
    }

    private String extractAndConvertTaskType(Task task) {
        String activityType = (String)task.getCachedValue(this.m_activityTypeField);
        if (activityType == null) {
            activityType = "Resource Dependent";
        } else if (ACTIVITY_TYPE_MAP.containsKey(activityType)) {
            activityType = ACTIVITY_TYPE_MAP.get(activityType);
        }
        return activityType;
    }

    private void writeAssignments() {
        for (ResourceAssignment assignment : this.m_projectFile.getResourceAssignments()) {
            Task task;
            Resource resource = assignment.getResource();
            if (resource == null || (task = assignment.getTask()) == null || task.getUniqueID() == 0 || task.getSummary()) continue;
            this.writeAssignment(assignment);
        }
    }

    private void writeAssignment(ResourceAssignment mpxj) {
        ResourceAssignmentType xml = this.m_factory.createResourceAssignmentType();
        this.m_project.getResourceAssignment().add(xml);
        Task task = mpxj.getTask();
        Task parentTask = task.getParentTask();
        Integer parentTaskUniqueID = parentTask == null ? null : parentTask.getUniqueID();
        xml.setActivityObjectId(mpxj.getTaskUniqueID());
        xml.setActualCost(this.getDouble(mpxj.getActualCost()));
        xml.setActualFinishDate(mpxj.getActualFinish());
        xml.setActualOvertimeUnits(this.getDuration(mpxj.getActualOvertimeWork()));
        xml.setActualRegularUnits(this.getDuration(mpxj.getActualWork()));
        xml.setActualStartDate(mpxj.getActualStart());
        xml.setActualUnits(this.getDuration(mpxj.getActualWork()));
        xml.setAtCompletionUnits(this.getDuration(mpxj.getRemainingWork()));
        xml.setPlannedCost(this.getDouble(mpxj.getActualCost()));
        xml.setFinishDate(mpxj.getFinish());
        xml.setGUID(DatatypeConverter.printUUID(mpxj.getGUID()));
        xml.setObjectId(mpxj.getUniqueID());
        xml.setPlannedDuration(this.getDuration(mpxj.getWork()));
        xml.setPlannedFinishDate(mpxj.getFinish());
        xml.setPlannedStartDate(mpxj.getStart());
        xml.setPlannedUnits(this.getDuration(mpxj.getWork()));
        xml.setPlannedUnitsPerTime(this.getPercentage(mpxj.getUnits()));
        xml.setProjectObjectId(PROJECT_OBJECT_ID);
        xml.setRateSource("Resource");
        xml.setRemainingCost(this.getDouble(mpxj.getActualCost()));
        xml.setRemainingDuration(this.getDuration(mpxj.getRemainingWork()));
        xml.setRemainingFinishDate(mpxj.getFinish());
        xml.setRemainingStartDate(mpxj.getStart());
        xml.setRemainingUnits(this.getDuration(mpxj.getRemainingWork()));
        xml.setRemainingUnitsPerTime(this.getPercentage(mpxj.getUnits()));
        xml.setResourceObjectId(mpxj.getResourceUniqueID());
        xml.setStartDate(mpxj.getStart());
        xml.setWBSObjectId(parentTaskUniqueID);
        xml.getUDF().addAll(this.writeUDFType(FieldTypeClass.ASSIGNMENT, mpxj));
    }

    private void writePredecessors(Task task) {
        List<Relation> relations = task.getPredecessors();
        for (Relation mpxj : relations) {
            RelationshipType xml = this.m_factory.createRelationshipType();
            this.m_project.getRelationship().add(xml);
            xml.setLag(this.getDuration(mpxj.getLag()));
            xml.setObjectId(++this.m_relationshipObjectID);
            xml.setPredecessorActivityObjectId(mpxj.getTargetTask().getUniqueID());
            xml.setSuccessorActivityObjectId(mpxj.getSourceTask().getUniqueID());
            xml.setPredecessorProjectObjectId(PROJECT_OBJECT_ID);
            xml.setSuccessorProjectObjectId(PROJECT_OBJECT_ID);
            xml.setType(RELATION_TYPE_MAP.get(mpxj.getType()));
        }
    }

    private List<UDFAssignmentType> writeUDFType(FieldTypeClass type, FieldContainer mpxj) {
        ArrayList<UDFAssignmentType> out = new ArrayList<UDFAssignmentType>();
        for (CustomField cf : this.m_sortedCustomFieldsList) {
            Object value;
            FieldType fieldType = cf.getFieldType();
            if (fieldType == null || type != fieldType.getFieldTypeClass() || !FieldTypeHelper.valueIsNotDefault(fieldType, value = mpxj.getCachedValue(fieldType))) continue;
            UDFAssignmentType udf = this.m_factory.createUDFAssignmentType();
            udf.setTypeObjectId(FieldTypeHelper.getFieldID(fieldType));
            this.setUserFieldValue(udf, fieldType.getDataType(), value);
            out.add(udf);
        }
        return out;
    }

    private void setUserFieldValue(UDFAssignmentType udf, DataType dataType, Object value) {
        switch (dataType) {
            case DURATION: {
                udf.setTextValue(((Duration)value).toString());
                break;
            }
            case CURRENCY: {
                if (!(value instanceof Double)) {
                    value = ((Number)value).doubleValue();
                }
                udf.setCostValue((Double)value);
                break;
            }
            case BINARY: {
                udf.setTextValue("");
                break;
            }
            case STRING: {
                udf.setTextValue((String)value);
                break;
            }
            case DATE: {
                udf.setStartDateValue((Date)value);
                break;
            }
            case NUMERIC: {
                if (!(value instanceof Double)) {
                    value = ((Number)value).doubleValue();
                }
                udf.setDoubleValue((Double)value);
                break;
            }
            case BOOLEAN: {
                udf.setIntegerValue(BooleanHelper.getBoolean((Boolean)value) ? Integer.valueOf(1) : Integer.valueOf(0));
                break;
            }
            case INTEGER: 
            case SHORT: {
                udf.setIntegerValue(NumberHelper.getInteger((Number)value));
                break;
            }
            default: {
                throw new RuntimeException("Unconvertible data type: " + dataType);
            }
        }
    }

    private Double getDuration(Duration duration) {
        Double result;
        if (duration == null) {
            result = null;
        } else {
            if (duration.getUnits() != TimeUnit.HOURS) {
                duration = duration.convertUnits(TimeUnit.HOURS, this.m_projectFile.getProjectProperties());
            }
            result = duration.getDuration();
        }
        return result;
    }

    private String getDayName(Day day) {
        return DAY_NAMES[day.getValue() - 1];
    }

    private String getResourceType(Resource resource) {
        String result;
        ResourceType type = resource.getType();
        if (type == null) {
            type = ResourceType.WORK;
        }
        switch (type) {
            case MATERIAL: {
                result = "Material";
                break;
            }
            case COST: {
                result = "Nonlabor";
                break;
            }
            default: {
                result = "Labor";
            }
        }
        return result;
    }

    private Double getPercentage(Number number) {
        Double result = null;
        if (number != null) {
            result = number.doubleValue() / 100.0;
        }
        return result;
    }

    private Double getDouble(Number number) {
        Double result = null;
        if (number != null) {
            result = number.doubleValue();
        }
        return result;
    }

    private Date getEndTime(Date date) {
        return new Date(date.getTime() - 60000L);
    }

    private Integer getCalendarUniqueID(ProjectCalendar calendar) {
        return calendar == null ? null : calendar.getUniqueID();
    }

    private String getActivityStatus(Task mpxj) {
        String result = mpxj.getActualStart() == null ? "Not Started" : (mpxj.getActualFinish() == null ? "In Progress" : "Completed");
        return result;
    }

    private String getActivityID(Task task) {
        Object value;
        String result = null;
        if (this.m_activityIDField != null && (value = task.getCachedValue(this.m_activityIDField)) != null) {
            result = value.toString();
        }
        return result;
    }

    private void configureCustomFields() {
        CustomFieldContainer customFields = this.m_projectFile.getCustomFields();
        if (this.m_activityIDField == null) {
            this.m_activityIDField = (TaskField)customFields.getFieldByAlias(FieldTypeClass.TASK, "Code");
            if (this.m_activityIDField == null) {
                this.m_activityIDField = TaskField.WBS;
            }
        }
        if (this.m_activityTypeField == null) {
            this.m_activityTypeField = (TaskField)customFields.getFieldByAlias(FieldTypeClass.TASK, "Activity Type");
        }
    }

    private void populateSortedCustomFieldsList() {
        this.m_sortedCustomFieldsList = new ArrayList<CustomField>();
        for (CustomField field : this.m_projectFile.getCustomFields()) {
            FieldType fieldType = field.getFieldType();
            if (fieldType == null) continue;
            this.m_sortedCustomFieldsList.add(field);
        }
        Collections.sort(this.m_sortedCustomFieldsList, new Comparator<CustomField>(){

            @Override
            public int compare(CustomField customField1, CustomField customField2) {
                FieldType o1 = customField1.getFieldType();
                FieldType o2 = customField2.getFieldType();
                String name1 = o1.getClass().getSimpleName() + "." + o1.getName() + " " + customField1.getAlias();
                String name2 = o2.getClass().getSimpleName() + "." + o2.getName() + " " + customField2.getAlias();
                return name1.compareTo(name2);
            }
        });
    }

    ProjectFile getProjectFile() {
        return this.m_projectFile;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance("net.sf.mpxj.primavera.schema", PrimaveraPMFileWriter.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
        PROJECT_OBJECT_ID = 1;
        DEFAULT_CURRENCY_ID = 1;
        DAY_NAMES = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        RELATION_TYPE_MAP = new HashMap<RelationType, String>();
        RELATION_TYPE_MAP.put(RelationType.FINISH_START, "Finish to Start");
        RELATION_TYPE_MAP.put(RelationType.FINISH_FINISH, "Finish to Finish");
        RELATION_TYPE_MAP.put(RelationType.START_START, "Start to Start");
        RELATION_TYPE_MAP.put(RelationType.START_FINISH, "Start to Finish");
        DURATION_TYPE_MAP = new HashMap<TaskType, String>();
        DURATION_TYPE_MAP.put(TaskType.FIXED_DURATION, "Fixed Duration and Units/Time");
        DURATION_TYPE_MAP.put(TaskType.FIXED_UNITS, "Fixed Units");
        DURATION_TYPE_MAP.put(TaskType.FIXED_WORK, "Fixed Duration and Units");
        CONSTRAINT_TYPE_MAP = new HashMap<ConstraintType, String>();
        CONSTRAINT_TYPE_MAP.put(ConstraintType.MUST_START_ON, "Start On");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.START_NO_LATER_THAN, "Start On or Before");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.START_NO_EARLIER_THAN, "Start On or After");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.MUST_FINISH_ON, "Finish On");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.FINISH_NO_LATER_THAN, "Finish On or Before");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.FINISH_NO_EARLIER_THAN, "Finish On or After");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.AS_LATE_AS_POSSIBLE, "As Late As Possible");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.MANDATORY_START, "Mandatory Start");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.MANDATORY_FINISH, "Mandatory Finish");
        ACTIVITY_TYPE_MAP = new HashMap<String, String>();
        ACTIVITY_TYPE_MAP.put("TT_Task", "Task Dependent");
        ACTIVITY_TYPE_MAP.put("TT_Rsrc", "Resource Dependent");
        ACTIVITY_TYPE_MAP.put("TT_LOE", "Level of Effort");
        ACTIVITY_TYPE_MAP.put("TT_Mile", "Start Milestone");
        ACTIVITY_TYPE_MAP.put("TT_FinMile", "Finish Milestone");
        ACTIVITY_TYPE_MAP.put("TT_WBS", "WBS Summary");
    }
}

