/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.mpxj.ActivityCode;
import net.sf.mpxj.ActivityCodeContainer;
import net.sf.mpxj.ActivityCodeValue;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.primavera.ActivitySorter;
import net.sf.mpxj.primavera.DatatypeConverter;
import net.sf.mpxj.primavera.NamespaceFilter;
import net.sf.mpxj.primavera.PrimaveraInputStreamReader;
import net.sf.mpxj.primavera.UserFieldCounters;
import net.sf.mpxj.primavera.UserFieldDataType;
import net.sf.mpxj.primavera.WbsRowComparatorPMXML;
import net.sf.mpxj.primavera.schema.APIBusinessObjects;
import net.sf.mpxj.primavera.schema.ActivityCodeType;
import net.sf.mpxj.primavera.schema.ActivityCodeTypeType;
import net.sf.mpxj.primavera.schema.ActivityType;
import net.sf.mpxj.primavera.schema.CalendarType;
import net.sf.mpxj.primavera.schema.CodeAssignmentType;
import net.sf.mpxj.primavera.schema.CurrencyType;
import net.sf.mpxj.primavera.schema.GlobalPreferencesType;
import net.sf.mpxj.primavera.schema.ProjectType;
import net.sf.mpxj.primavera.schema.RelationshipType;
import net.sf.mpxj.primavera.schema.ResourceAssignmentType;
import net.sf.mpxj.primavera.schema.UDFAssignmentType;
import net.sf.mpxj.primavera.schema.UDFTypeType;
import net.sf.mpxj.primavera.schema.WBSType;
import net.sf.mpxj.primavera.schema.WorkTimeType;
import net.sf.mpxj.reader.AbstractProjectReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class PrimaveraPMFileReader
extends AbstractProjectReader {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private List<ProjectListener> m_projectListeners;
    private Map<Integer, Integer> m_clashMap = new HashMap<Integer, Integer>();
    private Map<Integer, ActivityCodeValue> m_activityCodeMap = new HashMap<Integer, ActivityCodeValue>();
    private UserFieldCounters m_taskUdfCounters = new UserFieldCounters();
    private UserFieldCounters m_resourceUdfCounters = new UserFieldCounters();
    private UserFieldCounters m_assignmentUdfCounters = new UserFieldCounters();
    private Map<Integer, FieldType> m_fieldTypeMap = new HashMap<Integer, FieldType>();
    private boolean m_wbsIsFullPath = true;
    private static final Map<String, ResourceType> RESOURCE_TYPE_MAP;
    private static final Map<String, ConstraintType> CONSTRAINT_TYPE_MAP;
    private static final Map<String, Priority> PRIORITY_MAP;
    private static final Map<String, RelationType> RELATION_TYPE_MAP;
    private static final Map<String, Day> DAY_MAP;
    private static final Map<String, Boolean> MILESTONE_MAP;
    private static final Map<String, FieldTypeClass> FIELD_TYPE_MAP;
    private static final Set<TaskField> RESERVED_TASK_FIELDS;
    private static final WbsRowComparatorPMXML WBS_ROW_COMPARATOR;
    private static final Pattern ENCODING_PATTERN;

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    public boolean getWbsIsFullPath() {
        return this.m_wbsIsFullPath;
    }

    public void setWbsIsFullPath(boolean wbsIsFullPath) {
        this.m_wbsIsFullPath = wbsIsFullPath;
    }

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoTaskUniqueID(false);
            config.setAutoResourceUniqueID(false);
            config.setAutoCalendarUniqueID(false);
            config.setAutoAssignmentUniqueID(false);
            config.setAutoWBS(false);
            this.m_projectFile.getProjectProperties().setFileApplication("Primavera");
            this.m_projectFile.getProjectProperties().setFileType("PMXML");
            CustomFieldContainer fields = this.m_projectFile.getCustomFields();
            fields.getCustomField(TaskField.TEXT1).setAlias("Code");
            fields.getCustomField(TaskField.TEXT2).setAlias("Activity Type");
            fields.getCustomField(TaskField.TEXT3).setAlias("Status");
            fields.getCustomField(TaskField.NUMBER1).setAlias("Primary Resource Unique ID");
            this.m_eventManager.addProjectListeners(this.m_projectListeners);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
            NamespaceFilter filter = new NamespaceFilter();
            filter.setParent(xmlReader);
            UnmarshallerHandler unmarshallerHandler = unmarshaller.getUnmarshallerHandler();
            filter.setContentHandler(unmarshallerHandler);
            filter.parse(this.configureInputSource(stream));
            APIBusinessObjects apibo = (APIBusinessObjects)unmarshallerHandler.getResult();
            List<ProjectType> projects = apibo.getProject();
            ProjectType project = null;
            for (ProjectType currentProject : projects) {
                if (BooleanHelper.getBoolean(currentProject.isExternal())) continue;
                project = currentProject;
                break;
            }
            if (project == null) {
                throw new MPXJException("Unable to locate any non-external projects in a list of " + projects.size() + " projects");
            }
            this.processProjectUDFs(apibo);
            this.processProjectProperties(apibo, project);
            this.processActivityCodes(apibo, project);
            this.processCalendars(apibo);
            this.processResources(apibo);
            this.processTasks(project);
            this.processPredecessors(project);
            this.processAssignments(project);
            this.m_projectFile.updateStructure();
            config.updateUniqueCounters();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (ParserConfigurationException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (JAXBException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (SAXException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (IOException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_clashMap.clear();
            this.m_activityCodeMap.clear();
        }
    }

    private InputSource configureInputSource(InputStream stream) throws IOException {
        int bufferSize = 512;
        BufferedInputStream bis = new BufferedInputStream(stream);
        bis.mark(bufferSize);
        byte[] buffer = new byte[bufferSize];
        bis.read(buffer);
        bis.reset();
        Matcher matcher = ENCODING_PATTERN.matcher(new String(buffer));
        InputSource result = matcher.find() ? new InputSource(new PrimaveraInputStreamReader((InputStream)bis, matcher.group(1))) : new InputSource(bis);
        return result;
    }

    private void processProjectUDFs(APIBusinessObjects apibo) {
        for (UDFTypeType udf : apibo.getUDFType()) {
            this.processUDF(udf);
        }
    }

    private void processUDF(UDFTypeType udf) {
        String name;
        UserFieldDataType dataType;
        FieldType field;
        FieldTypeClass fieldType = FIELD_TYPE_MAP.get(udf.getSubjectArea());
        if (fieldType != null && (field = this.addUserDefinedField(fieldType, dataType = UserFieldDataType.getInstanceFromXmlName(udf.getDataType()), name = udf.getTitle())) != null) {
            this.m_fieldTypeMap.put(udf.getObjectId(), field);
        }
    }

    private FieldType addUserDefinedField(FieldTypeClass fieldType, UserFieldDataType dataType, String name) {
        FieldType field = null;
        try {
            switch (fieldType) {
                case TASK: {
                    while (RESERVED_TASK_FIELDS.contains(field = (FieldType)this.m_taskUdfCounters.nextField(TaskField.class, dataType))) {
                    }
                    this.m_projectFile.getCustomFields().getCustomField(field).setAlias(name);
                    break;
                }
                case RESOURCE: {
                    field = this.m_resourceUdfCounters.nextField(ResourceField.class, dataType);
                    this.m_projectFile.getCustomFields().getCustomField(field).setAlias(name);
                    break;
                }
                case ASSIGNMENT: {
                    field = this.m_assignmentUdfCounters.nextField(AssignmentField.class, dataType);
                    this.m_projectFile.getCustomFields().getCustomField(field).setAlias(name);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return field;
    }

    private void processProjectProperties(APIBusinessObjects apibo, ProjectType project) {
        ProjectProperties properties = this.m_projectFile.getProjectProperties();
        properties.setCreationDate(project.getCreateDate());
        properties.setFinishDate(project.getFinishDate());
        properties.setName(project.getName());
        properties.setStartDate(project.getPlannedStartDate());
        properties.setStatusDate(project.getDataDate());
        properties.setProjectTitle(project.getId());
        properties.setUniqueID(project.getObjectId() == null ? null : project.getObjectId().toString());
        List<GlobalPreferencesType> list = apibo.getGlobalPreferences();
        if (!list.isEmpty()) {
            GlobalPreferencesType prefs = list.get(0);
            properties.setCreationDate(prefs.getCreateDate());
            properties.setLastSaved(prefs.getLastUpdateDate());
            properties.setMinutesPerDay((int)(NumberHelper.getDouble(prefs.getHoursPerDay()) * 60.0));
            properties.setMinutesPerWeek((int)(NumberHelper.getDouble(prefs.getHoursPerWeek()) * 60.0));
            properties.setWeekStartDay(Day.getInstance(NumberHelper.getInt(prefs.getStartDayOfWeek())));
            List<CurrencyType> currencyList = apibo.getCurrency();
            for (CurrencyType currency : currencyList) {
                if (!currency.getObjectId().equals(prefs.getBaseCurrencyObjectId())) continue;
                properties.setCurrencySymbol(currency.getSymbol());
                break;
            }
        }
    }

    private void processActivityCodes(APIBusinessObjects apibo, ProjectType project) {
        ActivityCodeContainer container = this.m_projectFile.getActivityCodes();
        HashMap<Integer, ActivityCode> map = new HashMap<Integer, ActivityCode>();
        ArrayList<ActivityCodeTypeType> types = new ArrayList<ActivityCodeTypeType>();
        types.addAll(apibo.getActivityCodeType());
        types.addAll(project.getActivityCodeType());
        for (ActivityCodeTypeType type : types) {
            ActivityCode code = new ActivityCode(type.getObjectId(), type.getName());
            container.add(code);
            map.put(code.getUniqueID(), code);
        }
        ArrayList<ActivityCodeType> typeValues = new ArrayList<ActivityCodeType>();
        typeValues.addAll(apibo.getActivityCode());
        typeValues.addAll(project.getActivityCode());
        for (ActivityCodeType typeValue : typeValues) {
            ActivityCode code = (ActivityCode)map.get(typeValue.getCodeTypeObjectId());
            if (code == null) continue;
            ActivityCodeValue value = code.addValue(typeValue.getObjectId(), typeValue.getCodeValue(), typeValue.getDescription());
            this.m_activityCodeMap.put(value.getUniqueID(), value);
        }
        for (ActivityCodeType typeValue : typeValues) {
            ActivityCodeValue child = this.m_activityCodeMap.get(typeValue.getObjectId());
            ActivityCodeValue parent = this.m_activityCodeMap.get(typeValue.getParentObjectId());
            if (parent == null || child == null) continue;
            child.setParent(parent);
        }
    }

    private void processCalendars(APIBusinessObjects apibo) {
        HashMap<ProjectCalendar, Integer> baseCalendarMap = new HashMap<ProjectCalendar, Integer>();
        for (CalendarType calendarType : apibo.getCalendar()) {
            ProjectCalendar calendar = this.processCalendar(calendarType);
            Integer baseCalendarID = calendarType.getBaseCalendarObjectId();
            if (baseCalendarID == null) continue;
            baseCalendarMap.put(calendar, baseCalendarID);
        }
        for (Map.Entry entry : baseCalendarMap.entrySet()) {
            ProjectCalendar baseCalendar = this.m_projectFile.getCalendarByUniqueID((Integer)entry.getValue());
            if (baseCalendar == null) continue;
            ((ProjectCalendar)entry.getKey()).setParent(baseCalendar);
        }
    }

    private ProjectCalendar processCalendar(CalendarType row) {
        CalendarType.HolidayOrExceptions hoe;
        ProjectCalendar calendar = this.m_projectFile.addCalendar();
        Integer id2 = row.getObjectId();
        calendar.setName(row.getName());
        calendar.setUniqueID(id2);
        CalendarType.StandardWorkWeek stdWorkWeek = row.getStandardWorkWeek();
        if (stdWorkWeek != null) {
            for (CalendarType.StandardWorkWeek.StandardWorkHours hours : stdWorkWeek.getStandardWorkHours()) {
                Day day = DAY_MAP.get(hours.getDayOfWeek());
                List<WorkTimeType> workTime = hours.getWorkTime();
                if (workTime.isEmpty() || workTime.get(0) == null) {
                    calendar.setWorkingDay(day, false);
                    continue;
                }
                calendar.setWorkingDay(day, true);
                ProjectCalendarHours calendarHours = calendar.addCalendarHours(day);
                for (WorkTimeType work : workTime) {
                    if (work == null) continue;
                    calendarHours.addRange(new DateRange(work.getStart(), this.getEndTime(work.getFinish())));
                }
            }
        }
        if ((hoe = row.getHolidayOrExceptions()) != null) {
            for (CalendarType.HolidayOrExceptions.HolidayOrException ex : hoe.getHolidayOrException()) {
                Date startDate = DateHelper.getDayStartDate(ex.getDate());
                Date endDate = DateHelper.getDayEndDate(ex.getDate());
                ProjectCalendarException pce = calendar.addCalendarException(startDate, endDate);
                List<WorkTimeType> workTime = ex.getWorkTime();
                for (WorkTimeType work : workTime) {
                    if (work == null) continue;
                    pce.addRange(new DateRange(work.getStart(), this.getEndTime(work.getFinish())));
                }
            }
        }
        return calendar;
    }

    private void processResources(APIBusinessObjects apibo) {
        List<net.sf.mpxj.primavera.schema.ResourceType> resources = apibo.getResource();
        for (net.sf.mpxj.primavera.schema.ResourceType xml : resources) {
            ProjectCalendar calendar;
            Resource resource = this.m_projectFile.addResource();
            resource.setUniqueID(xml.getObjectId());
            resource.setName(xml.getName());
            resource.setCode(xml.getEmployeeId());
            resource.setEmailAddress(xml.getEmailAddress());
            resource.setGUID(DatatypeConverter.parseUUID(xml.getGUID()));
            resource.setNotes(xml.getResourceNotes());
            resource.setCreationDate(xml.getCreateDate());
            resource.setType(RESOURCE_TYPE_MAP.get(xml.getResourceType()));
            resource.setMaxUnits(this.reversePercentage(xml.getMaxUnitsPerTime()));
            resource.setParentID(xml.getParentObjectId());
            Integer calendarID = xml.getCalendarObjectId();
            if (calendarID != null && (calendar = this.m_projectFile.getCalendarByUniqueID(calendarID)) != null) {
                if (calendar.isDerived()) {
                    if (calendar.getResource() == null) {
                        resource.setResourceCalendar(calendar);
                    } else {
                        ProjectCalendar copy = this.m_projectFile.addCalendar();
                        copy.copy(calendar);
                        resource.setResourceCalendar(copy);
                    }
                } else {
                    ProjectCalendar resourceCalendar = this.m_projectFile.addCalendar();
                    resourceCalendar.setParent(calendar);
                    resourceCalendar.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
                    resourceCalendar.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
                    resource.setResourceCalendar(resourceCalendar);
                }
            }
            this.readUDFTypes(resource, xml.getUDF());
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void processTasks(ProjectType project) {
        Integer uniqueID;
        Task task;
        List<WBSType> wbs = project.getWBS();
        List<ActivityType> tasks = project.getActivity();
        HashSet<Integer> uniqueIDs = new HashSet<Integer>();
        HashSet<Task> wbsTasks = new HashSet<Task>();
        Collections.sort(wbs, WBS_ROW_COMPARATOR);
        for (WBSType row : wbs) {
            task = this.m_projectFile.addTask();
            uniqueID = row.getObjectId();
            uniqueIDs.add(uniqueID);
            wbsTasks.add(task);
            task.setUniqueID(uniqueID);
            task.setGUID(DatatypeConverter.parseUUID(row.getGUID()));
            task.setName(row.getName());
            task.setBaselineCost(row.getSummaryBaselineTotalCost());
            task.setRemainingCost(row.getSummaryRemainingTotalCost());
            task.setRemainingDuration(this.getDuration(row.getSummaryRemainingDuration()));
            task.setSummary(true);
            task.setStart(row.getAnticipatedStartDate());
            task.setFinish(row.getAnticipatedFinishDate());
            task.setWBS(row.getCode());
        }
        this.m_projectFile.getChildTasks().clear();
        for (WBSType row : wbs) {
            task = this.m_projectFile.getTaskByUniqueID(row.getObjectId());
            Task parentTask = this.m_projectFile.getTaskByUniqueID(row.getParentObjectId());
            if (parentTask == null) {
                this.m_projectFile.getChildTasks().add(task);
                continue;
            }
            this.m_projectFile.getChildTasks().remove(task);
            parentTask.getChildTasks().add(task);
            if (this.m_wbsIsFullPath) {
                task.setWBS(parentTask.getWBS() + "." + task.getWBS());
            }
            task.setText(1, task.getWBS());
        }
        int nextID = 1;
        this.m_clashMap.clear();
        for (ActivityType row : tasks) {
            uniqueID = row.getObjectId();
            if (uniqueIDs.contains(uniqueID)) {
                while (uniqueIDs.contains(nextID)) {
                    ++nextID;
                }
                Integer newUniqueID = nextID;
                this.m_clashMap.put(uniqueID, newUniqueID);
                uniqueID = newUniqueID;
            }
            uniqueIDs.add(uniqueID);
            Integer parentTaskID = row.getWBSObjectId();
            Task parentTask = this.m_projectFile.getTaskByUniqueID(parentTaskID);
            Task task2 = parentTask == null ? this.m_projectFile.addTask() : parentTask.addTask();
            task2.setUniqueID(uniqueID);
            task2.setGUID(DatatypeConverter.parseUUID(row.getGUID()));
            task2.setName(row.getName());
            task2.setPercentageComplete(this.reversePercentage(row.getPercentComplete()));
            task2.setRemainingDuration(this.getDuration(row.getRemainingDuration()));
            task2.setActualWork(this.getDuration(this.zeroIsNull(row.getActualDuration())));
            task2.setRemainingWork(this.getDuration(row.getRemainingTotalUnits()));
            task2.setBaselineDuration(this.getDuration(row.getPlannedDuration()));
            task2.setActualDuration(this.getDuration(row.getActualDuration()));
            task2.setDuration(this.getDuration(row.getAtCompletionDuration()));
            task2.setActualCost(NumberHelper.DOUBLE_ZERO);
            task2.setRemainingCost(NumberHelper.DOUBLE_ZERO);
            task2.setBaselineCost(NumberHelper.DOUBLE_ZERO);
            task2.setConstraintDate(row.getPrimaryConstraintDate());
            task2.setConstraintType(CONSTRAINT_TYPE_MAP.get(row.getPrimaryConstraintType()));
            task2.setSecondaryConstraintDate(row.getSecondaryConstraintDate());
            task2.setSecondaryConstraintType(CONSTRAINT_TYPE_MAP.get(row.getSecondaryConstraintType()));
            task2.setActualStart(row.getActualStartDate());
            task2.setActualFinish(row.getActualFinishDate());
            task2.setLateStart(row.getRemainingLateStartDate());
            task2.setLateFinish(row.getRemainingLateFinishDate());
            task2.setEarlyStart(row.getRemainingEarlyStartDate());
            task2.setEarlyFinish(row.getRemainingEarlyFinishDate());
            task2.setBaselineStart(row.getPlannedStartDate());
            task2.setBaselineFinish(row.getPlannedFinishDate());
            task2.setPriority(PRIORITY_MAP.get(row.getLevelingPriority()));
            task2.setCreateDate(row.getCreateDate());
            task2.setText(1, row.getId());
            task2.setText(2, row.getType());
            task2.setText(3, row.getStatus());
            task2.setNumber(1, row.getPrimaryResourceObjectId());
            task2.setMilestone(BooleanHelper.getBoolean(MILESTONE_MAP.get(row.getType())));
            task2.setCritical(task2.getEarlyStart() != null && task2.getLateStart() != null && task2.getLateStart().compareTo(task2.getEarlyStart()) <= 0);
            if (parentTask != null) {
                task2.setWBS(parentTask.getWBS());
            }
            Integer calId = row.getCalendarObjectId();
            ProjectCalendar cal = this.m_projectFile.getCalendarByUniqueID(calId);
            task2.setCalendar(cal);
            task2.setStart(row.getStartDate());
            task2.setFinish(row.getFinishDate());
            this.populateField(task2, TaskField.START, TaskField.START, TaskField.ACTUAL_START, TaskField.BASELINE_START);
            this.populateField(task2, TaskField.FINISH, TaskField.FINISH, TaskField.ACTUAL_FINISH);
            this.populateField(task2, TaskField.WORK, TaskField.ACTUAL_WORK, TaskField.BASELINE_WORK);
            if (task2.getFinish() == null) {
                Duration duration = task2.getRemainingDuration();
                if (duration != null && duration.getDuration() == 0.0) {
                    duration = null;
                }
                if (task2.getActualStart() == null || duration == null) {
                    task2.setFinish(task2.getBaselineFinish());
                } else {
                    Date nextWorkStart;
                    ProjectCalendar calendar = task2.getEffectiveCalendar();
                    Date finish = calendar.getDate(task2.getBaselineStart(), duration, false);
                    if (DateHelper.compare(finish, nextWorkStart = calendar.getNextWorkStart(finish)) == 0) {
                        finish = calendar.getPreviousWorkFinish(finish);
                    }
                    task2.setFinish(finish);
                }
            }
            this.readUDFTypes(task2, row.getUDF());
            this.readActivityCodes(task2, row.getCode());
            this.m_eventManager.fireTaskReadEvent(task2);
        }
        new ActivitySorter(TaskField.TEXT1, wbsTasks).sort(this.m_projectFile);
        this.updateStructure();
        this.updateDates();
    }

    private void updateDates() {
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.updateDates(task);
        }
    }

    private void updateDates(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            int finished = 0;
            Date plannedStartDate = parentTask.getStart();
            Date plannedFinishDate = parentTask.getFinish();
            Date actualStartDate = parentTask.getActualStart();
            Date actualFinishDate = parentTask.getActualFinish();
            Date earlyStartDate = parentTask.getEarlyStart();
            Date earlyFinishDate = parentTask.getEarlyFinish();
            Date lateStartDate = parentTask.getLateStart();
            Date lateFinishDate = parentTask.getLateFinish();
            Date baselineStartDate = parentTask.getBaselineStart();
            Date baselineFinishDate = parentTask.getBaselineFinish();
            Date remainingEarlyStartDate = parentTask.getRemainingEarlyStart();
            Date remainingEarlyFinishDate = parentTask.getRemainingEarlyFinish();
            for (Task task : parentTask.getChildTasks()) {
                this.updateDates(task);
                plannedStartDate = DateHelper.min(plannedStartDate, task.getStart());
                plannedFinishDate = DateHelper.max(plannedFinishDate, task.getFinish());
                actualStartDate = DateHelper.min(actualStartDate, task.getActualStart());
                actualFinishDate = DateHelper.max(actualFinishDate, task.getActualFinish());
                earlyStartDate = DateHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = DateHelper.max(earlyFinishDate, task.getEarlyFinish());
                remainingEarlyStartDate = DateHelper.min(remainingEarlyStartDate, task.getRemainingEarlyStart());
                remainingEarlyFinishDate = DateHelper.max(remainingEarlyFinishDate, task.getRemainingEarlyFinish());
                lateStartDate = DateHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = DateHelper.max(lateFinishDate, task.getLateFinish());
                baselineStartDate = DateHelper.min(baselineStartDate, task.getBaselineStart());
                baselineFinishDate = DateHelper.max(baselineFinishDate, task.getBaselineFinish());
                if (task.getActualFinish() == null) continue;
                ++finished;
            }
            parentTask.setStart(plannedStartDate);
            parentTask.setFinish(plannedFinishDate);
            parentTask.setActualStart(actualStartDate);
            parentTask.setEarlyStart(earlyStartDate);
            parentTask.setEarlyFinish(earlyFinishDate);
            parentTask.setRemainingEarlyStart(remainingEarlyStartDate);
            parentTask.setRemainingEarlyFinish(remainingEarlyFinishDate);
            parentTask.setLateStart(lateStartDate);
            parentTask.setLateFinish(lateFinishDate);
            parentTask.setBaselineStart(baselineStartDate);
            parentTask.setBaselineFinish(baselineFinishDate);
            if (finished == parentTask.getChildTasks().size()) {
                parentTask.setActualFinish(actualFinishDate);
            }
            Duration baselineDuration = null;
            if (baselineStartDate != null && baselineFinishDate != null) {
                baselineDuration = this.m_projectFile.getDefaultCalendar().getWork(baselineStartDate, baselineFinishDate, TimeUnit.HOURS);
                parentTask.setBaselineDuration(baselineDuration);
            }
            Duration remainingDuration = null;
            if (parentTask.getActualFinish() == null) {
                Date finishDate;
                Date startDate = parentTask.getEarlyStart();
                if (startDate == null) {
                    startDate = baselineStartDate;
                }
                if ((finishDate = parentTask.getEarlyFinish()) == null) {
                    finishDate = baselineFinishDate;
                }
                if (startDate != null && finishDate != null) {
                    remainingDuration = this.m_projectFile.getDefaultCalendar().getWork(startDate, finishDate, TimeUnit.HOURS);
                }
            } else {
                remainingDuration = Duration.getInstance(0, TimeUnit.HOURS);
            }
            parentTask.setRemainingDuration(remainingDuration);
            if (baselineDuration != null && remainingDuration != null && baselineDuration.getDuration() != 0.0) {
                double durationPercentComplete = (baselineDuration.getDuration() - remainingDuration.getDuration()) / baselineDuration.getDuration() * 100.0;
                if (durationPercentComplete < 0.0) {
                    durationPercentComplete = 0.0;
                } else if (durationPercentComplete > 100.0) {
                    durationPercentComplete = 100.0;
                }
                parentTask.setPercentageComplete(durationPercentComplete);
            }
        }
    }

    private void populateField(FieldContainer container, FieldType target, FieldType ... types) {
        for (FieldType type : types) {
            Object value = container.getCachedValue(type);
            if (value == null) continue;
            container.set(target, value);
            break;
        }
    }

    private void updateStructure() {
        int id2 = 1;
        Integer outlineLevel = 1;
        for (Task task : this.m_projectFile.getChildTasks()) {
            id2 = this.updateStructure(id2, task, outlineLevel);
        }
    }

    private int updateStructure(int id2, Task task, Integer outlineLevel) {
        task.setID(id2++);
        task.setOutlineLevel(outlineLevel);
        outlineLevel = outlineLevel + 1;
        for (Task childTask : task.getChildTasks()) {
            id2 = this.updateStructure(id2, childTask, outlineLevel);
        }
        return id2;
    }

    private void processPredecessors(ProjectType project) {
        for (RelationshipType row : project.getRelationship()) {
            Task currentTask = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(row.getSuccessorActivityObjectId()));
            Task predecessorTask = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(row.getPredecessorActivityObjectId()));
            if (currentTask == null || predecessorTask == null) continue;
            RelationType type = RELATION_TYPE_MAP.get(row.getType());
            Duration lag = this.getDuration(row.getLag());
            Relation relation = currentTask.addPredecessor(predecessorTask, type, lag);
            relation.setUniqueID(row.getObjectId());
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private void processAssignments(ProjectType project) {
        List<ResourceAssignmentType> assignments = project.getResourceAssignment();
        for (ResourceAssignmentType row : assignments) {
            Task task = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(row.getActivityObjectId()));
            Resource resource = this.m_projectFile.getResourceByUniqueID(row.getResourceObjectId());
            if (task == null || resource == null) continue;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            assignment.setUniqueID(row.getObjectId());
            assignment.setRemainingWork(this.getDuration(row.getRemainingUnits()));
            assignment.setBaselineWork(this.getDuration(row.getPlannedUnits()));
            assignment.setActualWork(this.getDuration(row.getActualUnits()));
            assignment.setRemainingCost(row.getRemainingCost());
            assignment.setBaselineCost(row.getPlannedCost());
            assignment.setActualCost(row.getActualCost());
            assignment.setActualStart(row.getActualStartDate());
            assignment.setActualFinish(row.getActualFinishDate());
            assignment.setBaselineStart(row.getPlannedStartDate());
            assignment.setBaselineFinish(row.getPlannedFinishDate());
            assignment.setGUID(DatatypeConverter.parseUUID(row.getGUID()));
            task.setActualCost(NumberHelper.getDouble(task.getActualCost()) + NumberHelper.getDouble(assignment.getActualCost()));
            task.setRemainingCost(NumberHelper.getDouble(task.getRemainingCost()) + NumberHelper.getDouble(assignment.getRemainingCost()));
            task.setBaselineCost(NumberHelper.getDouble(task.getBaselineCost()) + NumberHelper.getDouble(assignment.getBaselineCost()));
            this.populateField(assignment, AssignmentField.WORK, AssignmentField.ACTUAL_WORK, AssignmentField.BASELINE_WORK);
            this.populateField(assignment, AssignmentField.COST, AssignmentField.ACTUAL_COST, AssignmentField.BASELINE_COST);
            this.populateField(assignment, AssignmentField.START, AssignmentField.ACTUAL_START, AssignmentField.BASELINE_START);
            this.populateField(assignment, AssignmentField.FINISH, AssignmentField.ACTUAL_FINISH, AssignmentField.BASELINE_FINISH);
            this.readUDFTypes(assignment, row.getUDF());
            this.m_eventManager.fireAssignmentReadEvent(assignment);
        }
    }

    private Double zeroIsNull(Double value) {
        if (value != null && value == 0.0) {
            value = null;
        }
        return value;
    }

    private Duration getDuration(Double duration) {
        Duration result = null;
        if (duration != null) {
            result = Duration.getInstance(NumberHelper.getDouble(duration), TimeUnit.HOURS);
        }
        return result;
    }

    private Date getEndTime(Date date) {
        return new Date(date.getTime() + 60000L);
    }

    private Number reversePercentage(Double n2) {
        return n2 == null ? null : NumberHelper.getDouble(n2 * 100.0);
    }

    private void readUDFTypes(FieldContainer mpxj, List<UDFAssignmentType> udfs) {
        for (UDFAssignmentType udf : udfs) {
            FieldType fieldType = this.m_fieldTypeMap.get(udf.getTypeObjectId());
            if (fieldType == null) continue;
            mpxj.set(fieldType, this.getUdfValue(udf));
        }
    }

    private Object getUdfValue(UDFAssignmentType udf) {
        if (udf.getCostValue() != null) {
            return udf.getCostValue();
        }
        if (udf.getDoubleValue() != null) {
            return udf.getDoubleValue();
        }
        if (udf.getFinishDateValue() != null) {
            return udf.getFinishDateValue();
        }
        if (udf.getIndicatorValue() != null) {
            return udf.getIndicatorValue();
        }
        if (udf.getIntegerValue() != null) {
            return udf.getIntegerValue();
        }
        if (udf.getStartDateValue() != null) {
            return udf.getStartDateValue();
        }
        if (udf.getTextValue() != null) {
            return udf.getTextValue();
        }
        return null;
    }

    private void readActivityCodes(Task task, List<CodeAssignmentType> codes) {
        for (CodeAssignmentType assignment : codes) {
            ActivityCodeValue code = this.m_activityCodeMap.get(assignment.getValueObjectId());
            if (code == null) continue;
            task.addActivityCode(code);
        }
    }

    private Integer mapTaskID(Integer id2) {
        Integer mappedID = this.m_clashMap.get(id2);
        if (mappedID == null) {
            mappedID = id2;
        }
        return mappedID;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance("net.sf.mpxj.primavera.schema", PrimaveraPMFileReader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
        RESOURCE_TYPE_MAP = new HashMap<String, ResourceType>();
        RESOURCE_TYPE_MAP.put(null, ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("Labor", ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("Material", ResourceType.MATERIAL);
        RESOURCE_TYPE_MAP.put("Nonlabor", ResourceType.COST);
        CONSTRAINT_TYPE_MAP = new HashMap<String, ConstraintType>();
        CONSTRAINT_TYPE_MAP.put("Start On", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("Start On or Before", ConstraintType.START_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("Start On or After", ConstraintType.START_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("Finish On", ConstraintType.MUST_FINISH_ON);
        CONSTRAINT_TYPE_MAP.put("Finish On or Before", ConstraintType.FINISH_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("Finish On or After", ConstraintType.FINISH_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("As Late As Possible", ConstraintType.AS_LATE_AS_POSSIBLE);
        CONSTRAINT_TYPE_MAP.put("Mandatory Start", ConstraintType.MANDATORY_START);
        CONSTRAINT_TYPE_MAP.put("Mandatory Finish", ConstraintType.MANDATORY_FINISH);
        PRIORITY_MAP = new HashMap<String, Priority>();
        PRIORITY_MAP.put("Top", Priority.getInstance(900));
        PRIORITY_MAP.put("High", Priority.getInstance(600));
        PRIORITY_MAP.put("Normal", Priority.getInstance(500));
        PRIORITY_MAP.put("Low", Priority.getInstance(400));
        PRIORITY_MAP.put("Lowest", Priority.getInstance(100));
        RELATION_TYPE_MAP = new HashMap<String, RelationType>();
        RELATION_TYPE_MAP.put("Finish to Start", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("Finish to Finish", RelationType.FINISH_FINISH);
        RELATION_TYPE_MAP.put("Start to Start", RelationType.START_START);
        RELATION_TYPE_MAP.put("Start to Finish", RelationType.START_FINISH);
        DAY_MAP = new HashMap<String, Day>();
        DAY_MAP.put("Monday", Day.MONDAY);
        DAY_MAP.put("Tuesday", Day.TUESDAY);
        DAY_MAP.put("Wednesday", Day.WEDNESDAY);
        DAY_MAP.put("Thursday", Day.THURSDAY);
        DAY_MAP.put("Friday", Day.FRIDAY);
        DAY_MAP.put("Saturday", Day.SATURDAY);
        DAY_MAP.put("Sunday", Day.SUNDAY);
        DAY_MAP.put("1", Day.SUNDAY);
        DAY_MAP.put("2", Day.MONDAY);
        DAY_MAP.put("3", Day.TUESDAY);
        DAY_MAP.put("4", Day.WEDNESDAY);
        DAY_MAP.put("5", Day.THURSDAY);
        DAY_MAP.put("6", Day.FRIDAY);
        DAY_MAP.put("7", Day.SATURDAY);
        MILESTONE_MAP = new HashMap<String, Boolean>();
        MILESTONE_MAP.put("Task Dependent", Boolean.FALSE);
        MILESTONE_MAP.put("Resource Dependent", Boolean.FALSE);
        MILESTONE_MAP.put("Level of Effort", Boolean.FALSE);
        MILESTONE_MAP.put("Start Milestone", Boolean.TRUE);
        MILESTONE_MAP.put("Finish Milestone", Boolean.TRUE);
        MILESTONE_MAP.put("WBS Summary", Boolean.FALSE);
        FIELD_TYPE_MAP = new HashMap<String, FieldTypeClass>();
        FIELD_TYPE_MAP.put("Activity", FieldTypeClass.TASK);
        FIELD_TYPE_MAP.put("WBS", FieldTypeClass.TASK);
        FIELD_TYPE_MAP.put("Resource", FieldTypeClass.RESOURCE);
        FIELD_TYPE_MAP.put("Resource Assignment", FieldTypeClass.ASSIGNMENT);
        RESERVED_TASK_FIELDS = new HashSet<TaskField>();
        RESERVED_TASK_FIELDS.add(TaskField.TEXT1);
        RESERVED_TASK_FIELDS.add(TaskField.TEXT2);
        WBS_ROW_COMPARATOR = new WbsRowComparatorPMXML();
        ENCODING_PATTERN = Pattern.compile(".*<\\?xml.*encoding=\"([^\"]+)\".*\\?>.*", 32);
    }
}

