/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi;

import java.util.Date;
import java.util.LinkedList;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedItem;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.common.AbstractTimephasedWorkNormaliser;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;

public class MSPDITimephasedWorkNormaliser
extends AbstractTimephasedWorkNormaliser {
    @Override
    public void normalise(ProjectCalendar calendar, LinkedList<TimephasedWork> list) {
        this.splitDays(calendar, list);
        this.mergeSameDay(calendar, list);
        this.mergeSameWork(list);
        this.validateSameDay(calendar, list);
        this.convertToHours(list);
    }

    private void splitDays(ProjectCalendar calendar, LinkedList<TimephasedWork> list) {
        LinkedList<TimephasedWork> result = new LinkedList<TimephasedWork>();
        block0: for (TimephasedWork assignment : list) {
            while (assignment != null) {
                Date startDay = DateHelper.getDayStartDate(assignment.getStart());
                Date finishDay = DateHelper.getDayStartDate(assignment.getFinish());
                if (assignment.getFinish().getTime() == finishDay.getTime()) {
                    finishDay = DateHelper.addDays(finishDay, -1);
                }
                if (startDay.getTime() == finishDay.getTime()) {
                    result.add(assignment);
                    continue block0;
                }
                TimephasedWork[] split = this.splitFirstDay(calendar, assignment);
                if (split[0] != null) {
                    result.add(split[0]);
                }
                assignment = split[1];
            }
        }
        list.clear();
        list.addAll(result);
    }

    private TimephasedWork[] splitFirstDay(ProjectCalendar calendar, TimephasedWork assignment) {
        TimephasedWork[] result = new TimephasedWork[2];
        Date assignmentStart = assignment.getStart();
        Date assignmentFinish = assignment.getFinish();
        Duration calendarWork = calendar.getWork(assignmentStart, assignmentFinish, TimeUnit.MINUTES);
        Duration assignmentWork = (Duration)assignment.getTotalAmount();
        if (calendarWork.getDuration() != 0.0) {
            TimephasedWork split;
            Duration splitWork;
            double splitMinutes;
            Date splitFinish;
            Date splitStart;
            if (calendar.isWorkingDate(assignmentStart)) {
                splitStart = assignmentStart;
                Date splitFinishTime = calendar.getFinishTime(splitStart);
                splitFinish = DateHelper.setTime(splitStart, splitFinishTime);
                splitMinutes = calendar.getWork(splitStart, splitFinish, TimeUnit.MINUTES).getDuration();
                splitMinutes *= assignmentWork.getDuration();
                splitMinutes /= calendarWork.getDuration();
                splitMinutes = NumberHelper.round(splitMinutes, 2.0);
                splitWork = Duration.getInstance(splitMinutes, TimeUnit.MINUTES);
                TimephasedWork split2 = new TimephasedWork();
                split2.setStart(splitStart);
                split2.setFinish(splitFinish);
                split2.setTotalAmount(splitWork);
                result[0] = split2;
            } else {
                splitFinish = assignmentStart;
                splitMinutes = 0.0;
            }
            splitStart = calendar.getNextWorkStart(splitFinish);
            splitFinish = assignmentFinish;
            if (splitStart.getTime() > splitFinish.getTime()) {
                split = null;
            } else {
                splitMinutes = assignmentWork.getDuration() - splitMinutes;
                splitWork = Duration.getInstance(splitMinutes, TimeUnit.MINUTES);
                split = new TimephasedWork();
                split.setStart(splitStart);
                split.setFinish(splitFinish);
                split.setTotalAmount(splitWork);
            }
            result[1] = split;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void mergeSameDay(ProjectCalendar calendar, LinkedList<TimephasedWork> list) {
        LinkedList<Object> result = new LinkedList<Object>();
        TimephasedItem previousAssignment = null;
        for (TimephasedWork timephasedWork : list) {
            void var6_6;
            if (previousAssignment == null) {
                timephasedWork.setAmountPerDay(timephasedWork.getTotalAmount());
                result.add(timephasedWork);
            } else {
                Date previousAssignmentStart = previousAssignment.getStart();
                Date previousAssignmentStartDay = DateHelper.getDayStartDate(previousAssignmentStart);
                Date assignmentStart = timephasedWork.getStart();
                Date assignmentStartDay = DateHelper.getDayStartDate(assignmentStart);
                if (previousAssignmentStartDay.getTime() == assignmentStartDay.getTime()) {
                    Duration previousAssignmentWork = (Duration)previousAssignment.getTotalAmount();
                    Duration assignmentWork = (Duration)timephasedWork.getTotalAmount();
                    if (previousAssignmentWork.getDuration() != 0.0 && assignmentWork.getDuration() == 0.0) continue;
                    result.removeLast();
                    if (previousAssignmentWork.getDuration() != 0.0 && assignmentWork.getDuration() != 0.0) {
                        double work = ((Duration)previousAssignment.getTotalAmount()).getDuration();
                        Duration totalWork = Duration.getInstance(work += ((Duration)timephasedWork.getTotalAmount()).getDuration(), TimeUnit.MINUTES);
                        TimephasedWork merged = new TimephasedWork();
                        merged.setStart(previousAssignment.getStart());
                        merged.setFinish(timephasedWork.getFinish());
                        merged.setTotalAmount(totalWork);
                        TimephasedWork timephasedWork2 = merged;
                    } else if (assignmentWork.getDuration() == 0.0) {
                        TimephasedItem timephasedItem = previousAssignment;
                    }
                }
                var6_6.setAmountPerDay(var6_6.getTotalAmount());
                result.add(var6_6);
            }
            Duration calendarWork = calendar.getWork(var6_6.getStart(), var6_6.getFinish(), TimeUnit.MINUTES);
            Duration assignmentWork = (Duration)var6_6.getTotalAmount();
            if (calendarWork.getDuration() == 0.0 && assignmentWork.getDuration() == 0.0) {
                result.removeLast();
                continue;
            }
            previousAssignment = var6_6;
        }
        list.clear();
        list.addAll(result);
    }

    private void validateSameDay(ProjectCalendar calendar, LinkedList<TimephasedWork> list) {
        for (TimephasedWork assignment : list) {
            Date assignmentStart = assignment.getStart();
            Date calendarStartTime = calendar.getStartTime(assignmentStart);
            Date assignmentStartTime = DateHelper.getCanonicalTime(assignmentStart);
            Date assignmentFinish = assignment.getFinish();
            Date calendarFinishTime = calendar.getFinishTime(assignmentFinish);
            Date assignmentFinishTime = DateHelper.getCanonicalTime(assignmentFinish);
            double totalWork = ((Duration)assignment.getTotalAmount()).getDuration();
            if (assignmentStartTime != null && calendarStartTime != null && (totalWork == 0.0 && assignmentStartTime.getTime() != calendarStartTime.getTime() || assignmentStartTime.getTime() < calendarStartTime.getTime())) {
                assignmentStart = DateHelper.setTime(assignmentStart, calendarStartTime);
                assignment.setStart(assignmentStart);
            }
            if (assignmentFinishTime == null || calendarFinishTime == null || (totalWork != 0.0 || assignmentFinishTime.getTime() == calendarFinishTime.getTime()) && assignmentFinishTime.getTime() <= calendarFinishTime.getTime()) continue;
            assignmentFinish = DateHelper.setTime(assignmentFinish, calendarFinishTime);
            assignment.setFinish(assignmentFinish);
        }
    }
}

