/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.UUID;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Var2Data;

abstract class VarDataFieldReader {
    private final CustomFieldContainer m_customFields;
    private static final int VALUE_LIST_WITH_ID_MASK = 1792;
    private static final int VALUE_LIST_WITHOUT_ID_MASK = 1024;

    public VarDataFieldReader(CustomFieldContainer customFields) {
        this.m_customFields = customFields;
    }

    public Object getValue(Var2Data varData, Integer id2, Integer type) {
        Object result = null;
        int flag = varData.getShort(id2, type) & 0xFF00;
        if (flag == 1792 || flag == 1024) {
            byte[] data = varData.getByteArray(id2, type);
            if (data.length == 26) {
                int uniqueId = MPPUtility.getInt(data, 2);
                CustomFieldValueItem item = this.m_customFields.getCustomFieldValueItemByUniqueID(uniqueId);
                if (item == null) {
                    UUID guid = MPPUtility.getGUID(data, 6);
                    item = this.m_customFields.getCustomFieldValueItemByGuid(guid);
                }
                result = item == null ? this.readValue(varData, id2, type) : this.coerceValue(item.getValue());
            } else if (data.length >= 6) {
                int uniqueId = MPPUtility.getInt(data, 2);
                CustomFieldValueItem item = this.m_customFields.getCustomFieldValueItemByUniqueID(uniqueId);
                result = item == null ? this.readValue(varData, id2, type) : this.coerceValue(item.getValue());
            } else if (data.length > 2) {
                result = this.readValue(varData, id2, type);
            }
        } else {
            result = this.readValue(varData, id2, type);
        }
        return result;
    }

    protected abstract Object readValue(Var2Data var1, Integer var2, Integer var3);

    protected abstract Object coerceValue(Object var1);
}

