/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Date;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarDataFieldReader;

class TimestampVarDataFieldReader
extends VarDataFieldReader {
    public TimestampVarDataFieldReader(CustomFieldContainer customFields) {
        super(customFields);
    }

    @Override
    protected Object readValue(Var2Data varData, Integer id2, Integer type) {
        return this.getRawTimestampValue(varData, id2, type);
    }

    @Override
    protected Object coerceValue(Object value) {
        if (value instanceof Date) {
            return value;
        }
        return null;
    }

    private Object getRawTimestampValue(Var2Data varData, Integer id2, Integer type) {
        Object result = null;
        byte[] data = varData.getByteArray(id2, type);
        if (data != null) {
            if (data.length == 512) {
                result = MPPUtility.getUnicodeString(data, 0);
            } else if (data.length >= 4) {
                result = MPPUtility.getTimestamp(data, 0);
            }
        }
        return result;
    }
}

