/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Table;
import net.sf.mpxj.TableContainer;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskContainer;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.View;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.MPPResourceField;
import net.sf.mpxj.common.MPPTaskField;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.RtfHelper;
import net.sf.mpxj.mpp.AvailabilityFactory;
import net.sf.mpxj.mpp.ConstraintFactory;
import net.sf.mpxj.mpp.CostRateTableFactory;
import net.sf.mpxj.mpp.CustomFieldValueReader9;
import net.sf.mpxj.mpp.DataLinkFactory;
import net.sf.mpxj.mpp.DocumentInputStreamFactory;
import net.sf.mpxj.mpp.FieldMap;
import net.sf.mpxj.mpp.FieldMap9;
import net.sf.mpxj.mpp.FilterReader9;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.GraphicalIndicatorReader;
import net.sf.mpxj.mpp.GroupReader9;
import net.sf.mpxj.mpp.MPP9CalendarFactory;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.MPPVariantReader;
import net.sf.mpxj.mpp.ProjectPropertiesReader;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Props9;
import net.sf.mpxj.mpp.PropsBlock;
import net.sf.mpxj.mpp.RecurringTaskReader;
import net.sf.mpxj.mpp.ResourceAssignmentFactory;
import net.sf.mpxj.mpp.TableFactory;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta9;
import net.sf.mpxj.mpp.ViewFactory9;
import net.sf.mpxj.mpp.ViewStateReader9;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

final class MPP9Reader
implements MPPVariantReader {
    private MPPReader m_reader;
    private ProjectFile m_file;
    private EventManager m_eventManager;
    private DirectoryEntry m_root;
    private HashMap<Integer, ProjectCalendar> m_resourceMap;
    private Var2Data m_outlineCodeVarData;
    private Props9 m_projectProps;
    private Map<Integer, FontBase> m_fontBases;
    private Map<Integer, SubProject> m_taskSubProjects;
    private DirectoryEntry m_projectDir;
    private DirectoryEntry m_viewDir;
    private DocumentInputStreamFactory m_inputStreamFactory;
    private static final int SUBPROJECT_LISTEND = 771;
    private static final int SUBPROJECT_TASKUNIQUEID0 = 0;
    private static final int SUBPROJECT_TASKUNIQUEID1 = 187957248;
    private static final int SUBPROJECT_TASKUNIQUEID2 = 0xABB0000;
    private static final int SUBPROJECT_TASKUNIQUEID3 = 94437376;
    private static final int SUBPROJECT_TASKUNIQUEID4 = 49741824;
    private static final int SUBPROJECT_TASKUNIQUEID5 = 0x7010000;
    private static final Integer TABLE_COLUMN_DATA_STANDARD = 1;
    private static final Integer TABLE_COLUMN_DATA_ENTERPRISE = 2;
    private static final Integer TABLE_COLUMN_DATA_BASELINE = null;
    private static final Integer OUTLINECODE_DATA = 1;
    private static final int DURATION_CONFIRMED_MASK = 32;
    private static final int TASK_UNIQUE_ID_FIXED_OFFSET = 0;
    private static final int TASK_ID_FIXED_OFFSET = 4;
    private static final int NULL_TASK_BLOCK_SIZE = 8;
    private static final Map<Integer, FieldType> RESOURCE_FIELD_ALIASES = new HashMap<Integer, FieldType>();
    private static final Map<Integer, FieldType> TASK_FIELD_ALIASES;

    MPP9Reader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(MPPReader reader, ProjectFile file, DirectoryEntry root) throws MPXJException, IOException {
        try {
            this.populateMemberData(reader, file, root);
            this.processProjectProperties();
            if (!reader.getReadPropertiesOnly()) {
                this.processSubProjectData();
                this.processGraphicalIndicators();
                this.processCustomValueLists();
                this.processCalendarData();
                this.processResourceData();
                this.processTaskData();
                this.processConstraintData();
                this.processAssignmentData();
                this.postProcessTasks();
                this.processDataLinks();
                if (reader.getReadPresentationData()) {
                    this.processViewPropertyData();
                    this.processTableData();
                    this.processViewData();
                    this.processFilterData();
                    this.processGroupData();
                    this.processSavedViewState();
                }
            }
        }
        finally {
            this.clearMemberData();
        }
    }

    private void populateMemberData(MPPReader reader, ProjectFile file, DirectoryEntry root) throws MPXJException, IOException {
        String readPassword;
        boolean passwordRequiredToRead;
        this.m_reader = reader;
        this.m_file = file;
        this.m_eventManager = file.getEventManager();
        this.m_root = root;
        Props9 props9 = new Props9(new DocumentInputStream((DocumentEntry)root.getEntry("Props9")));
        file.getProjectProperties().setProjectFilePath(props9.getUnicodeString(Props.PROJECT_FILE_PATH));
        this.m_inputStreamFactory = new DocumentInputStreamFactory(props9);
        byte passwordProtectionFlag = props9.getByte(Props.PASSWORD_FLAG);
        boolean bl = passwordRequiredToRead = (passwordProtectionFlag & 1) != 0;
        if (passwordRequiredToRead && reader.getRespectPasswordProtection() && (readPassword = MPPUtility.decodePassword(props9.getByteArray(Props.PROTECTION_PASSWORD_HASH), this.m_inputStreamFactory.getEncryptionCode())) != null && readPassword.length() > 0 && (reader.getReadPassword() == null || !reader.getReadPassword().matches(readPassword))) {
            throw new MPXJException("File is password protected. Please enter password.");
        }
        this.m_resourceMap = new HashMap();
        this.m_projectDir = (DirectoryEntry)root.getEntry("   19");
        this.m_viewDir = (DirectoryEntry)root.getEntry("   29");
        DirectoryEntry outlineCodeDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndOutlCode");
        VarMeta9 outlineCodeVarMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("VarMeta")));
        this.m_outlineCodeVarData = new Var2Data(outlineCodeVarMeta, new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("Var2Data")));
        this.m_projectProps = new Props9(this.m_inputStreamFactory.getInstance(this.m_projectDir, "Props"));
        this.m_fontBases = new HashMap<Integer, FontBase>();
        this.m_taskSubProjects = new HashMap<Integer, SubProject>();
        this.m_file.getProjectProperties().setMppFileType(9);
        this.m_file.getProjectProperties().setAutoFilter(props9.getBoolean(Props.AUTO_FILTER));
    }

    private void clearMemberData() {
        this.m_reader = null;
        this.m_file = null;
        this.m_eventManager = null;
        this.m_root = null;
        this.m_resourceMap = null;
        this.m_projectDir = null;
        this.m_viewDir = null;
        this.m_outlineCodeVarData = null;
        this.m_fontBases = null;
        this.m_taskSubProjects = null;
    }

    private void processProjectProperties() throws MPXJException {
        ProjectPropertiesReader reader = new ProjectPropertiesReader();
        reader.process(this.m_file, this.m_projectProps, this.m_root);
    }

    private void processGraphicalIndicators() {
        GraphicalIndicatorReader graphicalIndicatorReader = new GraphicalIndicatorReader();
        graphicalIndicatorReader.process(this.m_file.getCustomFields(), this.m_file.getProjectProperties(), this.m_projectProps);
    }

    private void processSubProjectData() {
        byte[] subProjData = this.m_projectProps.getByteArray(Props.SUBPROJECT_DATA);
        if (subProjData != null) {
            int index = 0;
            int offset = 0;
            byte[] itemHeader = new byte[20];
            offset += 4;
            int itemCountOffset = MPPUtility.getInt(subProjData, offset += 4);
            offset += 4;
            block15: while (offset < itemCountOffset) {
                ++index;
                int itemHeaderOffset = MPPUtility.getShort(subProjData, offset);
                offset += 4;
                MPPUtility.getByteArray(subProjData, itemHeaderOffset, itemHeader.length, itemHeader, 0);
                byte subProjectType = itemHeader[16];
                switch (subProjectType) {
                    case 0: {
                        offset += 8;
                        continue block15;
                    }
                    case -103: 
                    case 9: 
                    case 13: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        offset += 4;
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block15;
                    }
                    case -111: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block15;
                    }
                    case 1: 
                    case 3: 
                    case 8: 
                    case 10: 
                    case 17: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block15;
                    }
                    case -127: 
                    case 65: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block15;
                    }
                    case -64: {
                        int uniqueIDOffset = itemHeaderOffset;
                        int filePathOffset = MPPUtility.getShort(subProjData, offset);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block15;
                    }
                    case 5: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        this.m_file.getSubProjects().setResourceSubProject(sp);
                        continue block15;
                    }
                    case 69: {
                        int uniqueIDOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        int filePathOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        this.m_file.getSubProjects().setResourceSubProject(sp);
                        continue block15;
                    }
                    case 2: 
                    case 4: {
                        int filePathOffset = MPPUtility.getShort(subProjData, offset);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, -1, filePathOffset, fileNameOffset, index);
                        if (subProjectType != 4) continue block15;
                        this.m_file.getSubProjects().setResourceSubProject(sp);
                        continue block15;
                    }
                    case -115: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 8);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 8);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block15;
                    }
                    case -128: {
                        offset += 12;
                        continue block15;
                    }
                    case 16: {
                        offset += 8;
                        continue block15;
                    }
                    case 68: {
                        int filePathOffset = MPPUtility.getShort(subProjData, offset);
                        offset += 4;
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, -1, filePathOffset, fileNameOffset, index);
                        this.m_file.getSubProjects().setResourceSubProject(sp);
                        continue block15;
                    }
                }
                offset += 12;
            }
        }
    }

    private SubProject readSubProject(byte[] data, int uniqueIDOffset, int filePathOffset, int fileNameOffset, int subprojectIndex) {
        try {
            SubProject sp = new SubProject();
            if (uniqueIDOffset != -1) {
                int prev = 0;
                int value = MPPUtility.getInt(data, uniqueIDOffset);
                while (value != 771) {
                    switch (value) {
                        case 0: 
                        case 49741824: 
                        case 94437376: 
                        case 0x7010000: 
                        case 0xABB0000: 
                        case 187957248: {
                            sp.setTaskUniqueID(prev);
                            this.m_taskSubProjects.put(sp.getTaskUniqueID(), sp);
                            prev = 0;
                            break;
                        }
                        default: {
                            if (prev != 0) {
                                sp.addExternalTaskUniqueID(prev);
                                this.m_taskSubProjects.put(prev, sp);
                            }
                            prev = value;
                        }
                    }
                    value = MPPUtility.getInt(data, uniqueIDOffset += 4);
                }
                if (prev != 0) {
                    sp.addExternalTaskUniqueID(prev);
                    this.m_taskSubProjects.put(prev, sp);
                }
                value = 0x800000 + (subprojectIndex - 1) * 0x400000;
                sp.setUniqueIDOffset(value);
            }
            filePathOffset += 18;
            sp.setDosFullPath(MPPUtility.getString(data, filePathOffset += 4));
            filePathOffset += sp.getDosFullPath().length() + 1;
            int size = MPPUtility.getInt(data, filePathOffset += 24);
            filePathOffset += 4;
            if (size == 0) {
                sp.setFullPath(sp.getDosFullPath());
            } else {
                size = MPPUtility.getInt(data, filePathOffset);
                filePathOffset += 4;
                sp.setFullPath(MPPUtility.getUnicodeString(data, filePathOffset += 2, size));
            }
            fileNameOffset += 18;
            sp.setDosFileName(MPPUtility.getString(data, fileNameOffset += 4));
            fileNameOffset += sp.getDosFileName().length() + 1;
            size = MPPUtility.getInt(data, fileNameOffset += 24);
            fileNameOffset += 4;
            if (size == 0) {
                sp.setFileName(sp.getDosFileName());
            } else {
                size = MPPUtility.getInt(data, fileNameOffset);
                fileNameOffset += 4;
                sp.setFileName(MPPUtility.getUnicodeString(data, fileNameOffset += 2, size));
            }
            this.m_file.getSubProjects().add(sp);
            return sp;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    private void processViewPropertyData() throws IOException {
        Props9 props = new Props9(this.m_inputStreamFactory.getInstance(this.m_viewDir, "Props"));
        byte[] data = props.getByteArray(Props.FONT_BASES);
        if (data != null) {
            this.processBaseFonts(data);
        }
        ProjectProperties properties = this.m_file.getProjectProperties();
        properties.setShowProjectSummaryTask(props.getBoolean(Props.SHOW_PROJECT_SUMMARY_TASK));
    }

    private void processBaseFonts(byte[] data) {
        int offset = 0;
        int blockCount = MPPUtility.getShort(data, 0);
        offset += 2;
        for (int loop = 0; loop < blockCount; ++loop) {
            int size = MPPUtility.getShort(data, offset += 2);
            String name = MPPUtility.getUnicodeString(data, offset += 2);
            offset += 64;
            if (name.length() == 0) continue;
            FontBase fontBase = new FontBase(loop, name, size);
            this.m_fontBases.put(fontBase.getIndex(), fontBase);
        }
    }

    private void processCustomValueLists() throws IOException {
        CustomFieldValueReader9 reader = new CustomFieldValueReader9(this.m_projectDir, this.m_file.getProjectProperties(), this.m_projectProps, this.m_file.getCustomFields());
        reader.process();
    }

    public List<String> getTaskFieldDescriptions(byte[] data) {
        String description;
        if (data == null || data.length == 0) {
            return null;
        }
        LinkedList<String> descriptions = new LinkedList<String>();
        for (int offset = 0; offset < data.length; offset += description.length() * 2 + 2) {
            description = MPPUtility.getUnicodeString(data, offset);
            descriptions.add(description);
        }
        return descriptions;
    }

    public List<Object> getTaskFieldValues(ProjectProperties properties, FieldType field, byte[] data) {
        if (field == null || data == null || data.length == 0) {
            return null;
        }
        LinkedList<Object> list = new LinkedList<Object>();
        switch (field.getDataType()) {
            case DATE: {
                int offset;
                while (offset + 4 <= data.length) {
                    Date date = MPPUtility.getTimestamp(data, offset);
                    list.add(date);
                    offset += 4;
                }
                break;
            }
            case CURRENCY: {
                int offset;
                while (offset + 8 <= data.length) {
                    Double number = NumberHelper.getDouble(MPPUtility.getDouble(data, offset) / 100.0);
                    list.add(number);
                    offset += 8;
                }
                break;
            }
            case NUMERIC: {
                int offset;
                while (offset + 8 <= data.length) {
                    Double number = NumberHelper.getDouble(MPPUtility.getDouble(data, offset));
                    list.add(number);
                    offset += 8;
                }
                break;
            }
            case DURATION: {
                int offset;
                while (offset + 6 <= data.length) {
                    Duration duration = MPPUtility.getAdjustedDuration(properties, MPPUtility.getInt(data, offset), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, offset + 4)));
                    list.add(duration);
                    offset += 6;
                }
                break;
            }
            case STRING: {
                String s2;
                int offset;
                for (offset = 0; offset < data.length; offset += s2.length() * 2 + 2) {
                    s2 = MPPUtility.getUnicodeString(data, offset);
                    list.add(s2);
                }
                break;
            }
            case BOOLEAN: {
                int offset;
                while (offset + 2 <= data.length) {
                    boolean b2 = MPPUtility.getShort(data, offset) == 1;
                    list.add(b2);
                    offset += 2;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return list;
    }

    private void processFieldNameAliases(Map<Integer, FieldType> map, byte[] data) {
        if (data != null) {
            int offset = 0;
            int index = 0;
            CustomFieldContainer fields = this.m_file.getCustomFields();
            while (offset < data.length) {
                FieldType field;
                String alias = MPPUtility.getUnicodeString(data, offset);
                if (!alias.isEmpty() && (field = map.get(index)) != null) {
                    fields.getCustomField(field).setAlias(alias);
                }
                offset += (alias.length() + 1) * 2;
                ++index;
            }
        }
    }

    private TreeMap<Integer, Integer> createTaskMap(FieldMap fieldMap, FixedMeta taskFixedMeta, FixedData taskFixedData, Var2Data taskVarData) {
        TreeMap<Integer, Integer> taskMap = new TreeMap<Integer, Integer>();
        int uniqueIdOffset = fieldMap.getFixedDataOffset(TaskField.UNIQUE_ID);
        Integer taskNameKey = fieldMap.getVarDataKey(TaskField.NAME);
        int itemCount = taskFixedMeta.getAdjustedItemCount();
        for (int loop = 3; loop < itemCount; ++loop) {
            Integer key;
            int uniqueID;
            byte[] data = taskFixedData.getByteArrayValue(loop);
            if (data == null) continue;
            byte[] metaData = taskFixedMeta.getByteArrayValue(loop);
            int flags = MPPUtility.getInt(metaData, 0);
            if ((flags & 2) != 0) {
                uniqueID = MPPUtility.getShort(data, 0);
                key = uniqueID;
                if (taskMap.containsKey(key)) continue;
                taskMap.put(key, null);
                continue;
            }
            if (data.length == 8) {
                uniqueID = MPPUtility.getInt(data, 0);
                key = uniqueID;
                if (taskMap.containsKey(key)) continue;
                taskMap.put(key, loop);
                continue;
            }
            int maxSize = fieldMap.getMaxFixedDataSize(0);
            if (maxSize != 0 && data.length * 100 / maxSize <= 75 || taskMap.containsKey(key = Integer.valueOf(uniqueID = MPPUtility.getInt(data, uniqueIdOffset))) && taskVarData.getUnicodeString(key, taskNameKey) == null) continue;
            taskMap.put(key, loop);
        }
        return taskMap;
    }

    private TreeMap<Integer, Integer> createResourceMap(FieldMap fieldMap, FixedMeta rscFixedMeta, FixedData rscFixedData) {
        TreeMap<Integer, Integer> resourceMap = new TreeMap<Integer, Integer>();
        int itemCount = rscFixedMeta.getAdjustedItemCount();
        for (int loop = 0; loop < itemCount; ++loop) {
            byte[] data = rscFixedData.getByteArrayValue(loop);
            if (data == null || data.length < fieldMap.getMaxFixedDataSize(0)) continue;
            Integer uniqueID = MPPUtility.getShort(data, 0);
            resourceMap.put(uniqueID, loop);
        }
        return resourceMap;
    }

    private void processCalendarData() throws IOException {
        MPP9CalendarFactory factory = new MPP9CalendarFactory(this.m_file);
        factory.processCalendarData(this.m_projectDir, this.m_projectProps, this.m_inputStreamFactory, this.m_resourceMap);
    }

    private void processTaskData() throws IOException {
        FieldMap9 fieldMap = new FieldMap9(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap.createTaskFieldMap(this.m_projectProps);
        DirectoryEntry taskDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndTask");
        VarMeta9 taskVarMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)taskDir.getEntry("VarMeta")));
        Var2Data taskVarData = new Var2Data(taskVarMeta, new DocumentInputStream((DocumentEntry)taskDir.getEntry("Var2Data")));
        FixedMeta taskFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)taskDir.getEntry("FixedMeta")), 47);
        FixedData taskFixedData = new FixedData(taskFixedMeta, this.m_inputStreamFactory.getInstance(taskDir, "FixedData"), 768, fieldMap.getMaxFixedDataSize(0));
        this.processFieldNameAliases(TASK_FIELD_ALIASES, this.m_projectProps.getByteArray(Props.TASK_FIELD_NAME_ALIASES));
        TreeMap<Integer, Integer> taskMap = this.createTaskMap(fieldMap, taskFixedMeta, taskFixedData, taskVarData);
        Object[] uniqueIdArray = taskMap.keySet().toArray();
        boolean autoWBS = true;
        LinkedList<Task> externalTasks = new LinkedList<Task>();
        RecurringTaskReader recurringTaskReader = null;
        for (int loop = 0; loop < uniqueIdArray.length; ++loop) {
            ProjectCalendar calendar;
            Task task;
            Integer uniqueID = (Integer)uniqueIdArray[loop];
            Integer offset = taskMap.get(uniqueID);
            if (!taskFixedData.isValidOffset(offset)) continue;
            byte[] data = taskFixedData.getByteArrayValue(offset);
            Integer id2 = MPPUtility.getInt(data, fieldMap.getFixedDataOffset(TaskField.ID));
            if (data.length == 8) {
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(MPPUtility.getShort(data, 0));
                task.setID(MPPUtility.getShort(data, 4));
                continue;
            }
            if (data.length < fieldMap.getMaxFixedDataSize(0) || uniqueID != 0 && !taskVarMeta.containsKey(uniqueID)) continue;
            byte[] metaData = taskFixedMeta.getByteArrayValue(offset);
            byte[] recurringData = taskVarData.getByteArray(uniqueID, fieldMap.getVarDataKey(TaskField.RECURRING_DATA));
            Task temp = this.m_file.getTaskByID(id2);
            if (temp != null) {
                if (!taskVarMeta.getUniqueIdentifierSet().contains(uniqueID)) continue;
                if (temp.getName() == null) {
                    this.m_file.removeTask(temp);
                }
            }
            task = this.m_file.addTask();
            task.disableEvents();
            fieldMap.populateContainer(TaskField.class, task, uniqueID, new byte[][]{data}, taskVarData);
            task.enableEvents();
            task.setEffortDriven((metaData[11] & 0x10) != 0);
            task.setEstimated(this.getDurationEstimated(MPPUtility.getShort(data, fieldMap.getFixedDataOffset(TaskField.ACTUAL_DURATION_UNITS))));
            task.setExpanded((metaData[12] & 2) == 0);
            Integer externalTaskID = task.getSubprojectTaskID();
            if (externalTaskID != null && externalTaskID != 0) {
                task.setSubprojectTaskID(externalTaskID);
                task.setExternalTask(true);
                externalTasks.add(task);
            }
            task.setFlag(1, (metaData[37] & 0x20) != 0);
            task.setFlag(2, (metaData[37] & 0x40) != 0);
            task.setFlag(3, (metaData[37] & 0x80) != 0);
            task.setFlag(4, (metaData[38] & 1) != 0);
            task.setFlag(5, (metaData[38] & 2) != 0);
            task.setFlag(6, (metaData[38] & 4) != 0);
            task.setFlag(7, (metaData[38] & 8) != 0);
            task.setFlag(8, (metaData[38] & 0x10) != 0);
            task.setFlag(9, (metaData[38] & 0x20) != 0);
            task.setFlag(10, (metaData[38] & 0x40) != 0);
            task.setFlag(11, (metaData[38] & 0x80) != 0);
            task.setFlag(12, (metaData[39] & 1) != 0);
            task.setFlag(13, (metaData[39] & 2) != 0);
            task.setFlag(14, (metaData[39] & 4) != 0);
            task.setFlag(15, (metaData[39] & 8) != 0);
            task.setFlag(16, (metaData[39] & 0x10) != 0);
            task.setFlag(17, (metaData[39] & 0x20) != 0);
            task.setFlag(18, (metaData[39] & 0x40) != 0);
            task.setFlag(19, (metaData[39] & 0x80) != 0);
            task.setFlag(20, (metaData[40] & 1) != 0);
            task.setHideBar((metaData[10] & 0x80) != 0);
            this.processHyperlinkData(task, taskVarData.getByteArray(uniqueID, fieldMap.getVarDataKey(TaskField.HYPERLINK_DATA)));
            task.setID(id2);
            task.setIgnoreResourceCalendar((metaData[10] & 2) != 0);
            task.setLevelAssignments((metaData[13] & 4) != 0);
            task.setLevelingCanSplit((metaData[13] & 2) != 0);
            task.setMarked((metaData[9] & 0x40) != 0);
            task.setMilestone((metaData[8] & 0x20) != 0);
            task.setOutlineCode(1, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE1_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(2, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE2_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(3, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE3_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(4, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE4_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(5, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE5_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(6, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE6_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(7, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE7_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(8, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE8_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(9, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE9_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode(10, this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE10_INDEX), OUTLINECODE_DATA));
            task.setRollup((metaData[10] & 8) != 0);
            task.setUniqueID(uniqueID);
            switch (task.getConstraintType()) {
                case AS_LATE_AS_POSSIBLE: {
                    if (DateHelper.compare(task.getStart(), task.getLateStart()) < 0) {
                        task.setStart(task.getLateStart());
                    }
                    if (DateHelper.compare(task.getFinish(), task.getLateFinish()) >= 0) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
                case START_NO_LATER_THAN: 
                case FINISH_NO_LATER_THAN: {
                    if (DateHelper.compare(task.getFinish(), task.getStart()) >= 0) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
            }
            if (recurringData != null) {
                if (recurringTaskReader == null) {
                    recurringTaskReader = new RecurringTaskReader(this.m_file.getProjectProperties());
                }
                recurringTaskReader.processRecurringTask(task, recurringData);
                task.setRecurring(true);
            }
            String notes = task.getNotes();
            if (!this.m_reader.getPreserveNoteFormatting()) {
                notes = RtfHelper.strip(notes);
            }
            task.setNotes(notes);
            Integer calendarID = (Integer)task.getCachedValue(TaskField.CALENDAR_UNIQUE_ID);
            if (calendarID != null && calendarID != -1 && (calendar = this.m_file.getCalendarByUniqueID(calendarID)) != null) {
                task.setCalendar(calendar);
            }
            SubProject sp = this.m_taskSubProjects.get(task.getUniqueID());
            task.setSubProject(sp);
            if (sp != null) {
                task.setExternalTask(sp.isExternalTask(task.getUniqueID()));
                if (task.getExternalTask()) {
                    task.setExternalTaskProject(sp.getFullPath());
                }
            }
            if (task.getWBS() != null) {
                autoWBS = false;
            }
            if (task.getName() == null && (task.getStart() == null || task.getStart().getTime() == MPPUtility.getEpochDate().getTime() || task.getFinish() == null || task.getFinish().getTime() == MPPUtility.getEpochDate().getTime() || task.getCreateDate() == null || task.getCreateDate().getTime() == MPPUtility.getEpochDate().getTime())) {
                this.m_file.removeTask(task);
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(uniqueID);
                task.setID(id2);
                continue;
            }
            this.processTaskEnterpriseColumns(fieldMap, task, taskVarData);
            this.m_eventManager.fireTaskReadEvent(task);
        }
        this.m_file.getProjectConfig().setAutoWBS(autoWBS);
        if (!externalTasks.isEmpty()) {
            this.processExternalTasks(externalTasks);
        }
    }

    private void processTaskEnterpriseColumns(FieldMap fieldMap, Task task, Var2Data taskVarData) {
        byte[] data = null;
        Integer varDataKey = fieldMap.getVarDataKey(TaskField.ENTERPRISE_DATA);
        if (varDataKey != null) {
            data = taskVarData.getByteArray(task.getUniqueID(), varDataKey);
        }
        if (data != null) {
            PropsBlock props = new PropsBlock(data);
            for (Integer key : props.keySet()) {
                int keyValue = key - 0xB400000;
                TaskField field = MPPTaskField.getInstance(keyValue);
                if (field == null) continue;
                Object value = null;
                switch (field.getDataType()) {
                    case CURRENCY: {
                        value = props.getDouble(key) / 100.0;
                        break;
                    }
                    case DATE: {
                        value = props.getTimestamp(key);
                        break;
                    }
                    case WORK: {
                        double durationValueInHours = MPPUtility.getDouble(props.getByteArray(key), 0) / 60000.0;
                        value = Duration.getInstance(durationValueInHours, TimeUnit.HOURS);
                        break;
                    }
                    case DURATION: {
                        byte[] durationData = props.getByteArray(key);
                        double durationValueInHours = (double)MPPUtility.getInt(durationData, 0) / 600.0;
                        TimeUnit durationUnits = durationData.length < 6 ? TimeUnit.DAYS : MPPUtility.getDurationTimeUnits(MPPUtility.getShort(durationData, 4));
                        Duration duration = Duration.getInstance(durationValueInHours, TimeUnit.HOURS);
                        value = duration.convertUnits(durationUnits, this.m_file.getProjectProperties());
                        break;
                    }
                    case BOOLEAN: {
                        field = null;
                        int bits = props.getInt(key);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG1, (bits & 2) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG2, (bits & 4) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG3, (bits & 8) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG4, (bits & 0x10) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG5, (bits & 0x20) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG6, (bits & 0x40) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG7, (bits & 0x80) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG8, (bits & 0x100) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG9, (bits & 0x200) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG10, (bits & 0x400) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG11, (bits & 0x800) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG12, (bits & 0x1000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG13, (bits & 0x2000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG14, (bits & 0x4000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG15, (bits & 0x8000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG16, (bits & 0x10000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG17, (bits & 0x20000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG18, (bits & 0x40000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG19, (bits & 0x80000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG20, (bits & 0x100000) != 0 ? 1 : 0);
                        break;
                    }
                    case NUMERIC: {
                        value = props.getDouble(key);
                        break;
                    }
                    case STRING: {
                        value = props.getUnicodeString(key);
                        break;
                    }
                    case PERCENTAGE: {
                        value = props.getShort(key);
                        break;
                    }
                }
                task.set((FieldType)field, value);
            }
        }
    }

    private void processResourceEnterpriseColumns(FieldMap fieldMap, Resource resource, Var2Data resourceVarData) {
        byte[] data = null;
        Integer varDataKey = fieldMap.getVarDataKey(ResourceField.ENTERPRISE_DATA);
        if (varDataKey != null) {
            data = resourceVarData.getByteArray(resource.getUniqueID(), varDataKey);
        }
        if (data != null) {
            PropsBlock props = new PropsBlock(data);
            resource.setCreationDate(props.getTimestamp(Props.RESOURCE_CREATION_DATE));
            for (Integer key : props.keySet()) {
                int keyValue = key - 0xC400000;
                ResourceField field = MPPResourceField.getInstance(keyValue);
                if (field == null) continue;
                Object value = null;
                block0 : switch (field.getDataType()) {
                    case CURRENCY: {
                        value = props.getDouble(key) / 100.0;
                        break;
                    }
                    case DATE: {
                        value = props.getTimestamp(key);
                        break;
                    }
                    case DURATION: {
                        byte[] durationData = props.getByteArray(key);
                        double durationValueInHours = (double)MPPUtility.getInt(durationData, 0) / 600.0;
                        TimeUnit durationUnits = durationData.length < 6 ? TimeUnit.DAYS : MPPUtility.getDurationTimeUnits(MPPUtility.getShort(durationData, 4));
                        Duration duration = Duration.getInstance(durationValueInHours, TimeUnit.HOURS);
                        value = duration.convertUnits(durationUnits, this.m_file.getProjectProperties());
                        break;
                    }
                    case BOOLEAN: {
                        switch (field) {
                            case FLAG1: {
                                field = null;
                                int bits = props.getInt(key);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG1, (bits & 2) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG2, (bits & 4) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG3, (bits & 8) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG4, (bits & 0x10) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG5, (bits & 0x20) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG6, (bits & 0x40) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG7, (bits & 0x80) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG8, (bits & 0x100) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG9, (bits & 0x200) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG10, (bits & 0x400) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG11, (bits & 0x800) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG12, (bits & 0x1000) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG13, (bits & 0x2000) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG14, (bits & 0x4000) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG15, (bits & 0x8000) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG16, (bits & 0x10000) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG17, (bits & 0x20000) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG18, (bits & 0x40000) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG19, (bits & 0x80000) != 0 ? 1 : 0);
                                resource.set((FieldType)ResourceField.ENTERPRISE_FLAG20, (bits & 0x100000) != 0 ? 1 : 0);
                                break block0;
                            }
                            case GENERIC: {
                                field = null;
                                resource.setGeneric(props.getShort(key) != 0);
                                break block0;
                            }
                        }
                        break;
                    }
                    case NUMERIC: {
                        value = props.getDouble(key);
                        break;
                    }
                    case STRING: {
                        value = props.getUnicodeString(key);
                        break;
                    }
                }
                resource.set((FieldType)field, value);
            }
        }
    }

    private void processExternalTasks(List<Task> externalTasks) {
        Collections.sort(externalTasks);
        SubProject currentSubProject = null;
        for (Task currentTask : externalTasks) {
            SubProject sp = currentTask.getSubProject();
            if (sp == null) {
                currentTask.setSubProject(currentSubProject);
                if (currentSubProject != null) {
                    currentTask.setExternalTaskProject(currentSubProject.getFullPath());
                }
            } else {
                currentSubProject = sp;
            }
            if (currentSubProject == null) continue;
            currentTask.setProject(currentSubProject.getFullPath());
        }
    }

    private void processHyperlinkData(Task task, byte[] data) {
        if (data != null) {
            int offset = 12;
            String hyperlink = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (hyperlink.length() + 1) * 2;
            String address = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (address.length() + 1) * 2;
            String subaddress = MPPUtility.getUnicodeString(data, offset += 12);
            task.setHyperlink(hyperlink);
            task.setHyperlinkAddress(address);
            task.setHyperlinkSubAddress(subaddress);
        }
    }

    private void processHyperlinkData(Resource resource, byte[] data) {
        if (data != null) {
            int offset = 12;
            String hyperlink = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (hyperlink.length() + 1) * 2;
            String address = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (address.length() + 1) * 2;
            String subaddress = MPPUtility.getUnicodeString(data, offset += 12);
            resource.setHyperlink(hyperlink);
            resource.setHyperlinkAddress(address);
            resource.setHyperlinkSubAddress(subaddress);
        }
    }

    private void processConstraintData() throws IOException {
        ConstraintFactory factory = new ConstraintFactory();
        factory.process(this.m_projectDir, this.m_file, this.m_inputStreamFactory);
    }

    private void processResourceData() throws IOException {
        FieldMap9 fieldMap = new FieldMap9(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap.createResourceFieldMap(this.m_projectProps);
        DirectoryEntry rscDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndRsc");
        VarMeta9 rscVarMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)rscDir.getEntry("VarMeta")));
        Var2Data rscVarData = new Var2Data(rscVarMeta, new DocumentInputStream((DocumentEntry)rscDir.getEntry("Var2Data")));
        FixedMeta rscFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)rscDir.getEntry("FixedMeta")), 37);
        FixedData rscFixedData = new FixedData(rscFixedMeta, this.m_inputStreamFactory.getInstance(rscDir, "FixedData"));
        this.processFieldNameAliases(RESOURCE_FIELD_ALIASES, this.m_projectProps.getByteArray(Props.RESOURCE_FIELD_NAME_ALIASES));
        TreeMap<Integer, Integer> resourceMap = this.createResourceMap(fieldMap, rscFixedMeta, rscFixedData);
        Integer[] uniqueid = rscVarMeta.getUniqueIdentifierArray();
        for (int loop = 0; loop < uniqueid.length; ++loop) {
            Integer id2 = uniqueid[loop];
            Integer offset = resourceMap.get(id2);
            if (offset == null) continue;
            byte[] data = rscFixedData.getByteArrayValue(offset);
            Resource resource = this.m_file.addResource();
            resource.disableEvents();
            fieldMap.populateContainer(ResourceField.class, resource, id2, new byte[][]{data}, rscVarData);
            resource.enableEvents();
            this.processHyperlinkData(resource, rscVarData.getByteArray(id2, fieldMap.getVarDataKey(ResourceField.HYPERLINK_DATA)));
            resource.setID(MPPUtility.getInt(data, 4));
            resource.setOutlineCode1(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE1_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode2(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE2_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode3(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE3_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode4(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE4_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode5(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE5_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode6(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE6_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode7(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE7_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode8(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE8_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode9(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE9_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode10(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE10_INDEX), OUTLINECODE_DATA));
            resource.setUniqueID(id2);
            byte[] metaData = rscFixedMeta.getByteArrayValue(offset);
            resource.setFlag(1, (metaData[28] & 0x40) != 0);
            resource.setFlag(2, (metaData[28] & 0x80) != 0);
            resource.setFlag(3, (metaData[29] & 1) != 0);
            resource.setFlag(4, (metaData[29] & 2) != 0);
            resource.setFlag(5, (metaData[29] & 4) != 0);
            resource.setFlag(6, (metaData[29] & 8) != 0);
            resource.setFlag(7, (metaData[29] & 0x10) != 0);
            resource.setFlag(8, (metaData[29] & 0x20) != 0);
            resource.setFlag(9, (metaData[29] & 0x40) != 0);
            resource.setFlag(10, (metaData[28] & 0x20) != 0);
            resource.setFlag(11, (metaData[29] & 0x80) != 0);
            resource.setFlag(12, (metaData[30] & 1) != 0);
            resource.setFlag(13, (metaData[30] & 2) != 0);
            resource.setFlag(14, (metaData[30] & 4) != 0);
            resource.setFlag(15, (metaData[30] & 8) != 0);
            resource.setFlag(16, (metaData[30] & 0x10) != 0);
            resource.setFlag(17, (metaData[30] & 0x20) != 0);
            resource.setFlag(18, (metaData[30] & 0x40) != 0);
            resource.setFlag(19, (metaData[30] & 0x80) != 0);
            resource.setFlag(20, (metaData[31] & 1) != 0);
            String notes = resource.getNotes();
            if (!this.m_reader.getPreserveNoteFormatting()) {
                notes = RtfHelper.strip(notes);
            }
            resource.setNotes(notes);
            resource.setResourceCalendar(this.m_resourceMap.get(id2));
            this.processResourceEnterpriseColumns(fieldMap, resource, rscVarData);
            CostRateTableFactory crt = new CostRateTableFactory();
            crt.process(resource, 0, rscVarData.getByteArray(id2, fieldMap.getVarDataKey(ResourceField.COST_RATE_A)));
            crt.process(resource, 1, rscVarData.getByteArray(id2, fieldMap.getVarDataKey(ResourceField.COST_RATE_B)));
            crt.process(resource, 2, rscVarData.getByteArray(id2, fieldMap.getVarDataKey(ResourceField.COST_RATE_C)));
            crt.process(resource, 3, rscVarData.getByteArray(id2, fieldMap.getVarDataKey(ResourceField.COST_RATE_D)));
            crt.process(resource, 4, rscVarData.getByteArray(id2, fieldMap.getVarDataKey(ResourceField.COST_RATE_E)));
            AvailabilityFactory af = new AvailabilityFactory();
            af.process(resource.getAvailability(), rscVarData.getByteArray(id2, fieldMap.getVarDataKey(ResourceField.AVAILABILITY_DATA)));
            if ((metaData[9] & 2) != 0) {
                resource.setType(ResourceType.WORK);
            } else {
                resource.setType(ResourceType.MATERIAL);
            }
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void processAssignmentData() throws IOException {
        FieldMap9 fieldMap = new FieldMap9(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap.createAssignmentFieldMap(this.m_projectProps);
        DirectoryEntry assnDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndAssn");
        VarMeta9 assnVarMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)assnDir.getEntry("VarMeta")));
        Var2Data assnVarData = new Var2Data(assnVarMeta, new DocumentInputStream((DocumentEntry)assnDir.getEntry("Var2Data")));
        FixedMeta assnFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)assnDir.getEntry("FixedMeta")), 34);
        FixedData assnFixedData = new FixedData(142, this.m_inputStreamFactory.getInstance(assnDir, "FixedData"));
        if (assnFixedData.getItemCount() != assnFixedMeta.getAdjustedItemCount()) {
            assnFixedData = new FixedData(assnFixedMeta, this.m_inputStreamFactory.getInstance(assnDir, "FixedData"));
        }
        ResourceAssignmentFactory factory = new ResourceAssignmentFactory();
        factory.process(this.m_file, fieldMap, null, this.m_reader.getUseRawTimephasedData(), this.m_reader.getPreserveNoteFormatting(), assnVarMeta, assnVarData, assnFixedMeta, assnFixedData, null, assnFixedMeta.getAdjustedItemCount());
    }

    private boolean getDurationEstimated(int type) {
        return (type & 0x20) != 0;
    }

    private void processViewData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CV_iew");
        VarMeta9 viewVarMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data viewVarData = new Var2Data(viewVarMeta, new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(122, this.m_inputStreamFactory.getInstance(dir, "FixedData"));
        int items = fixedMeta.getAdjustedItemCount();
        ViewFactory9 factory = new ViewFactory9();
        int lastOffset = -1;
        for (int loop = 0; loop < items; ++loop) {
            byte[] fm = fixedMeta.getByteArrayValue(loop);
            int offset = MPPUtility.getShort(fm, 4);
            if (offset <= lastOffset) continue;
            byte[] fd2 = fixedData.getByteArrayValue(fixedData.getIndexFromOffset(offset));
            if (fd2 != null) {
                View view = factory.createView(this.m_file, fm, fd2, viewVarData, this.m_fontBases);
                this.m_file.getViews().add(view);
            }
            lastOffset = offset;
        }
    }

    private void processTableData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CTable");
        InputStream stream = this.m_inputStreamFactory.getInstance(dir, "FixedData");
        int blockSize = stream.available() % 115 == 0 ? 115 : 110;
        FixedData fixedData = new FixedData(blockSize, stream);
        VarMeta9 varMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        TableContainer container = this.m_file.getTables();
        TableFactory factory = new TableFactory(TABLE_COLUMN_DATA_STANDARD, TABLE_COLUMN_DATA_ENTERPRISE, TABLE_COLUMN_DATA_BASELINE);
        int items = fixedData.getItemCount();
        for (int loop = 0; loop < items; ++loop) {
            byte[] data = fixedData.getByteArrayValue(loop);
            Table table = factory.createTable(this.m_file, data, varMeta, varData);
            container.add(table);
        }
    }

    private void processFilterData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CFilter");
        InputStream stream = this.m_inputStreamFactory.getInstance(dir, "FixedData");
        int blockSize = stream.available() % 115 == 0 ? 115 : 110;
        FixedData fixedData = new FixedData(blockSize, stream, true);
        VarMeta9 varMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        FilterReader9 reader = new FilterReader9();
        reader.process(this.m_file.getProjectProperties(), this.m_file.getFilters(), fixedData, varData);
    }

    private void processGroupData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CGrouping");
        FixedData fixedData = new FixedData(110, this.m_inputStreamFactory.getInstance(dir, "FixedData"));
        VarMeta9 varMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        GroupReader9 reader = new GroupReader9();
        reader.process(this.m_file, fixedData, varData, this.m_fontBases);
    }

    private void processSavedViewState() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CEdl");
        VarMeta9 varMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        InputStream is = this.m_inputStreamFactory.getInstance(dir, "FixedData");
        byte[] fixedData = new byte[is.available()];
        is.read(fixedData);
        ViewStateReader9 reader = new ViewStateReader9();
        reader.process(this.m_file, varData, fixedData);
    }

    private void processDataLinks() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CEdl");
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)dir.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(fixedMeta, this.m_inputStreamFactory.getInstance(dir, "FixedData"));
        VarMeta9 varMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        DataLinkFactory factory = new DataLinkFactory(this.m_file, fixedData, varData);
        factory.process();
    }

    private void postProcessTasks() {
        TaskContainer allTasks = this.m_file.getTasks();
        if (allTasks.size() > 1) {
            Collections.sort(allTasks);
            int taskID = -1;
            int lastTaskID = -1;
            for (int i2 = 0; i2 < allTasks.size(); ++i2) {
                Task task = (Task)allTasks.get(i2);
                taskID = NumberHelper.getInt(task.getID());
                if (!task.getNull() && lastTaskID != -1 && taskID > lastTaskID + 1) {
                    task.setNull(true);
                    continue;
                }
                lastTaskID = taskID;
            }
        }
    }

    static {
        RESOURCE_FIELD_ALIASES.put(52, ResourceField.TEXT1);
        RESOURCE_FIELD_ALIASES.put(53, ResourceField.TEXT2);
        RESOURCE_FIELD_ALIASES.put(54, ResourceField.TEXT3);
        RESOURCE_FIELD_ALIASES.put(55, ResourceField.TEXT4);
        RESOURCE_FIELD_ALIASES.put(56, ResourceField.TEXT5);
        RESOURCE_FIELD_ALIASES.put(57, ResourceField.TEXT6);
        RESOURCE_FIELD_ALIASES.put(58, ResourceField.TEXT7);
        RESOURCE_FIELD_ALIASES.put(59, ResourceField.TEXT8);
        RESOURCE_FIELD_ALIASES.put(60, ResourceField.TEXT9);
        RESOURCE_FIELD_ALIASES.put(61, ResourceField.TEXT10);
        RESOURCE_FIELD_ALIASES.put(62, ResourceField.TEXT11);
        RESOURCE_FIELD_ALIASES.put(63, ResourceField.TEXT12);
        RESOURCE_FIELD_ALIASES.put(64, ResourceField.TEXT13);
        RESOURCE_FIELD_ALIASES.put(65, ResourceField.TEXT14);
        RESOURCE_FIELD_ALIASES.put(66, ResourceField.TEXT15);
        RESOURCE_FIELD_ALIASES.put(67, ResourceField.TEXT16);
        RESOURCE_FIELD_ALIASES.put(68, ResourceField.TEXT17);
        RESOURCE_FIELD_ALIASES.put(69, ResourceField.TEXT18);
        RESOURCE_FIELD_ALIASES.put(70, ResourceField.TEXT19);
        RESOURCE_FIELD_ALIASES.put(71, ResourceField.TEXT20);
        RESOURCE_FIELD_ALIASES.put(72, ResourceField.TEXT21);
        RESOURCE_FIELD_ALIASES.put(73, ResourceField.TEXT22);
        RESOURCE_FIELD_ALIASES.put(74, ResourceField.TEXT23);
        RESOURCE_FIELD_ALIASES.put(75, ResourceField.TEXT24);
        RESOURCE_FIELD_ALIASES.put(76, ResourceField.TEXT25);
        RESOURCE_FIELD_ALIASES.put(77, ResourceField.TEXT26);
        RESOURCE_FIELD_ALIASES.put(78, ResourceField.TEXT27);
        RESOURCE_FIELD_ALIASES.put(79, ResourceField.TEXT28);
        RESOURCE_FIELD_ALIASES.put(80, ResourceField.TEXT29);
        RESOURCE_FIELD_ALIASES.put(81, ResourceField.TEXT30);
        RESOURCE_FIELD_ALIASES.put(82, ResourceField.START1);
        RESOURCE_FIELD_ALIASES.put(83, ResourceField.START2);
        RESOURCE_FIELD_ALIASES.put(84, ResourceField.START3);
        RESOURCE_FIELD_ALIASES.put(85, ResourceField.START4);
        RESOURCE_FIELD_ALIASES.put(86, ResourceField.START5);
        RESOURCE_FIELD_ALIASES.put(87, ResourceField.START6);
        RESOURCE_FIELD_ALIASES.put(88, ResourceField.START7);
        RESOURCE_FIELD_ALIASES.put(89, ResourceField.START8);
        RESOURCE_FIELD_ALIASES.put(90, ResourceField.START9);
        RESOURCE_FIELD_ALIASES.put(91, ResourceField.START10);
        RESOURCE_FIELD_ALIASES.put(92, ResourceField.FINISH1);
        RESOURCE_FIELD_ALIASES.put(93, ResourceField.FINISH2);
        RESOURCE_FIELD_ALIASES.put(94, ResourceField.FINISH3);
        RESOURCE_FIELD_ALIASES.put(95, ResourceField.FINISH4);
        RESOURCE_FIELD_ALIASES.put(96, ResourceField.FINISH5);
        RESOURCE_FIELD_ALIASES.put(97, ResourceField.FINISH6);
        RESOURCE_FIELD_ALIASES.put(98, ResourceField.FINISH7);
        RESOURCE_FIELD_ALIASES.put(99, ResourceField.FINISH8);
        RESOURCE_FIELD_ALIASES.put(100, ResourceField.FINISH9);
        RESOURCE_FIELD_ALIASES.put(101, ResourceField.FINISH10);
        RESOURCE_FIELD_ALIASES.put(102, ResourceField.NUMBER1);
        RESOURCE_FIELD_ALIASES.put(103, ResourceField.NUMBER2);
        RESOURCE_FIELD_ALIASES.put(104, ResourceField.NUMBER3);
        RESOURCE_FIELD_ALIASES.put(105, ResourceField.NUMBER4);
        RESOURCE_FIELD_ALIASES.put(106, ResourceField.NUMBER5);
        RESOURCE_FIELD_ALIASES.put(107, ResourceField.NUMBER6);
        RESOURCE_FIELD_ALIASES.put(108, ResourceField.NUMBER7);
        RESOURCE_FIELD_ALIASES.put(109, ResourceField.NUMBER8);
        RESOURCE_FIELD_ALIASES.put(110, ResourceField.NUMBER9);
        RESOURCE_FIELD_ALIASES.put(111, ResourceField.NUMBER10);
        RESOURCE_FIELD_ALIASES.put(112, ResourceField.NUMBER11);
        RESOURCE_FIELD_ALIASES.put(113, ResourceField.NUMBER12);
        RESOURCE_FIELD_ALIASES.put(114, ResourceField.NUMBER13);
        RESOURCE_FIELD_ALIASES.put(115, ResourceField.NUMBER14);
        RESOURCE_FIELD_ALIASES.put(116, ResourceField.NUMBER15);
        RESOURCE_FIELD_ALIASES.put(117, ResourceField.NUMBER16);
        RESOURCE_FIELD_ALIASES.put(118, ResourceField.NUMBER17);
        RESOURCE_FIELD_ALIASES.put(119, ResourceField.NUMBER18);
        RESOURCE_FIELD_ALIASES.put(120, ResourceField.NUMBER19);
        RESOURCE_FIELD_ALIASES.put(121, ResourceField.NUMBER20);
        RESOURCE_FIELD_ALIASES.put(122, ResourceField.DURATION1);
        RESOURCE_FIELD_ALIASES.put(123, ResourceField.DURATION2);
        RESOURCE_FIELD_ALIASES.put(124, ResourceField.DURATION3);
        RESOURCE_FIELD_ALIASES.put(125, ResourceField.DURATION4);
        RESOURCE_FIELD_ALIASES.put(126, ResourceField.DURATION5);
        RESOURCE_FIELD_ALIASES.put(127, ResourceField.DURATION6);
        RESOURCE_FIELD_ALIASES.put(128, ResourceField.DURATION7);
        RESOURCE_FIELD_ALIASES.put(129, ResourceField.DURATION8);
        RESOURCE_FIELD_ALIASES.put(130, ResourceField.DURATION9);
        RESOURCE_FIELD_ALIASES.put(131, ResourceField.DURATION10);
        RESOURCE_FIELD_ALIASES.put(145, ResourceField.DATE1);
        RESOURCE_FIELD_ALIASES.put(146, ResourceField.DATE2);
        RESOURCE_FIELD_ALIASES.put(147, ResourceField.DATE3);
        RESOURCE_FIELD_ALIASES.put(148, ResourceField.DATE4);
        RESOURCE_FIELD_ALIASES.put(149, ResourceField.DATE5);
        RESOURCE_FIELD_ALIASES.put(150, ResourceField.DATE6);
        RESOURCE_FIELD_ALIASES.put(151, ResourceField.DATE7);
        RESOURCE_FIELD_ALIASES.put(152, ResourceField.DATE8);
        RESOURCE_FIELD_ALIASES.put(153, ResourceField.DATE9);
        RESOURCE_FIELD_ALIASES.put(154, ResourceField.DATE10);
        RESOURCE_FIELD_ALIASES.put(155, ResourceField.OUTLINE_CODE1);
        RESOURCE_FIELD_ALIASES.put(156, ResourceField.OUTLINE_CODE2);
        RESOURCE_FIELD_ALIASES.put(157, ResourceField.OUTLINE_CODE3);
        RESOURCE_FIELD_ALIASES.put(158, ResourceField.OUTLINE_CODE4);
        RESOURCE_FIELD_ALIASES.put(159, ResourceField.OUTLINE_CODE5);
        RESOURCE_FIELD_ALIASES.put(160, ResourceField.OUTLINE_CODE6);
        RESOURCE_FIELD_ALIASES.put(161, ResourceField.OUTLINE_CODE7);
        RESOURCE_FIELD_ALIASES.put(162, ResourceField.OUTLINE_CODE8);
        RESOURCE_FIELD_ALIASES.put(163, ResourceField.OUTLINE_CODE9);
        RESOURCE_FIELD_ALIASES.put(164, ResourceField.OUTLINE_CODE10);
        RESOURCE_FIELD_ALIASES.put(165, ResourceField.FLAG10);
        RESOURCE_FIELD_ALIASES.put(166, ResourceField.FLAG1);
        RESOURCE_FIELD_ALIASES.put(167, ResourceField.FLAG2);
        RESOURCE_FIELD_ALIASES.put(168, ResourceField.FLAG3);
        RESOURCE_FIELD_ALIASES.put(169, ResourceField.FLAG4);
        RESOURCE_FIELD_ALIASES.put(170, ResourceField.FLAG5);
        RESOURCE_FIELD_ALIASES.put(171, ResourceField.FLAG6);
        RESOURCE_FIELD_ALIASES.put(172, ResourceField.FLAG7);
        RESOURCE_FIELD_ALIASES.put(173, ResourceField.FLAG8);
        RESOURCE_FIELD_ALIASES.put(174, ResourceField.FLAG9);
        RESOURCE_FIELD_ALIASES.put(175, ResourceField.FLAG11);
        RESOURCE_FIELD_ALIASES.put(176, ResourceField.FLAG12);
        RESOURCE_FIELD_ALIASES.put(177, ResourceField.FLAG13);
        RESOURCE_FIELD_ALIASES.put(178, ResourceField.FLAG14);
        RESOURCE_FIELD_ALIASES.put(179, ResourceField.FLAG15);
        RESOURCE_FIELD_ALIASES.put(180, ResourceField.FLAG16);
        RESOURCE_FIELD_ALIASES.put(181, ResourceField.FLAG17);
        RESOURCE_FIELD_ALIASES.put(182, ResourceField.FLAG18);
        RESOURCE_FIELD_ALIASES.put(183, ResourceField.FLAG19);
        RESOURCE_FIELD_ALIASES.put(184, ResourceField.FLAG20);
        RESOURCE_FIELD_ALIASES.put(207, ResourceField.COST1);
        RESOURCE_FIELD_ALIASES.put(208, ResourceField.COST2);
        RESOURCE_FIELD_ALIASES.put(209, ResourceField.COST3);
        RESOURCE_FIELD_ALIASES.put(210, ResourceField.COST4);
        RESOURCE_FIELD_ALIASES.put(211, ResourceField.COST5);
        RESOURCE_FIELD_ALIASES.put(212, ResourceField.COST6);
        RESOURCE_FIELD_ALIASES.put(213, ResourceField.COST7);
        RESOURCE_FIELD_ALIASES.put(214, ResourceField.COST8);
        RESOURCE_FIELD_ALIASES.put(215, ResourceField.COST9);
        RESOURCE_FIELD_ALIASES.put(216, ResourceField.COST10);
        TASK_FIELD_ALIASES = new HashMap<Integer, FieldType>();
        TASK_FIELD_ALIASES.put(118, TaskField.TEXT1);
        TASK_FIELD_ALIASES.put(119, TaskField.TEXT2);
        TASK_FIELD_ALIASES.put(120, TaskField.TEXT3);
        TASK_FIELD_ALIASES.put(121, TaskField.TEXT4);
        TASK_FIELD_ALIASES.put(122, TaskField.TEXT5);
        TASK_FIELD_ALIASES.put(123, TaskField.TEXT6);
        TASK_FIELD_ALIASES.put(124, TaskField.TEXT7);
        TASK_FIELD_ALIASES.put(125, TaskField.TEXT8);
        TASK_FIELD_ALIASES.put(126, TaskField.TEXT9);
        TASK_FIELD_ALIASES.put(127, TaskField.TEXT10);
        TASK_FIELD_ALIASES.put(128, TaskField.START1);
        TASK_FIELD_ALIASES.put(129, TaskField.FINISH1);
        TASK_FIELD_ALIASES.put(130, TaskField.START2);
        TASK_FIELD_ALIASES.put(131, TaskField.FINISH2);
        TASK_FIELD_ALIASES.put(132, TaskField.START3);
        TASK_FIELD_ALIASES.put(133, TaskField.FINISH3);
        TASK_FIELD_ALIASES.put(134, TaskField.START4);
        TASK_FIELD_ALIASES.put(135, TaskField.FINISH4);
        TASK_FIELD_ALIASES.put(136, TaskField.START5);
        TASK_FIELD_ALIASES.put(137, TaskField.FINISH5);
        TASK_FIELD_ALIASES.put(138, TaskField.START6);
        TASK_FIELD_ALIASES.put(139, TaskField.FINISH6);
        TASK_FIELD_ALIASES.put(140, TaskField.START7);
        TASK_FIELD_ALIASES.put(141, TaskField.FINISH7);
        TASK_FIELD_ALIASES.put(142, TaskField.START8);
        TASK_FIELD_ALIASES.put(143, TaskField.FINISH8);
        TASK_FIELD_ALIASES.put(144, TaskField.START9);
        TASK_FIELD_ALIASES.put(145, TaskField.FINISH9);
        TASK_FIELD_ALIASES.put(146, TaskField.START10);
        TASK_FIELD_ALIASES.put(147, TaskField.FINISH10);
        TASK_FIELD_ALIASES.put(149, TaskField.NUMBER1);
        TASK_FIELD_ALIASES.put(150, TaskField.NUMBER2);
        TASK_FIELD_ALIASES.put(151, TaskField.NUMBER3);
        TASK_FIELD_ALIASES.put(152, TaskField.NUMBER4);
        TASK_FIELD_ALIASES.put(153, TaskField.NUMBER5);
        TASK_FIELD_ALIASES.put(154, TaskField.NUMBER6);
        TASK_FIELD_ALIASES.put(155, TaskField.NUMBER7);
        TASK_FIELD_ALIASES.put(156, TaskField.NUMBER8);
        TASK_FIELD_ALIASES.put(157, TaskField.NUMBER9);
        TASK_FIELD_ALIASES.put(158, TaskField.NUMBER10);
        TASK_FIELD_ALIASES.put(159, TaskField.DURATION1);
        TASK_FIELD_ALIASES.put(161, TaskField.DURATION2);
        TASK_FIELD_ALIASES.put(163, TaskField.DURATION3);
        TASK_FIELD_ALIASES.put(165, TaskField.DURATION4);
        TASK_FIELD_ALIASES.put(167, TaskField.DURATION5);
        TASK_FIELD_ALIASES.put(169, TaskField.DURATION6);
        TASK_FIELD_ALIASES.put(171, TaskField.DURATION7);
        TASK_FIELD_ALIASES.put(173, TaskField.DURATION8);
        TASK_FIELD_ALIASES.put(175, TaskField.DURATION9);
        TASK_FIELD_ALIASES.put(177, TaskField.DURATION10);
        TASK_FIELD_ALIASES.put(184, TaskField.DATE1);
        TASK_FIELD_ALIASES.put(185, TaskField.DATE2);
        TASK_FIELD_ALIASES.put(186, TaskField.DATE3);
        TASK_FIELD_ALIASES.put(187, TaskField.DATE4);
        TASK_FIELD_ALIASES.put(188, TaskField.DATE5);
        TASK_FIELD_ALIASES.put(189, TaskField.DATE6);
        TASK_FIELD_ALIASES.put(190, TaskField.DATE7);
        TASK_FIELD_ALIASES.put(191, TaskField.DATE8);
        TASK_FIELD_ALIASES.put(192, TaskField.DATE9);
        TASK_FIELD_ALIASES.put(193, TaskField.DATE10);
        TASK_FIELD_ALIASES.put(194, TaskField.TEXT11);
        TASK_FIELD_ALIASES.put(195, TaskField.TEXT12);
        TASK_FIELD_ALIASES.put(196, TaskField.TEXT13);
        TASK_FIELD_ALIASES.put(197, TaskField.TEXT14);
        TASK_FIELD_ALIASES.put(198, TaskField.TEXT15);
        TASK_FIELD_ALIASES.put(199, TaskField.TEXT16);
        TASK_FIELD_ALIASES.put(200, TaskField.TEXT17);
        TASK_FIELD_ALIASES.put(201, TaskField.TEXT18);
        TASK_FIELD_ALIASES.put(202, TaskField.TEXT19);
        TASK_FIELD_ALIASES.put(203, TaskField.TEXT20);
        TASK_FIELD_ALIASES.put(204, TaskField.TEXT21);
        TASK_FIELD_ALIASES.put(205, TaskField.TEXT22);
        TASK_FIELD_ALIASES.put(206, TaskField.TEXT23);
        TASK_FIELD_ALIASES.put(207, TaskField.TEXT24);
        TASK_FIELD_ALIASES.put(208, TaskField.TEXT25);
        TASK_FIELD_ALIASES.put(209, TaskField.TEXT26);
        TASK_FIELD_ALIASES.put(210, TaskField.TEXT27);
        TASK_FIELD_ALIASES.put(211, TaskField.TEXT28);
        TASK_FIELD_ALIASES.put(212, TaskField.TEXT29);
        TASK_FIELD_ALIASES.put(213, TaskField.TEXT30);
        TASK_FIELD_ALIASES.put(214, TaskField.NUMBER11);
        TASK_FIELD_ALIASES.put(215, TaskField.NUMBER12);
        TASK_FIELD_ALIASES.put(216, TaskField.NUMBER13);
        TASK_FIELD_ALIASES.put(217, TaskField.NUMBER14);
        TASK_FIELD_ALIASES.put(218, TaskField.NUMBER15);
        TASK_FIELD_ALIASES.put(219, TaskField.NUMBER16);
        TASK_FIELD_ALIASES.put(220, TaskField.NUMBER17);
        TASK_FIELD_ALIASES.put(221, TaskField.NUMBER18);
        TASK_FIELD_ALIASES.put(222, TaskField.NUMBER19);
        TASK_FIELD_ALIASES.put(223, TaskField.NUMBER20);
        TASK_FIELD_ALIASES.put(227, TaskField.OUTLINE_CODE1);
        TASK_FIELD_ALIASES.put(228, TaskField.OUTLINE_CODE2);
        TASK_FIELD_ALIASES.put(229, TaskField.OUTLINE_CODE3);
        TASK_FIELD_ALIASES.put(230, TaskField.OUTLINE_CODE4);
        TASK_FIELD_ALIASES.put(231, TaskField.OUTLINE_CODE5);
        TASK_FIELD_ALIASES.put(232, TaskField.OUTLINE_CODE6);
        TASK_FIELD_ALIASES.put(233, TaskField.OUTLINE_CODE7);
        TASK_FIELD_ALIASES.put(234, TaskField.OUTLINE_CODE8);
        TASK_FIELD_ALIASES.put(235, TaskField.OUTLINE_CODE9);
        TASK_FIELD_ALIASES.put(236, TaskField.OUTLINE_CODE10);
        TASK_FIELD_ALIASES.put(237, TaskField.FLAG1);
        TASK_FIELD_ALIASES.put(238, TaskField.FLAG2);
        TASK_FIELD_ALIASES.put(239, TaskField.FLAG3);
        TASK_FIELD_ALIASES.put(240, TaskField.FLAG4);
        TASK_FIELD_ALIASES.put(241, TaskField.FLAG5);
        TASK_FIELD_ALIASES.put(242, TaskField.FLAG6);
        TASK_FIELD_ALIASES.put(243, TaskField.FLAG7);
        TASK_FIELD_ALIASES.put(244, TaskField.FLAG8);
        TASK_FIELD_ALIASES.put(245, TaskField.FLAG9);
        TASK_FIELD_ALIASES.put(246, TaskField.FLAG10);
        TASK_FIELD_ALIASES.put(247, TaskField.FLAG11);
        TASK_FIELD_ALIASES.put(248, TaskField.FLAG12);
        TASK_FIELD_ALIASES.put(249, TaskField.FLAG13);
        TASK_FIELD_ALIASES.put(250, TaskField.FLAG14);
        TASK_FIELD_ALIASES.put(251, TaskField.FLAG15);
        TASK_FIELD_ALIASES.put(252, TaskField.FLAG16);
        TASK_FIELD_ALIASES.put(253, TaskField.FLAG17);
        TASK_FIELD_ALIASES.put(254, TaskField.FLAG18);
        TASK_FIELD_ALIASES.put(255, TaskField.FLAG19);
        TASK_FIELD_ALIASES.put(256, TaskField.FLAG20);
        TASK_FIELD_ALIASES.put(278, TaskField.COST1);
        TASK_FIELD_ALIASES.put(279, TaskField.COST2);
        TASK_FIELD_ALIASES.put(280, TaskField.COST3);
        TASK_FIELD_ALIASES.put(281, TaskField.COST4);
        TASK_FIELD_ALIASES.put(282, TaskField.COST5);
        TASK_FIELD_ALIASES.put(283, TaskField.COST6);
        TASK_FIELD_ALIASES.put(284, TaskField.COST7);
        TASK_FIELD_ALIASES.put(285, TaskField.COST8);
        TASK_FIELD_ALIASES.put(286, TaskField.COST9);
        TASK_FIELD_ALIASES.put(287, TaskField.COST10);
    }
}

