/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.util.Date;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.mpp.AbstractCalendarFactory;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.VarMeta;
import net.sf.mpxj.mpp.VarMeta9;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

class MPP9CalendarFactory
extends AbstractCalendarFactory {
    private static final Integer CALENDAR_NAME = 1;
    private static final Integer CALENDAR_DATA = 3;

    public MPP9CalendarFactory(ProjectFile file) {
        super(file);
    }

    @Override
    protected int getCalendarIDOffset() {
        return 0;
    }

    @Override
    protected int getBaseIDOffset() {
        return 4;
    }

    @Override
    protected int getResourceIDOffset() {
        return 8;
    }

    @Override
    protected int getCalendarHoursOffset() {
        return 4;
    }

    @Override
    protected Integer getCalendarNameVarDataType() {
        return CALENDAR_NAME;
    }

    @Override
    protected Integer getCalendarDataVarDataType() {
        return CALENDAR_DATA;
    }

    @Override
    protected VarMeta getCalendarVarMeta(DirectoryEntry directory) throws IOException {
        return new VarMeta9(new DocumentInputStream((DocumentEntry)directory.getEntry("VarMeta")));
    }

    @Override
    protected void processCalendarExceptions(byte[] data, ProjectCalendar cal) {
        int exceptionCount = MPPUtility.getShort(data, 0);
        if (exceptionCount != 0) {
            for (int index = 0; index < exceptionCount; ++index) {
                int offset = 424 + index * 64;
                Date fromDate = MPPUtility.getDate(data, offset);
                Date toDate = MPPUtility.getDate(data, offset + 2);
                ProjectCalendarException exception = cal.addCalendarException(fromDate, toDate);
                int periodCount = MPPUtility.getShort(data, offset + 6);
                if (periodCount == 0) continue;
                for (int exceptionPeriodIndex = 0; exceptionPeriodIndex < periodCount; ++exceptionPeriodIndex) {
                    Date start = MPPUtility.getTime(data, offset + 12 + exceptionPeriodIndex * 2);
                    long duration = MPPUtility.getDuration(data, offset + 24 + exceptionPeriodIndex * 4);
                    exception.addRange(new DateRange(start, new Date(start.getTime() + duration)));
                }
            }
        }
    }
}

