/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.LinkedList;
import net.sf.mpxj.Filter;
import net.sf.mpxj.FilterContainer;
import net.sf.mpxj.GenericCriteriaPrompt;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.mpp.CriteriaReader;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Var2Data;

public abstract class FilterReader {
    protected abstract Integer getVarDataType();

    protected abstract CriteriaReader getCriteriaReader();

    public void process(ProjectProperties properties, FilterContainer filters, FixedData fixedData, Var2Data varData) {
        int filterCount = fixedData.getItemCount();
        boolean[] criteriaType = new boolean[2];
        CriteriaReader criteriaReader = this.getCriteriaReader();
        for (int filterLoop = 0; filterLoop < filterCount; ++filterLoop) {
            byte[] filterFixedData = fixedData.getByteArrayValue(filterLoop);
            if (filterFixedData == null || filterFixedData.length < 4) continue;
            Filter filter = new Filter();
            filter.setID(MPPUtility.getInt(filterFixedData, 0));
            filter.setName(MPPUtility.removeAmpersands(MPPUtility.getUnicodeString(filterFixedData, 4)));
            byte[] filterVarData = varData.getByteArray(filter.getID(), this.getVarDataType());
            if (filterVarData == null) continue;
            LinkedList<GenericCriteriaPrompt> prompts = new LinkedList<GenericCriteriaPrompt>();
            filter.setShowRelatedSummaryRows(MPPUtility.getByte(filterVarData, 4) != 0);
            filter.setCriteria(criteriaReader.process(properties, filterVarData, 0, -1, prompts, null, criteriaType));
            filter.setIsTaskFilter(criteriaType[0]);
            filter.setIsResourceFilter(criteriaType[1]);
            filter.setPrompts(prompts);
            filters.addFilter(filter);
        }
    }
}

