/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.BookingType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.DataType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.ResourceRequestType;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkGroup;
import net.sf.mpxj.common.ByteArrayHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.DoubleVarDataFieldReader;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.StringVarDataFieldReader;
import net.sf.mpxj.mpp.TimestampVarDataFieldReader;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarDataFieldReader;

abstract class FieldMap {
    private final ProjectProperties m_properties;
    final VarDataFieldReader m_stringVarDataReader;
    final VarDataFieldReader m_doubleVarDataReader;
    final VarDataFieldReader m_timestampVarDataReader;
    private Map<FieldType, FieldItem> m_map = new HashMap<FieldType, FieldItem>();
    private int[] m_maxFixedDataSize = new int[2];
    private boolean m_debug;
    private static final Integer[] TASK_KEYS = new Integer[]{Props.TASK_FIELD_MAP, Props.TASK_FIELD_MAP2};
    private static final Integer[] ENTERPRISE_CUSTOM_KEYS = new Integer[]{Props.ENTERPRISE_CUSTOM_FIELD_MAP};
    private static final Integer[] RESOURCE_KEYS = new Integer[]{Props.RESOURCE_FIELD_MAP, Props.RESOURCE_FIELD_MAP2};
    private static final Integer[] ASSIGNMENT_KEYS = new Integer[]{Props.ASSIGNMENT_FIELD_MAP, Props.ASSIGNMENT_FIELD_MAP2};
    private static final Integer[] RELATION_KEYS = new Integer[]{Props.RELATION_FIELD_MAP};
    private static final int MAX_FIXED_DATA_BLOCKS = 2;

    public FieldMap(ProjectProperties properties, CustomFieldContainer customFields) {
        this.m_properties = properties;
        this.m_stringVarDataReader = new StringVarDataFieldReader(customFields);
        this.m_doubleVarDataReader = new DoubleVarDataFieldReader(customFields);
        this.m_timestampVarDataReader = new TimestampVarDataFieldReader(customFields);
    }

    public void setDebug(boolean value) {
        this.m_debug = value;
    }

    private void createFieldMap(byte[] data) {
        int lastDataBlockOffset = 0;
        int dataBlockIndex = 0;
        for (int index = 0; index < data.length; index += 28) {
            int metaBlock;
            FieldLocation location;
            Integer substitute;
            long mask = MPPUtility.getInt(data, index + 0);
            int dataBlockOffset = MPPUtility.getShort(data, index + 4);
            FieldType type = this.getFieldType(MPPUtility.getInt(data, index + 12));
            int category = MPPUtility.getShort(data, index + 20);
            int varDataKey = this.useTypeAsVarDataKey() ? ((substitute = this.substituteVarDataKey(type)) == null ? MPPUtility.getInt(data, index + 12) & 0xFFFF : substitute) : MPPUtility.getByte(data, index + 6);
            switch (category) {
                case 11: {
                    location = FieldLocation.META_DATA;
                    metaBlock = 0;
                    break;
                }
                case 100: {
                    location = FieldLocation.META_DATA;
                    metaBlock = 1;
                    break;
                }
                default: {
                    metaBlock = 0;
                    if (dataBlockOffset != 65535) {
                        location = FieldLocation.FIXED_DATA;
                        if (dataBlockOffset < lastDataBlockOffset) {
                            ++dataBlockIndex;
                        }
                        lastDataBlockOffset = dataBlockOffset;
                        int typeSize = this.getFixedDataFieldSize(type);
                        if (dataBlockOffset + typeSize <= this.m_maxFixedDataSize[dataBlockIndex]) break;
                        this.m_maxFixedDataSize[dataBlockIndex] = dataBlockOffset + typeSize;
                        break;
                    }
                    location = varDataKey != 0 ? FieldLocation.VAR_DATA : FieldLocation.UNKNOWN;
                }
            }
            FieldItem item = new FieldItem(type, location, dataBlockIndex, dataBlockOffset, varDataKey, mask, metaBlock);
            if (this.m_debug) {
                System.out.println(ByteArrayHelper.hexdump(data, index, 28, false) + " " + item + " mpxjDataType=" + item.getType().getDataType() + " index=" + index);
            }
            this.m_map.put(type, item);
        }
    }

    protected abstract boolean useTypeAsVarDataKey();

    protected abstract FieldItem[] getDefaultTaskData();

    protected abstract FieldItem[] getDefaultResourceData();

    protected abstract FieldItem[] getDefaultAssignmentData();

    protected abstract FieldItem[] getDefaultRelationData();

    protected abstract FieldType getFieldType(int var1);

    protected abstract Integer substituteVarDataKey(FieldType var1);

    public void createTaskFieldMap(Props props) {
        Integer key;
        byte[] fieldMapData = null;
        Integer[] integerArray = TASK_KEYS;
        int n2 = integerArray.length;
        for (int i2 = 0; i2 < n2 && (fieldMapData = props.getByteArray(key = integerArray[i2])) == null; ++i2) {
        }
        if (fieldMapData == null) {
            this.populateDefaultData(this.getDefaultTaskData());
        } else {
            this.createFieldMap(fieldMapData);
        }
    }

    public void createRelationFieldMap(Props props) {
        Integer key;
        byte[] fieldMapData = null;
        Integer[] integerArray = RELATION_KEYS;
        int n2 = integerArray.length;
        for (int i2 = 0; i2 < n2 && (fieldMapData = props.getByteArray(key = integerArray[i2])) == null; ++i2) {
        }
        if (fieldMapData == null) {
            this.populateDefaultData(this.getDefaultRelationData());
        } else {
            this.createFieldMap(fieldMapData);
        }
    }

    public void createEnterpriseCustomFieldMap(Props props, Class<?> c2) {
        Integer key;
        byte[] fieldMapData = null;
        Integer[] integerArray = ENTERPRISE_CUSTOM_KEYS;
        int n2 = integerArray.length;
        for (int i2 = 0; i2 < n2 && (fieldMapData = props.getByteArray(key = integerArray[i2])) == null; ++i2) {
        }
        if (fieldMapData != null) {
            for (int index = 4; index < fieldMapData.length; index += 4) {
                int typeValue = MPPUtility.getInt(fieldMapData, index);
                FieldType type = this.getFieldType(typeValue);
                if (type == null || type.getClass() != c2 || !type.toString().startsWith("Enterprise Custom Field")) continue;
                int varDataKey = typeValue & 0xFFFF;
                FieldItem item = new FieldItem(type, FieldLocation.VAR_DATA, 0, 0, varDataKey, 0L, 0);
                this.m_map.put(type, item);
            }
        }
    }

    public void createResourceFieldMap(Props props) {
        Integer key;
        byte[] fieldMapData = null;
        Integer[] integerArray = RESOURCE_KEYS;
        int n2 = integerArray.length;
        for (int i2 = 0; i2 < n2 && (fieldMapData = props.getByteArray(key = integerArray[i2])) == null; ++i2) {
        }
        if (fieldMapData == null) {
            this.populateDefaultData(this.getDefaultResourceData());
        } else {
            this.createFieldMap(fieldMapData);
        }
    }

    public void createAssignmentFieldMap(Props props) {
        Integer key;
        byte[] fieldMapData = null;
        Integer[] integerArray = ASSIGNMENT_KEYS;
        int n2 = integerArray.length;
        for (int i2 = 0; i2 < n2 && (fieldMapData = props.getByteArray(key = integerArray[i2])) == null; ++i2) {
        }
        if (fieldMapData == null) {
            this.populateDefaultData(this.getDefaultAssignmentData());
        } else {
            this.createFieldMap(fieldMapData);
        }
    }

    private void populateDefaultData(FieldItem[] defaultData) {
        for (FieldItem item : defaultData) {
            this.m_map.put(item.getType(), item);
        }
    }

    public void populateContainer(Class<? extends FieldType> type, FieldContainer container, Integer id2, byte[][] fixedData, Var2Data varData) {
        for (FieldItem item : this.m_map.values()) {
            if (!item.getType().getClass().equals(type)) continue;
            Object value = item.read(id2, fixedData, varData);
            container.set(item.getType(), value);
        }
    }

    public int getMaxFixedDataSize(int blockIndex) {
        return this.m_maxFixedDataSize[blockIndex];
    }

    public int getFixedDataOffset(FieldType type) {
        FieldItem item = this.m_map.get(type);
        int result = item != null ? item.getFixedDataOffset() : -1;
        return result;
    }

    public Integer getVarDataKey(FieldType type) {
        Integer result = null;
        FieldItem item = this.m_map.get(type);
        if (item != null) {
            result = item.getVarDataKey();
        }
        return result;
    }

    public FieldType getFieldTypeFromVarDataKey(Integer key) {
        FieldType result = null;
        for (Map.Entry<FieldType, FieldItem> entry : this.m_map.entrySet()) {
            if (entry.getValue().getFieldLocation() != FieldLocation.VAR_DATA || !entry.getValue().getVarDataKey().equals(key)) continue;
            result = entry.getKey();
            break;
        }
        return result;
    }

    public FieldLocation getFieldLocation(FieldType type) {
        FieldLocation result = null;
        FieldItem item = this.m_map.get(type);
        if (item != null) {
            result = item.getFieldLocation();
        }
        return result;
    }

    protected Object getFieldData(Integer id2, FieldType type, byte[][] fixedData, Var2Data varData) {
        Object result = null;
        FieldItem item = this.m_map.get(type);
        if (item != null) {
            result = item.read(id2, fixedData, varData);
        }
        return result;
    }

    protected ProjectProperties getProjectProperties() {
        return this.m_properties;
    }

    public void clear() {
        this.m_map.clear();
        Arrays.fill(this.m_maxFixedDataSize, 0);
    }

    public void dumpKnownFieldMaps(Props props) {
        for (int key = 50331668; key < 50331674; ++key) {
            byte[] fieldMapData = props.getByteArray(key);
            if (fieldMapData == null) continue;
            System.out.println("KEY: " + key);
            this.createFieldMap(fieldMapData);
            System.out.println(this.toString());
            this.clear();
        }
    }

    private int getFixedDataFieldSize(FieldType type) {
        int result = 0;
        DataType dataType = type.getDataType();
        if (dataType != null) {
            switch (dataType) {
                case DATE: 
                case INTEGER: 
                case DURATION: {
                    result = 4;
                    break;
                }
                case TIME_UNITS: 
                case CONSTRAINT: 
                case PRIORITY: 
                case PERCENTAGE: 
                case TASK_TYPE: 
                case ACCRUE: 
                case SHORT: 
                case BOOLEAN: 
                case DELAY: 
                case WORKGROUP: 
                case RATE_UNITS: 
                case EARNED_VALUE_METHOD: 
                case RESOURCE_REQUEST_TYPE: {
                    result = 2;
                    break;
                }
                case CURRENCY: 
                case UNITS: 
                case RATE: 
                case WORK: {
                    result = 8;
                    break;
                }
                case WORK_UNITS: {
                    result = 1;
                    break;
                }
                case GUID: {
                    result = 16;
                    break;
                }
                default: {
                    result = 0;
                }
            }
        }
        return result;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ArrayList<FieldItem> items = new ArrayList<FieldItem>(this.m_map.values());
        Collections.sort(items);
        pw.println("[FieldMap");
        for (int loop = 0; loop < this.m_maxFixedDataSize.length; ++loop) {
            pw.print(" MaxFixedOffset (block ");
            pw.print(loop);
            pw.print(")=");
            pw.println(this.m_maxFixedDataSize[loop]);
        }
        for (FieldItem item : items) {
            pw.print(" ");
            pw.println(item);
        }
        pw.println("]");
        pw.close();
        return sw.toString();
    }

    public class FieldItem
    implements Comparable<FieldItem> {
        private FieldType m_type;
        private FieldLocation m_location;
        private int m_fixedDataBlockIndex;
        private int m_fixedDataOffset;
        private Integer m_varDataKey;
        private long m_mask;
        private int m_metaBlock;

        FieldItem(FieldType type, FieldLocation location, int fixedDataBlockIndex, int fixedDataOffset, int varDataKey, long mask, int metaBlock) {
            this.m_type = type;
            this.m_location = location;
            this.m_fixedDataBlockIndex = fixedDataBlockIndex;
            this.m_fixedDataOffset = fixedDataOffset;
            this.m_varDataKey = varDataKey;
            this.m_mask = mask;
            this.m_metaBlock = metaBlock;
        }

        public Object read(Integer id2, byte[][] fixedData, Var2Data varData) {
            Object result = null;
            switch (this.m_location) {
                case FIXED_DATA: {
                    result = this.readFixedData(id2, fixedData, varData);
                    break;
                }
                case VAR_DATA: {
                    result = this.readVarData(id2, fixedData, varData);
                    break;
                }
                case META_DATA: {
                    break;
                }
            }
            return result;
        }

        private Object readFixedData(Integer id2, byte[][] fixedData, Var2Data varData) {
            byte[] data;
            Object result = null;
            if (this.m_fixedDataBlockIndex < fixedData.length && (data = fixedData[this.m_fixedDataBlockIndex]) != null && this.m_fixedDataOffset < data.length) {
                switch (this.m_type.getDataType()) {
                    case DATE: {
                        result = MPPUtility.getTimestamp(data, this.m_fixedDataOffset);
                        break;
                    }
                    case INTEGER: {
                        result = MPPUtility.getInt(data, this.m_fixedDataOffset);
                        break;
                    }
                    case DURATION: {
                        FieldType unitsType = this.m_type.getUnitsType();
                        TimeUnit units = (TimeUnit)FieldMap.this.getFieldData(id2, unitsType, fixedData, varData);
                        if (units == null) {
                            units = FieldMap.this.getProjectProperties().getDefaultDurationUnits();
                        }
                        result = MPPUtility.getAdjustedDuration(FieldMap.this.getProjectProperties(), MPPUtility.getInt(data, this.m_fixedDataOffset), units);
                        break;
                    }
                    case TIME_UNITS: {
                        result = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, this.m_fixedDataOffset), FieldMap.this.getProjectProperties().getDefaultDurationUnits());
                        break;
                    }
                    case CONSTRAINT: {
                        result = ConstraintType.getInstance(MPPUtility.getShort(data, this.m_fixedDataOffset));
                        break;
                    }
                    case PRIORITY: {
                        result = Priority.getInstance(MPPUtility.getShort(data, this.m_fixedDataOffset));
                        break;
                    }
                    case PERCENTAGE: {
                        result = MPPUtility.getPercentage(data, this.m_fixedDataOffset);
                        break;
                    }
                    case TASK_TYPE: {
                        result = TaskType.getInstance(MPPUtility.getShort(data, this.m_fixedDataOffset));
                        break;
                    }
                    case ACCRUE: {
                        result = AccrueType.getInstance(MPPUtility.getShort(data, this.m_fixedDataOffset));
                        break;
                    }
                    case CURRENCY: 
                    case UNITS: {
                        double amount = MPPUtility.getDouble(data, this.m_fixedDataOffset);
                        amount = Math.abs(amount) < 0.1 ? 0.0 : amount;
                        result = NumberHelper.getDouble(amount / 100.0);
                        break;
                    }
                    case RATE: {
                        result = new Rate(MPPUtility.getDouble(data, this.m_fixedDataOffset), TimeUnit.HOURS);
                        break;
                    }
                    case WORK: {
                        double duration = MPPUtility.getDouble(data, this.m_fixedDataOffset);
                        duration = Math.abs(duration) < 1000.0 ? 0.0 : duration;
                        result = Duration.getInstance(duration / 60000.0, TimeUnit.HOURS);
                        break;
                    }
                    case SHORT: {
                        result = MPPUtility.getShort(data, this.m_fixedDataOffset);
                        break;
                    }
                    case BOOLEAN: {
                        result = MPPUtility.getShort(data, this.m_fixedDataOffset) != 0;
                        break;
                    }
                    case DELAY: {
                        result = MPPUtility.getDuration(MPPUtility.getShort(data, this.m_fixedDataOffset), TimeUnit.HOURS);
                        break;
                    }
                    case WORK_UNITS: {
                        int variableRateUnitsValue = MPPUtility.getByte(data, this.m_fixedDataOffset);
                        result = variableRateUnitsValue == 0 ? null : MPPUtility.getWorkTimeUnits(variableRateUnitsValue);
                        break;
                    }
                    case WORKGROUP: {
                        result = WorkGroup.getInstance(MPPUtility.getShort(data, this.m_fixedDataOffset));
                        break;
                    }
                    case RATE_UNITS: {
                        result = TimeUnit.getInstance(MPPUtility.getShort(data, this.m_fixedDataOffset) - 1);
                        break;
                    }
                    case EARNED_VALUE_METHOD: {
                        result = EarnedValueMethod.getInstance(MPPUtility.getShort(data, this.m_fixedDataOffset));
                        break;
                    }
                    case RESOURCE_REQUEST_TYPE: {
                        result = ResourceRequestType.getInstance(MPPUtility.getShort(data, this.m_fixedDataOffset));
                        break;
                    }
                    case GUID: {
                        result = MPPUtility.getGUID(data, this.m_fixedDataOffset);
                        break;
                    }
                    case BINARY: {
                        break;
                    }
                }
            }
            return result;
        }

        private Object readVarData(Integer id2, byte[][] fixedData, Var2Data varData) {
            Object result = null;
            switch (this.m_type.getDataType()) {
                case DURATION: {
                    FieldType unitsType = this.m_type.getUnitsType();
                    TimeUnit units = (TimeUnit)FieldMap.this.getFieldData(id2, unitsType, fixedData, varData);
                    if (units == null) {
                        units = TimeUnit.HOURS;
                    }
                    result = this.getCustomFieldDurationValue(varData, id2, this.m_varDataKey, units);
                    break;
                }
                case TIME_UNITS: {
                    result = MPPUtility.getDurationTimeUnits(varData.getShort(id2, this.m_varDataKey), FieldMap.this.getProjectProperties().getDefaultDurationUnits());
                    break;
                }
                case CURRENCY: {
                    double amount = varData.getDouble(id2, this.m_varDataKey);
                    amount = Math.abs(amount) < 0.1 ? 0.0 : amount;
                    result = NumberHelper.getDouble(amount / 100.0);
                    break;
                }
                case STRING: {
                    result = FieldMap.this.m_stringVarDataReader.getValue(varData, id2, this.m_varDataKey);
                    break;
                }
                case DATE: {
                    result = FieldMap.this.m_timestampVarDataReader.getValue(varData, id2, this.m_varDataKey);
                    break;
                }
                case NUMERIC: {
                    result = FieldMap.this.m_doubleVarDataReader.getValue(varData, id2, this.m_varDataKey);
                    break;
                }
                case INTEGER: {
                    result = varData.getInt(id2, this.m_varDataKey);
                    break;
                }
                case WORK: {
                    double duration = varData.getDouble(id2, this.m_varDataKey);
                    duration = Math.abs(duration) < 1000.0 ? 0.0 : duration;
                    result = Duration.getInstance(duration / 60000.0, TimeUnit.HOURS);
                    break;
                }
                case ASCII_STRING: {
                    result = varData.getString(id2, this.m_varDataKey);
                    break;
                }
                case DELAY: {
                    result = MPPUtility.getDuration(varData.getShort(id2, this.m_varDataKey), TimeUnit.HOURS);
                    break;
                }
                case WORK_UNITS: {
                    int variableRateUnitsValue = varData.getByte(id2, this.m_varDataKey);
                    result = variableRateUnitsValue == 0 ? null : MPPUtility.getWorkTimeUnits(variableRateUnitsValue);
                    break;
                }
                case RATE_UNITS: {
                    result = TimeUnit.getInstance(varData.getShort(id2, this.m_varDataKey) - 1);
                    break;
                }
                case EARNED_VALUE_METHOD: {
                    result = EarnedValueMethod.getInstance(varData.getShort(id2, this.m_varDataKey));
                    break;
                }
                case RESOURCE_REQUEST_TYPE: {
                    result = ResourceRequestType.getInstance(varData.getShort(id2, this.m_varDataKey));
                    break;
                }
                case ACCRUE: {
                    result = AccrueType.getInstance(varData.getShort(id2, this.m_varDataKey));
                    break;
                }
                case SHORT: {
                    result = varData.getShort(id2, this.m_varDataKey);
                    break;
                }
                case BOOLEAN: {
                    result = varData.getShort(id2, this.m_varDataKey) != 0;
                    break;
                }
                case WORKGROUP: {
                    result = WorkGroup.getInstance(varData.getShort(id2, this.m_varDataKey));
                    break;
                }
                case GUID: {
                    result = MPPUtility.getGUID(varData.getByteArray(id2, this.m_varDataKey), 0);
                    break;
                }
                case BOOKING_TYPE: {
                    result = BookingType.getInstance(varData.getShort(id2, this.m_varDataKey));
                    break;
                }
                case BINARY: {
                    break;
                }
            }
            return result;
        }

        private Object getCustomFieldDurationValue(Var2Data varData, Integer id2, Integer type, TimeUnit units) {
            Object result = null;
            byte[] data = varData.getByteArray(id2, type);
            if (data != null) {
                if (data.length == 512) {
                    result = MPPUtility.getUnicodeString(data, 0);
                } else if (data.length >= 4) {
                    int duration = MPPUtility.getInt(data, 0);
                    result = MPPUtility.getAdjustedDuration(FieldMap.this.getProjectProperties(), duration, units);
                }
            }
            return result;
        }

        public FieldType getType() {
            return this.m_type;
        }

        public int getFixedDataBlockIndex() {
            return this.m_fixedDataBlockIndex;
        }

        public int getFixedDataOffset() {
            return this.m_fixedDataOffset;
        }

        public Integer getVarDataKey() {
            return this.m_varDataKey;
        }

        public FieldLocation getFieldLocation() {
            return this.m_location;
        }

        @Override
        public int compareTo(FieldItem item) {
            int result = this.m_location.compareTo(item.m_location);
            if (result == 0) {
                switch (this.m_location) {
                    case FIXED_DATA: {
                        result = this.m_fixedDataBlockIndex - item.m_fixedDataBlockIndex;
                        if (result != 0) break;
                        result = this.m_fixedDataOffset - item.m_fixedDataOffset;
                        break;
                    }
                    case VAR_DATA: {
                        result = this.m_varDataKey - item.m_varDataKey;
                        break;
                    }
                }
            }
            return result;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("[FieldItem type=");
            buffer.append((Object)this.m_type.getFieldTypeClass());
            buffer.append('.');
            buffer.append(this.m_type);
            buffer.append(" location=");
            buffer.append((Object)this.m_location);
            switch (this.m_location) {
                case FIXED_DATA: {
                    buffer.append(" fixedDataBlockIndex=");
                    buffer.append(this.m_fixedDataBlockIndex);
                    buffer.append(" fixedDataBlockOffset=");
                    buffer.append(this.m_fixedDataOffset);
                    break;
                }
                case VAR_DATA: {
                    buffer.append(" varDataKey=");
                    buffer.append(this.m_varDataKey);
                    break;
                }
                case META_DATA: {
                    buffer.append(" mask=");
                    buffer.append(Long.toHexString(this.m_mask));
                    buffer.append(" block=");
                    buffer.append(this.m_metaBlock);
                    break;
                }
            }
            buffer.append("]");
            return buffer.toString();
        }
    }

    static enum FieldLocation {
        FIXED_DATA,
        VAR_DATA,
        META_DATA,
        UNKNOWN;

    }
}

