/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.common.ByteArrayHelper;
import net.sf.mpxj.mpp.FixDeferFix;
import net.sf.mpxj.mpp.MPPUtility;

final class ExtendedData {
    private FixDeferFix m_data;
    private HashMap<Integer, byte[]> m_map = new HashMap();

    ExtendedData(FixDeferFix varData, int offset) {
        this.m_data = varData;
        byte[] data = varData.getByteArray(offset);
        if (data != null) {
            int size;
            for (int index = 0; index < data.length; index += size) {
                size = MPPUtility.getInt(data, index);
                int type = MPPUtility.getInt(data, index += 4);
                this.m_map.put(type, MPPUtility.cloneSubArray(data, index += 4, size));
            }
        }
    }

    public String getString(Integer type) {
        String result = null;
        byte[] item = this.m_map.get(type);
        if (item != null) {
            result = this.m_data.getString(this.getOffset(item));
        }
        return result;
    }

    public String getUnicodeString(Integer type) {
        String result = null;
        byte[] item = this.m_map.get(type);
        if (item != null) {
            result = this.m_data.getUnicodeString(this.getOffset(item));
        }
        return result;
    }

    public int getShort(Integer type) {
        int result = 0;
        byte[] item = this.m_map.get(type);
        if (item != null) {
            result = MPPUtility.getShort(item, 0);
        }
        return result;
    }

    public int getInt(Integer type) {
        int result = 0;
        byte[] item = this.m_map.get(type);
        if (item != null) {
            result = MPPUtility.getInt(item, 0);
        }
        return result;
    }

    public long getLong(Integer type) {
        long result = 0L;
        byte[] item = this.m_map.get(type);
        if (item != null) {
            result = MPPUtility.getLong6(item, 0);
        }
        return result;
    }

    public double getDouble(Integer type) {
        double result = 0.0;
        byte[] item = this.m_map.get(type);
        if (item != null) {
            result = MPPUtility.getDouble(item, 0);
        }
        return result;
    }

    public Date getTimestamp(Integer type) {
        Date result = null;
        byte[] item = this.m_map.get(type);
        if (item != null) {
            result = MPPUtility.getTimestamp(item, 0);
        }
        return result;
    }

    public byte[] getByteArray(Integer type) {
        return this.m_map.get(type);
    }

    private int getOffset(byte[] data) {
        return -1 - MPPUtility.getInt(data, 0);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN ExtendedData");
        for (Map.Entry<Integer, byte[]> entry : this.m_map.entrySet()) {
            pw.println("Type: " + entry.getKey() + " Data:" + ByteArrayHelper.hexdump(entry.getValue(), false));
        }
        pw.println("END ExtendedData");
        pw.println();
        pw.close();
        return sw.toString();
    }
}

