/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

final class EncryptedDocumentInputStream
extends InputStream {
    private final DocumentInputStream m_dis;
    private final int m_mask;

    public EncryptedDocumentInputStream(DocumentEntry entry, int mask) throws IOException {
        this.m_dis = new DocumentInputStream(entry);
        this.m_mask = mask;
    }

    @Override
    public int read() throws IOException {
        int value = this.m_dis.read();
        return value ^= this.m_mask;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int result = this.m_dis.read(b2, off, len);
        for (int loop = 0; loop < len; ++loop) {
            int n2 = loop + off;
            b2[n2] = (byte)(b2[n2] ^ this.m_mask);
        }
        return result;
    }

    @Override
    public int available() {
        return this.m_dis.available();
    }

    @Override
    public void close() {
        this.m_dis.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.m_dis.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.m_dis.markSupported();
    }

    @Override
    public synchronized void reset() {
        this.m_dis.reset();
    }

    @Override
    public long skip(long n2) throws IOException {
        return this.m_dis.skip(n2);
    }
}

