/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.DataLink;
import net.sf.mpxj.DataLinkContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props14;
import net.sf.mpxj.mpp.Var2Data;

class DataLinkFactory {
    private static final Integer PROPS = 6;
    private static final Integer PROPS9 = 1;
    private static final Integer FIELD_TYPE = 641728535;
    private static final Integer VIEW_NAME = 641728536;
    private static final Integer UNIQUE_ID = 641728548;
    private static final Integer PATH = 641728561;
    private final ProjectFile m_project;
    private final FixedData m_fixedData;
    private final Var2Data m_varData;

    public DataLinkFactory(ProjectFile project, FixedData fixedData, Var2Data varData) {
        this.m_project = project;
        this.m_fixedData = fixedData;
        this.m_varData = varData;
    }

    public void process() throws IOException {
        Integer key = this.m_project.getProjectProperties().getMppFileType() == 9 ? PROPS9 : PROPS;
        HashMap<String, DataLink> map = new HashMap<String, DataLink>();
        int itemCount = this.m_fixedData.getItemCount();
        for (int index = 0; index < itemCount; ++index) {
            int id2;
            byte[] propsData;
            byte[] data = this.m_fixedData.getByteArrayValue(index);
            if (data == null || (data[112] & 0x20) != 0 || (propsData = this.m_varData.getByteArray(id2 = MPPUtility.getInt(data, 0), key)) == null) continue;
            this.process(propsData, map);
        }
        DataLinkContainer container = this.m_project.getDataLinks();
        for (DataLink dataLink : map.values()) {
            container.add(dataLink);
        }
    }

    private void process(byte[] data, Map<String, DataLink> map) throws IOException {
        Props14 props = new Props14(new ByteArrayInputStream(data));
        String dataLinkID = props.getUnicodeString(PATH);
        DataLink dataLink = map.get(dataLinkID);
        if (dataLink == null) {
            dataLink = new DataLink(dataLinkID);
            map.put(dataLinkID, dataLink);
        }
        Integer rowUniqueID = props.getInt(UNIQUE_ID);
        FieldType fieldType = FieldTypeHelper.getInstance14(props.getInt(FIELD_TYPE));
        if (props.getUnicodeString(VIEW_NAME) == null) {
            dataLink.setTargetField(fieldType);
            dataLink.setTargetUniqueID(rowUniqueID);
        } else {
            dataLink.setSourceField(fieldType);
            dataLink.setSourceUniqueID(rowUniqueID);
        }
    }
}

