/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.CustomFieldLookupTable;
import net.sf.mpxj.CustomFieldValueDataType;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.CustomFieldValueReader;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;

public class CustomFieldValueReader12
extends CustomFieldValueReader {
    public CustomFieldValueReader12(ProjectProperties properties, CustomFieldContainer container, VarMeta outlineCodeVarMeta, Var2Data outlineCodeVarData, FixedData outlineCodeFixedData, FixedData outlineCodeFixedData2, Props taskProps) {
        super(properties, container, outlineCodeVarMeta, outlineCodeVarData, outlineCodeFixedData, outlineCodeFixedData2, taskProps);
    }

    @Override
    public void process() {
        Integer[] uniqueid = this.m_outlineCodeVarMeta.getUniqueIdentifierArray();
        Map<UUID, FieldType> map = this.populateCustomFieldMap();
        for (int loop = 0; loop < uniqueid.length; ++loop) {
            Integer id2 = uniqueid[loop];
            CustomFieldValueItem item = new CustomFieldValueItem(id2);
            byte[] value = this.m_outlineCodeVarData.getByteArray(id2, VALUE_LIST_VALUE);
            item.setDescription(this.m_outlineCodeVarData.getUnicodeString(id2, VALUE_LIST_DESCRIPTION));
            item.setUnknown(this.m_outlineCodeVarData.getByteArray(id2, VALUE_LIST_UNKNOWN));
            byte[] b2 = this.m_outlineCodeFixedData.getByteArrayValue(loop + 3);
            if (b2 != null) {
                item.setParent(MPPUtility.getShort(b2, 8));
            }
            byte[] b22 = this.m_outlineCodeFixedData2.getByteArrayValue(loop + 3);
            item.setGUID(MPPUtility.getGUID(b22, 0));
            UUID lookupTableGuid = MPPUtility.getGUID(b22, 32);
            item.setType(CustomFieldValueDataType.getInstance(MPPUtility.getShort(b22, 48)));
            item.setValue(this.getTypedValue(item.getType(), value));
            this.m_container.registerValue(item);
            FieldType field = map.get(lookupTableGuid);
            if (field == null) continue;
            CustomFieldLookupTable table = this.m_container.getCustomField(field).getLookupTable();
            table.add(item);
            table.setGUID(lookupTableGuid);
        }
    }

    private Map<UUID, FieldType> populateCustomFieldMap() {
        int blockLength;
        byte[] data = this.m_taskProps.getByteArray(Props.CUSTOM_FIELDS);
        int length = MPPUtility.getInt(data, 0);
        int index = length + 36;
        int recordCount = MPPUtility.getInt(data, index);
        index += 4;
        index += 8 * recordCount;
        HashMap<UUID, FieldType> map = new HashMap<UUID, FieldType>();
        while (index < data.length && (blockLength = MPPUtility.getInt(data, index)) > 0 && index + blockLength <= data.length) {
            int extendedAttributeFieldID = MPPUtility.getInt(data, index + 4);
            FieldType field = FieldTypeHelper.getInstance(extendedAttributeFieldID);
            UUID lookupTableGuid = MPPUtility.getGUID(data, index + 160);
            map.put(lookupTableGuid, field);
            index += blockLength;
        }
        return map;
    }
}

