/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import java.awt.GridLayout;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import net.sf.mpxj.explorer.MpxjTreeNode;
import net.sf.mpxj.explorer.ObjectPropertiesPanel;
import net.sf.mpxj.explorer.ProjectTreeController;
import net.sf.mpxj.explorer.ProjectTreeModel;
import net.sf.mpxj.explorer.ProjectTreeView;

public class ProjectFilePanel
extends JPanel {
    private final ProjectTreeModel m_treeModel = new ProjectTreeModel();
    private final ProjectTreeController m_treeController = new ProjectTreeController(this.m_treeModel);
    private final ProjectTreeView m_treeView;
    final Map<MpxjTreeNode, ObjectPropertiesPanel> m_openTabs;

    public ProjectFilePanel(File file) {
        this.setLayout(new GridLayout(0, 1, 0, 0));
        this.m_treeView = new ProjectTreeView(this.m_treeModel);
        this.m_treeView.setShowsRootHandles(true);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setDividerLocation(0.3);
        this.add(splitPane);
        JScrollPane scrollPane = new JScrollPane(this.m_treeView);
        splitPane.setLeftComponent(scrollPane);
        final JTabbedPane tabbedPane = new JTabbedPane(1);
        splitPane.setRightComponent(tabbedPane);
        this.m_openTabs = new HashMap<MpxjTreeNode, ObjectPropertiesPanel>();
        this.m_treeView.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e2) {
                TreePath path = e2.getPath();
                MpxjTreeNode component = (MpxjTreeNode)path.getLastPathComponent();
                if (!(component.getUserObject() instanceof String)) {
                    ObjectPropertiesPanel panel = ProjectFilePanel.this.m_openTabs.get(component);
                    if (panel == null) {
                        panel = new ObjectPropertiesPanel(component.getUserObject(), component.getExcludedMethods());
                        tabbedPane.add(component.toString(), panel);
                        ProjectFilePanel.this.m_openTabs.put(component, panel);
                    }
                    tabbedPane.setSelectedComponent(panel);
                }
            }
        });
        this.m_treeController.loadFile(file);
    }

    public void saveFile(File file, String type) {
        if (file != null) {
            this.m_treeController.saveFile(file, type);
        }
    }
}

