/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import com.jgoodies.binding.beans.PropertyAdapter;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import net.sf.mpxj.explorer.FileChooserController;
import net.sf.mpxj.explorer.FileChooserModel;
import net.sf.mpxj.explorer.FileChooserView;
import net.sf.mpxj.explorer.FileSaverController;
import net.sf.mpxj.explorer.FileSaverModel;
import net.sf.mpxj.explorer.FileSaverView;
import net.sf.mpxj.explorer.ProjectFilePanel;

public class ProjectExplorer {
    protected JFrame m_frame;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    ProjectExplorer window = new ProjectExplorer();
                    window.m_frame.setVisible(true);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        });
    }

    public ProjectExplorer() {
        this.initialize();
    }

    private void initialize() {
        this.m_frame = new JFrame();
        this.m_frame.setBounds(100, 100, 900, 451);
        this.m_frame.setDefaultCloseOperation(3);
        this.m_frame.getContentPane().setLayout(new GridLayout(1, 0, 0, 0));
        final FileChooserModel fileChooserModel = new FileChooserModel();
        final FileChooserController fileChooserController = new FileChooserController(fileChooserModel);
        FileChooserView fileChooserView = new FileChooserView(this.m_frame, fileChooserModel);
        fileChooserModel.setExtensions("cdpx", "cdpz", "exe", "fts", "gan", "gnt", "mdb", "mpd", "mpp", "mpx", "pep", "planner", "pmxml", "pod", "pp", "ppx", "prx", "schedule_grid", "sdef", "sp", "stx", "xer", "xml", "zip");
        final FileSaverModel fileSaverModel = new FileSaverModel();
        final FileSaverController fileSaverController = new FileSaverController(fileSaverModel);
        FileSaverView fileSaverView = new FileSaverView(this.m_frame, fileSaverModel);
        fileSaverModel.setExtensions("sdef", "sdef", "mpx", "mpx", "planner", "xml", "pmxml", "xml", "json", "json", "mspdi", "xml");
        JMenuBar menuBar = new JMenuBar();
        this.m_frame.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        menuBar.add(mnFile);
        JMenuItem mntmOpen = new JMenuItem("Open File...");
        mnFile.add(mntmOpen);
        final JMenuItem mntmSave = new JMenuItem("Save As...");
        mntmSave.setEnabled(false);
        mnFile.add(mntmSave);
        mntmOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                fileChooserController.openFileChooser();
            }
        });
        mntmSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                fileSaverController.openFileSaver();
            }
        });
        final JTabbedPane tabbedPane = new JTabbedPane(1);
        this.m_frame.getContentPane().add(tabbedPane);
        PropertyAdapter<FileChooserModel> openAdapter = new PropertyAdapter<FileChooserModel>(fileChooserModel, "file", true);
        openAdapter.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                File file = fileChooserModel.getFile();
                tabbedPane.add(file.getName(), new ProjectFilePanel(file));
                mntmSave.setEnabled(true);
            }
        });
        PropertyAdapter<FileSaverModel> saveAdapter = new PropertyAdapter<FileSaverModel>(fileSaverModel, "file", true);
        saveAdapter.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProjectFilePanel panel = (ProjectFilePanel)tabbedPane.getSelectedComponent();
                panel.saveFile(fileSaverModel.getFile(), fileSaverModel.getType());
            }
        });
    }
}

