/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class PoiTreeModel
implements TreeModel {
    private final EventListenerList m_listenerList = new EventListenerList();
    private POIFSFileSystem m_file;

    public void setFile(POIFSFileSystem file) {
        this.m_file = file;
        this.fireTreeStructureChanged();
    }

    @Override
    public Object getRoot() {
        DirectoryNode result = null;
        if (this.m_file != null) {
            result = this.m_file.getRoot();
        }
        return result;
    }

    @Override
    public Object getChild(Object parent, int index) {
        List<Entry> entries;
        Entry result = null;
        if (parent instanceof DirectoryEntry && (entries = this.getChildNodes((DirectoryEntry)parent)).size() > index) {
            result = entries.get(index);
        }
        return result;
    }

    @Override
    public int getChildCount(Object parent) {
        int result;
        if (parent instanceof DirectoryEntry) {
            DirectoryEntry node = (DirectoryEntry)parent;
            result = node.getEntryCount();
        } else {
            result = 0;
        }
        return result;
    }

    @Override
    public boolean isLeaf(Object node) {
        return !(node instanceof DirectoryEntry);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int result = -1;
        if (parent instanceof DirectoryEntry) {
            List<Entry> entries = this.getChildNodes((DirectoryEntry)parent);
            result = entries.indexOf(child);
        }
        return result;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l2) {
        this.m_listenerList.add(TreeModelListener.class, l2);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l2) {
        this.m_listenerList.remove(TreeModelListener.class, l2);
    }

    private List<Entry> getChildNodes(DirectoryEntry parent) {
        ArrayList<Entry> result = new ArrayList<Entry>();
        Iterator<Entry> entries = parent.getEntries();
        while (entries.hasNext()) {
            result.add(entries.next());
        }
        return result;
    }

    private void fireTreeStructureChanged() {
        Object[] listeners = this.m_listenerList.getListenerList();
        TreeModelEvent e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != TreeModelListener.class) continue;
            if (e2 == null) {
                e2 = new TreeModelEvent(this.getRoot(), new Object[]{this.getRoot()}, null, null);
            }
            ((TreeModelListener)listeners[i2 + 1]).treeStructureChanged(e2);
        }
    }
}

