/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import java.awt.GridLayout;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import net.sf.mpxj.explorer.HexDumpController;
import net.sf.mpxj.explorer.HexDumpModel;
import net.sf.mpxj.explorer.HexDumpView;
import net.sf.mpxj.explorer.PoiTreeController;
import net.sf.mpxj.explorer.PoiTreeModel;
import net.sf.mpxj.explorer.PoiTreeView;
import org.apache.poi.poifs.filesystem.DocumentEntry;

public class MppFilePanel
extends JPanel {
    private PoiTreeModel m_treeModel = new PoiTreeModel();
    private PoiTreeController m_treeController = new PoiTreeController(this.m_treeModel);
    private PoiTreeView m_treeView = new PoiTreeView(this.m_treeModel);
    private HexDumpModel m_hexDumpModel;
    protected HexDumpController m_hexDumpController;
    private HexDumpView m_hexDumpView;

    public MppFilePanel(File file) {
        this.m_treeView.setShowsRootHandles(true);
        this.m_hexDumpModel = new HexDumpModel();
        this.m_hexDumpController = new HexDumpController(this.m_hexDumpModel);
        this.setLayout(new GridLayout(0, 1, 0, 0));
        this.m_hexDumpView = new HexDumpView(this.m_hexDumpModel);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setDividerLocation(0.3);
        this.add(splitPane);
        JScrollPane scrollPane = new JScrollPane(this.m_treeView);
        splitPane.setLeftComponent(scrollPane);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        splitPane.setRightComponent(tabbedPane);
        tabbedPane.add("Hex Dump", this.m_hexDumpView);
        this.m_treeView.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e2) {
                TreePath path = e2.getPath();
                Object component = path.getLastPathComponent();
                if (component instanceof DocumentEntry) {
                    MppFilePanel.this.m_hexDumpController.viewDocument((DocumentEntry)component);
                }
            }
        });
        this.m_treeController.loadFile(file);
    }
}

