/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.BeanAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ValueModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.text.NumberFormatter;
import net.sf.mpxj.explorer.HexDumpModel;
import net.sf.mpxj.explorer.JLabelledValue;
import net.sf.mpxj.explorer.JTablePanel;

public class HexDumpView
extends JPanel {
    public HexDumpView(HexDumpModel model) {
        NumberFormatter integerFormat = new NumberFormatter(NumberFormat.getIntegerInstance());
        integerFormat.setValueClass(Integer.class);
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        JPanel controlsPanel = new JPanel();
        springLayout.putConstraint("North", (Component)controlsPanel, 0, "North", (Component)this);
        springLayout.putConstraint("West", (Component)controlsPanel, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)controlsPanel, 0, "East", (Component)this);
        FlowLayout flowLayout = (FlowLayout)controlsPanel.getLayout();
        flowLayout.setAlignment(0);
        this.add(controlsPanel);
        JLabel columnsLabel = new JLabel("Columns");
        controlsPanel.add(columnsLabel);
        JFormattedTextField columns = new JFormattedTextField(integerFormat);
        controlsPanel.add(columns);
        columns.setBorder(new LineBorder(new Color(171, 173, 179)));
        columns.setColumns(10);
        JLabel offsetLabel = new JLabel("Offset");
        controlsPanel.add(offsetLabel);
        JFormattedTextField offset = new JFormattedTextField(integerFormat);
        controlsPanel.add(offset);
        offset.setBorder(new LineBorder(new Color(171, 173, 179)));
        offset.setColumns(10);
        JTablePanel tablePanel = new JTablePanel();
        JPanel infoPanel = new JPanel();
        FlowLayout infoPanelLayout = new FlowLayout(0, 5, 5);
        infoPanel.setLayout(infoPanelLayout);
        infoPanel.setBorder(null);
        JPanel infoPanelSelection = new JPanel();
        infoPanel.add(infoPanelSelection);
        infoPanelSelection.setLayout(new BoxLayout(infoPanelSelection, 1));
        JLabelledValue sizeValueLabel = new JLabelledValue("Size:");
        infoPanelSelection.add(sizeValueLabel);
        JLabelledValue currentSelectionValueLabel = new JLabelledValue("Current Selection:");
        infoPanelSelection.add(currentSelectionValueLabel);
        JLabelledValue previousSelectionValueLabel = new JLabelledValue("Previous Selection:");
        infoPanelSelection.add(previousSelectionValueLabel);
        JLabelledValue differenceValueLabel = new JLabelledValue("Difference:");
        infoPanelSelection.add(differenceValueLabel);
        JPanel infoPanelNumeric = new JPanel();
        infoPanel.add(infoPanelNumeric);
        infoPanelNumeric.setLayout(new BoxLayout(infoPanelNumeric, 1));
        JLabelledValue shortValueLabel = new JLabelledValue("Short:");
        infoPanelNumeric.add(shortValueLabel);
        JLabelledValue longSixValueLabel = new JLabelledValue("Long6:");
        infoPanelNumeric.add(longSixValueLabel);
        JLabelledValue longValueLabel = new JLabelledValue("Long:");
        infoPanelNumeric.add(longValueLabel);
        JLabelledValue doubleValueLabel = new JLabelledValue("Double:");
        infoPanelNumeric.add(doubleValueLabel);
        JPanel infoPanelDuration = new JPanel();
        infoPanel.add(infoPanelDuration);
        infoPanelDuration.setLayout(new BoxLayout(infoPanelDuration, 1));
        JLabelledValue durationValueLabel = new JLabelledValue("Duration:");
        infoPanelDuration.add(durationValueLabel);
        JLabelledValue timeUnitsValueLabel = new JLabelledValue("TmeUnit:");
        infoPanelDuration.add(timeUnitsValueLabel);
        JLabelledValue workUnitsValueLabel = new JLabelledValue("Work Units:");
        infoPanelDuration.add(workUnitsValueLabel);
        JPanel infoPanelDate = new JPanel();
        infoPanel.add(infoPanelDate);
        infoPanelDate.setLayout(new BoxLayout(infoPanelDate, 1));
        JLabelledValue dateValueLabel = new JLabelledValue("Date:");
        infoPanelDate.add(dateValueLabel);
        JLabelledValue timeValueLabel = new JLabelledValue("Time:");
        infoPanelDate.add(timeValueLabel);
        JLabelledValue timestampValueLabel = new JLabelledValue("Timestamp:");
        infoPanelDate.add(timestampValueLabel);
        JPanel infoPanelMisc = new JPanel();
        infoPanel.add(infoPanelMisc);
        infoPanelMisc.setLayout(new BoxLayout(infoPanelMisc, 1));
        JLabelledValue guidValueLabel = new JLabelledValue("GUID:");
        infoPanelMisc.add(guidValueLabel);
        JLabelledValue percentageValueLabel = new JLabelledValue("Percentage:");
        infoPanelMisc.add(percentageValueLabel);
        final JSplitPane splitPane = new JSplitPane(0);
        springLayout.putConstraint("North", (Component)splitPane, 0, "South", (Component)controlsPanel);
        springLayout.putConstraint("West", (Component)splitPane, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)splitPane, 0, "South", (Component)this);
        springLayout.putConstraint("East", (Component)splitPane, 0, "East", (Component)this);
        this.add(splitPane);
        splitPane.setLeftComponent(tablePanel);
        splitPane.setRightComponent(infoPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                splitPane.setDividerLocation(0.85);
                splitPane.setResizeWeight(0.85);
            }
        });
        BeanAdapter<HexDumpModel> modelAdapter = new BeanAdapter<HexDumpModel>(model, true);
        Bindings.bind(columns, (ValueModel)modelAdapter.getValueModel("columns"));
        Bindings.bind(offset, (ValueModel)modelAdapter.getValueModel("offset"));
        Bindings.bind(sizeValueLabel, "value", modelAdapter.getValueModel("sizeValueLabel"));
        Bindings.bind(currentSelectionValueLabel, "value", modelAdapter.getValueModel("currentSelectionValueLabel"));
        Bindings.bind(previousSelectionValueLabel, "value", modelAdapter.getValueModel("previousSelectionValueLabel"));
        Bindings.bind(differenceValueLabel, "value", modelAdapter.getValueModel("selectionDifferenceValueLabel"));
        Bindings.bind(shortValueLabel, "value", modelAdapter.getValueModel("shortValueLabel"));
        Bindings.bind(longSixValueLabel, "value", modelAdapter.getValueModel("longSixValueLabel"));
        Bindings.bind(longValueLabel, "value", modelAdapter.getValueModel("longValueLabel"));
        Bindings.bind(doubleValueLabel, "value", modelAdapter.getValueModel("doubleValueLabel"));
        Bindings.bind(durationValueLabel, "value", modelAdapter.getValueModel("durationValueLabel"));
        Bindings.bind(timeUnitsValueLabel, "value", modelAdapter.getValueModel("timeUnitsValueLabel"));
        Bindings.bind(guidValueLabel, "value", modelAdapter.getValueModel("guidValueLabel"));
        Bindings.bind(percentageValueLabel, "value", modelAdapter.getValueModel("percentageValueLabel"));
        Bindings.bind(dateValueLabel, "value", modelAdapter.getValueModel("dateValueLabel"));
        Bindings.bind(timeValueLabel, "value", modelAdapter.getValueModel("timeValueLabel"));
        Bindings.bind(timestampValueLabel, "value", modelAdapter.getValueModel("timestampValueLabel"));
        Bindings.bind(workUnitsValueLabel, "value", modelAdapter.getValueModel("workUnitsValueLabel"));
        PropertyConnector.connect(tablePanel, "leftTableModel", model, "hexTableModel");
        PropertyConnector.connect(tablePanel, "rightTableModel", model, "asciiTableModel");
        PropertyConnector.connect(tablePanel, "selectedCell", model, "selectedCell");
    }
}

