/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.util.ArrayDeque;
import java.util.Calendar;
import java.util.Date;
import java.util.Deque;
import java.util.TimeZone;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;

public final class DateHelper {
    public static final Date FIRST_DATE = DateHelper.getTimestampFromLong(441763200000L);
    public static final Date LAST_DATE = DateHelper.getTimestampFromLong(2524607946000L);
    public static final long MS_PER_MINUTE = 60000L;
    public static final long MS_PER_HOUR = 3600000L;
    public static final long MS_PER_DAY = 86400000L;
    private static final int DEFAULT_DST_SAVINGS = 3600000;
    private static boolean HAS_DST_SAVINGS;
    private static final ThreadLocal<Deque<Calendar>> CALENDARS;

    private DateHelper() {
    }

    public static Date getDayStartDate(Date date) {
        if (date != null) {
            Calendar cal = DateHelper.popCalendar(date);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            date = cal.getTime();
            DateHelper.pushCalendar(cal);
        }
        return date;
    }

    public static Date getDayEndDate(Date date) {
        if (date != null) {
            Calendar cal = DateHelper.popCalendar(date);
            cal.set(14, 999);
            cal.set(13, 59);
            cal.set(12, 59);
            cal.set(11, 23);
            date = cal.getTime();
            DateHelper.pushCalendar(cal);
        }
        return date;
    }

    public static Date getCanonicalTime(Date date) {
        if (date != null) {
            Calendar cal = DateHelper.popCalendar(date);
            cal.set(6, 1);
            cal.set(1, 1);
            cal.set(14, 0);
            date = cal.getTime();
            DateHelper.pushCalendar(cal);
        }
        return date;
    }

    public static int compare(Date startDate, Date endDate, Date targetDate) {
        return DateHelper.compare(startDate, endDate, targetDate.getTime());
    }

    public static int compare(Date startDate, Date endDate, long targetDate) {
        int result = 0;
        if (targetDate < startDate.getTime()) {
            result = -1;
        } else if (targetDate > endDate.getTime()) {
            result = 1;
        }
        return result;
    }

    public static int compare(Date d1, Date d2) {
        long diff;
        int result = d1 == null || d2 == null ? (d1 == d2 ? 0 : (d1 == null ? 1 : -1)) : ((diff = d1.getTime() - d2.getTime()) == 0L ? 0 : (diff > 0L ? 1 : -1));
        return result;
    }

    public static Date min(Date d1, Date d2) {
        Date result = d1 == null ? d2 : (d2 == null ? d1 : (d1.compareTo(d2) < 0 ? d1 : d2));
        return result;
    }

    public static Date max(Date d1, Date d2) {
        Date result = d1 == null ? d2 : (d2 == null ? d1 : (d1.compareTo(d2) > 0 ? d1 : d2));
        return result;
    }

    public static Duration getVariance(Task task, Date date1, Date date2, TimeUnit format) {
        ProjectCalendar calendar;
        Duration variance = null;
        if (date1 != null && date2 != null && (calendar = task.getEffectiveCalendar()) != null) {
            variance = calendar.getWork(date1, date2, format);
        }
        if (variance == null) {
            variance = Duration.getInstance(0, format);
        }
        return variance;
    }

    public static Date getDateFromLong(long date) {
        TimeZone tz = TimeZone.getDefault();
        return new Date(date - (long)tz.getRawOffset());
    }

    public static Date getTimestampFromLong(long timestamp) {
        Date result;
        TimeZone tz = TimeZone.getDefault();
        if (tz.inDaylightTime(result = new Date(timestamp - (long)tz.getRawOffset()))) {
            int savings = HAS_DST_SAVINGS ? tz.getDSTSavings() : 3600000;
            result = new Date(result.getTime() - (long)savings);
        }
        return result;
    }

    public static long getLongFromTimestamp(Date date) {
        TimeZone tz = TimeZone.getDefault();
        long result = date.getTime();
        if (tz.inDaylightTime(date)) {
            int savings = HAS_DST_SAVINGS ? tz.getDSTSavings() : 3600000;
            result += (long)savings;
        }
        return result;
    }

    public static Date getTime(int hour, int minutes) {
        Calendar cal = DateHelper.popCalendar();
        cal.set(11, hour);
        cal.set(12, minutes);
        cal.set(13, 0);
        Date result = cal.getTime();
        DateHelper.pushCalendar(cal);
        return result;
    }

    public static void setTime(Calendar cal, Date time) {
        if (time != null) {
            Calendar startCalendar = DateHelper.popCalendar(time);
            cal.set(11, startCalendar.get(11));
            cal.set(12, startCalendar.get(12));
            cal.set(13, startCalendar.get(13));
            DateHelper.pushCalendar(startCalendar);
        }
    }

    public static Date setTime(Date date, Date canonicalTime) {
        Date result;
        if (canonicalTime == null) {
            result = date;
        } else {
            Calendar cal = DateHelper.popCalendar(canonicalTime);
            int dayOffset = cal.get(6) - 1;
            int hourOfDay = cal.get(11);
            int minute = cal.get(12);
            int second = cal.get(13);
            int millisecond = cal.get(14);
            cal.setTime(date);
            if (dayOffset != 0) {
                cal.add(6, dayOffset);
            }
            cal.set(14, millisecond);
            cal.set(13, second);
            cal.set(12, minute);
            cal.set(11, hourOfDay);
            result = cal.getTime();
            DateHelper.pushCalendar(cal);
        }
        return result;
    }

    public static Date getTimeFromMinutesPastMidnight(Integer time) {
        Date result = null;
        if (time != null) {
            int minutes = time;
            int hours = minutes / 60;
            minutes -= hours * 60;
            Calendar cal = DateHelper.popCalendar();
            cal.set(6, 1);
            cal.set(1, 1);
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, minutes);
            cal.set(11, hours);
            result = cal.getTime();
            DateHelper.pushCalendar(cal);
        }
        return result;
    }

    public static Date addDays(Date date, int days) {
        Calendar cal = DateHelper.popCalendar(date);
        cal.add(6, days);
        Date result = cal.getTime();
        DateHelper.pushCalendar(cal);
        return result;
    }

    public static Calendar popCalendar() {
        Deque<Calendar> calendars = CALENDARS.get();
        Calendar result = calendars.isEmpty() ? Calendar.getInstance() : calendars.pop();
        return result;
    }

    public static Calendar popCalendar(Date date) {
        Calendar calendar = DateHelper.popCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar popCalendar(long timeInMillis) {
        Calendar calendar = DateHelper.popCalendar();
        calendar.setTimeInMillis(timeInMillis);
        return calendar;
    }

    public static void pushCalendar(Calendar cal) {
        CALENDARS.get().push(cal);
    }

    static {
        CALENDARS = new ThreadLocal<Deque<Calendar>>(){

            @Override
            protected Deque<Calendar> initialValue() {
                return new ArrayDeque<Calendar>();
            }
        };
        Class<TimeZone> tz = TimeZone.class;
        try {
            tz.getMethod("getDSTSavings", null);
            HAS_DST_SAVINGS = true;
        }
        catch (NoSuchMethodException ex) {
            HAS_DST_SAVINGS = false;
        }
    }
}

