/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.text.DecimalFormat;

public final class ByteArrayHelper {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final String hexdump(byte[] buffer, int offset, int length, boolean ascii) {
        StringBuilder sb2 = new StringBuilder();
        if (buffer != null) {
            int loop;
            int count = offset + length;
            for (loop = offset; loop < count; ++loop) {
                sb2.append(" ");
                sb2.append(HEX_DIGITS[(buffer[loop] & 0xF0) >> 4]);
                sb2.append(HEX_DIGITS[buffer[loop] & 0xF]);
            }
            if (ascii) {
                sb2.append("   ");
                for (loop = offset; loop < count; ++loop) {
                    char c2 = (char)buffer[loop];
                    if (c2 > '\u00c8' || c2 < '\u001b') {
                        c2 = ' ';
                    }
                    sb2.append(c2);
                }
            }
        }
        return sb2.toString();
    }

    public static final String hexdump(byte[] buffer, boolean ascii) {
        int length = 0;
        if (buffer != null) {
            length = buffer.length;
        }
        return ByteArrayHelper.hexdump(buffer, 0, length, ascii);
    }

    public static final String hexdump(byte[] buffer, boolean ascii, int columns, String prefix) {
        StringBuilder sb2 = new StringBuilder();
        if (buffer != null) {
            DecimalFormat df = new DecimalFormat("00000");
            for (int index = 0; index < buffer.length; index += columns) {
                if (index + columns > buffer.length) {
                    columns = buffer.length - index;
                }
                sb2.append(prefix);
                sb2.append(df.format(index));
                sb2.append(":");
                sb2.append(ByteArrayHelper.hexdump(buffer, index, columns, ascii));
                sb2.append('\n');
            }
        }
        return sb2.toString();
    }

    public static final String hexdump(byte[] buffer, int offset, int length, boolean ascii, int columns, String prefix) {
        StringBuilder sb2 = new StringBuilder();
        if (buffer != null) {
            DecimalFormat df = new DecimalFormat("00000");
            for (int index = offset; index < offset + length; index += columns) {
                if (index + columns > offset + length) {
                    columns = offset + length - index;
                }
                sb2.append(prefix);
                sb2.append(df.format(index - offset));
                sb2.append(":");
                sb2.append(ByteArrayHelper.hexdump(buffer, index, columns, ascii));
                sb2.append('\n');
            }
        }
        return sb2.toString();
    }
}

