/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import net.sf.mpxj.DayType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.asta.AstaReader;
import net.sf.mpxj.asta.MpdResultSetRow;
import net.sf.mpxj.asta.Row;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.reader.ProjectReader;

public final class AstaDatabaseReader
implements ProjectReader {
    private AstaReader m_reader;
    private Integer m_projectID;
    private String m_schema = "";
    private DataSource m_dataSource;
    private Connection m_connection;
    private boolean m_allocatedConnection;
    private PreparedStatement m_ps;
    private ResultSet m_rs;
    private Map<String, Integer> m_meta = new HashMap<String, Integer>();
    private List<ProjectListener> m_projectListeners;

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    public Map<Integer, String> listProjects() throws MPXJException {
        try {
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            List<Row> rows = this.getRows("select projid, short_name from project_summary");
            for (Row row : rows) {
                Integer id2 = row.getInteger("projid");
                String name = row.getString("short_name");
                result.put(id2, name);
            }
            return result;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    public ProjectFile read() throws MPXJException {
        try {
            this.m_reader = new AstaReader();
            ProjectFile project = this.m_reader.getProject();
            project.getEventManager().addProjectListeners(this.m_projectListeners);
            this.processProjectProperties();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.m_reader = null;
            ProjectFile projectFile = project;
            return projectFile;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            if (this.m_allocatedConnection && this.m_connection != null) {
                try {
                    this.m_connection.close();
                }
                catch (SQLException sQLException) {}
                this.m_connection = null;
            }
        }
    }

    private void processProjectProperties() throws SQLException {
        List<Row> projectSummaryRows = this.getRows("select * from project_summary where projid=?", this.m_projectID);
        List<Row> progressPeriodRows = this.getRows("select * from progress_period where projid=?", this.m_projectID);
        Row projectSummary = projectSummaryRows.isEmpty() ? null : projectSummaryRows.get(0);
        List<Row> progressPeriods = progressPeriodRows.isEmpty() ? null : progressPeriodRows;
        this.m_reader.processProjectProperties(projectSummary, progressPeriods);
    }

    private void processCalendars() throws SQLException {
        List<Row> rows = this.getRows("select * from exceptionn");
        Map<Integer, DayType> exceptionMap = this.m_reader.createExceptionTypeMap(rows);
        rows = this.getRows("select * from work_pattern");
        Map<Integer, Row> workPatternMap = this.m_reader.createWorkPatternMap(rows);
        rows = this.getRows("select * from work_pattern_assignment");
        Map<Integer, List<Row>> workPatternAssignmentMap = this.m_reader.createWorkPatternAssignmentMap(rows);
        rows = this.getRows("select * from exception_assignment order by exception_assignmentid, ordf");
        Map<Integer, List<Row>> exceptionAssignmentMap = this.m_reader.createExceptionAssignmentMap(rows);
        rows = this.getRows("select * from time_entry order by time_entryid, ordf");
        Map<Integer, List<Row>> timeEntryMap = this.m_reader.createTimeEntryMap(rows);
        rows = this.getRows("select * from calendar where projid=? order by calendarid", this.m_projectID);
        for (Row row : rows) {
            this.m_reader.processCalendar(row, workPatternMap, workPatternAssignmentMap, exceptionAssignmentMap, timeEntryMap, exceptionMap);
        }
        this.m_reader.getProject().getProjectConfig().updateUniqueCounters();
    }

    private void processResources() throws SQLException {
        List<Row> permanentRows = this.getRows("select * from permanent_resource where projid=? order by permanent_resourceid", this.m_projectID);
        List<Row> consumableRows = this.getRows("select * from consumable_resource where projid=? order by consumable_resourceid", this.m_projectID);
        this.m_reader.processResources(permanentRows, consumableRows);
    }

    private void processTasks() throws SQLException {
        List<Row> bars = this.getRows("select * from bar where projid=?", this.m_projectID);
        List<Row> expandedTasks = this.getRows("select * from expanded_task where projid=?", this.m_projectID);
        List<Row> tasks = this.getRows("select * from task where projid=?", this.m_projectID);
        List<Row> milestones = this.getRows("select * from milestone where projid=?", this.m_projectID);
        this.m_reader.processTasks(bars, expandedTasks, tasks, milestones);
    }

    private void processPredecessors() throws SQLException {
        List<Row> rows = this.getRows("select * from link where projid=? order by linkid", this.m_projectID);
        List<Row> completedSections = this.getRows("select * from task_completed_section where projid=?", this.m_projectID);
        this.m_reader.processPredecessors(rows, completedSections);
    }

    private void processAssignments() throws SQLException {
        List<Row> permanentAssignments = this.getRows("select * from permanent_schedul_allocation inner join perm_resource_skill on permanent_schedul_allocation.allocatiop_of = perm_resource_skill.perm_resource_skillid where permanent_schedul_allocation.projid=? order by permanent_schedul_allocation.permanent_schedul_allocationid", this.m_projectID);
        this.m_reader.processAssignments(permanentAssignments);
    }

    public void setProjectID(int projectID) {
        this.m_projectID = projectID;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
    }

    @Override
    public ProjectFile read(String accessDatabaseFileName) throws MPXJException {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String url = "jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb);DBQ=" + accessDatabaseFileName;
            Properties props = new Properties();
            props.put("charSet", "Cp1252");
            this.m_connection = DriverManager.getConnection(url, props);
            this.m_projectID = 0;
            ProjectFile projectFile = this.read();
            return projectFile;
        }
        catch (ClassNotFoundException ex) {
            throw new MPXJException("Failed to load JDBC driver", ex);
        }
        catch (SQLException ex) {
            throw new MPXJException("Failed to create connection", ex);
        }
        finally {
            if (this.m_connection != null) {
                try {
                    this.m_connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        return this.read(file.getAbsolutePath());
    }

    @Override
    public ProjectFile read(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Row> getRows(String sql) throws SQLException {
        this.allocateConnection();
        try {
            LinkedList<Row> result = new LinkedList<Row>();
            this.m_ps = this.m_connection.prepareStatement(sql);
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                result.add(new MpdResultSetRow(this.m_rs, this.m_meta));
            }
            LinkedList<Row> linkedList = result;
            return linkedList;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Row> getRows(String sql, Integer var) throws SQLException {
        this.allocateConnection();
        try {
            LinkedList<Row> result = new LinkedList<Row>();
            this.m_ps = this.m_connection.prepareStatement(sql);
            this.m_ps.setInt(1, NumberHelper.getInt(var));
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                result.add(new MpdResultSetRow(this.m_rs, this.m_meta));
            }
            LinkedList<Row> linkedList = result;
            return linkedList;
        }
        finally {
            this.releaseConnection();
        }
    }

    private void allocateConnection() throws SQLException {
        if (this.m_connection == null) {
            this.m_connection = this.m_dataSource.getConnection();
            this.m_allocatedConnection = true;
        }
    }

    private void releaseConnection() {
        if (this.m_rs != null) {
            try {
                this.m_rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.m_rs = null;
        }
        if (this.m_ps != null) {
            try {
                this.m_ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.m_ps = null;
        }
    }

    private void populateMetaData() throws SQLException {
        this.m_meta.clear();
        ResultSetMetaData meta = this.m_rs.getMetaData();
        int columnCount = meta.getColumnCount() + 1;
        for (int loop = 1; loop < columnCount; ++loop) {
            String name = meta.getColumnName(loop);
            Integer type = meta.getColumnType(loop);
            this.m_meta.put(name, type);
        }
    }

    public void setSchema(String schema) {
        if (schema.charAt(schema.length() - 1) != '.') {
            schema = schema + '.';
        }
        this.m_schema = schema;
    }

    public String getSchema() {
        return this.m_schema;
    }
}

