/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import net.sf.mpxj.Day;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;

public class RecurringData {
    private static final String[] ORDINAL = new String[]{null, "every", "every other", "every 3rd"};
    private static final String[] DAY_ORDINAL = new String[]{null, "First", "Second", "Third", "Fourth", "Last"};
    private Date m_startDate;
    private Date m_finishDate;
    private Integer m_occurrences;
    private RecurrenceType m_recurrenceType;
    private boolean m_relative;
    private boolean m_workingDaysOnly;
    private boolean m_useEndDate;
    private Integer m_frequency;
    private Integer m_dayNumber;
    private Integer m_monthNumber;
    private EnumSet<Day> m_days = EnumSet.noneOf(Day.class);

    public Date getStartDate() {
        return this.m_startDate;
    }

    public void setStartDate(Date val) {
        this.m_startDate = val;
    }

    public Date getFinishDate() {
        return this.m_finishDate;
    }

    public void setFinishDate(Date val) {
        this.m_finishDate = val;
    }

    public Integer getOccurrences() {
        return this.m_occurrences;
    }

    public void setOccurrences(Integer occurrences) {
        this.m_occurrences = occurrences;
    }

    public RecurrenceType getRecurrenceType() {
        return this.m_recurrenceType;
    }

    public void setRecurrenceType(RecurrenceType type) {
        this.m_recurrenceType = type;
    }

    public boolean getUseEndDate() {
        return this.m_useEndDate;
    }

    public void setUseEndDate(boolean useEndDate) {
        this.m_useEndDate = useEndDate;
    }

    public boolean isWorkingDaysOnly() {
        return this.m_workingDaysOnly;
    }

    public void setWorkingDaysOnly(boolean workingDaysOnly) {
        this.m_workingDaysOnly = workingDaysOnly;
    }

    public boolean getWeeklyDay(Day day) {
        return this.m_days.contains(day);
    }

    public void setWeeklyDay(Day day, boolean value) {
        if (value) {
            this.m_days.add(day);
        } else {
            this.m_days.remove(day);
        }
    }

    public void setWeeklyDaysFromBitmap(Integer days, int[] masks) {
        if (days != null) {
            int value = days;
            for (Day day : Day.values()) {
                this.setWeeklyDay(day, (value & masks[day.getValue()]) != 0);
            }
        }
    }

    public boolean getRelative() {
        return this.m_relative;
    }

    public void setRelative(boolean relative) {
        this.m_relative = relative;
    }

    public Integer getFrequency() {
        return this.m_frequency;
    }

    public void setFrequency(Integer frequency) {
        this.m_frequency = frequency;
    }

    public Day getDayOfWeek() {
        Day result = null;
        if (!this.m_days.isEmpty()) {
            result = (Day)this.m_days.iterator().next();
        }
        return result;
    }

    public void setDayOfWeek(Day day) {
        this.m_days.clear();
        this.m_days.add(day);
    }

    public Integer getDayNumber() {
        return this.m_dayNumber;
    }

    public void setDayNumber(Integer day) {
        this.m_dayNumber = day;
    }

    public Integer getMonthNumber() {
        return this.m_monthNumber;
    }

    public void setMonthNumber(Integer month) {
        this.m_monthNumber = month;
    }

    public Date[] getDates() {
        int frequency = NumberHelper.getInt(this.m_frequency);
        if (frequency < 1) {
            frequency = 1;
        }
        Calendar calendar = DateHelper.popCalendar(this.m_startDate);
        ArrayList<Date> dates = new ArrayList<Date>();
        switch (this.m_recurrenceType) {
            case DAILY: {
                this.getDailyDates(calendar, frequency, dates);
                break;
            }
            case WEEKLY: {
                this.getWeeklyDates(calendar, frequency, dates);
                break;
            }
            case MONTHLY: {
                this.getMonthlyDates(calendar, frequency, dates);
                break;
            }
            case YEARLY: {
                this.getYearlyDates(calendar, dates);
            }
        }
        DateHelper.pushCalendar(calendar);
        return dates.toArray(new Date[dates.size()]);
    }

    private boolean moreDates(Calendar calendar, List<Date> dates) {
        boolean result;
        if (this.m_finishDate == null) {
            int occurrences = NumberHelper.getInt(this.m_occurrences);
            if (occurrences < 1) {
                occurrences = 1;
            }
            result = dates.size() < occurrences;
        } else {
            result = calendar.getTimeInMillis() <= this.m_finishDate.getTime();
        }
        return result;
    }

    private void getDailyDates(Calendar calendar, int frequency, List<Date> dates) {
        while (this.moreDates(calendar, dates)) {
            dates.add(calendar.getTime());
            calendar.add(6, frequency);
        }
    }

    private void getWeeklyDates(Calendar calendar, int frequency, List<Date> dates) {
        int currentDay = calendar.get(7);
        while (this.moreDates(calendar, dates)) {
            int offset = 0;
            for (int dayIndex = 0; dayIndex < 7; ++dayIndex) {
                if (this.getWeeklyDay(Day.getInstance(currentDay))) {
                    if (offset != 0) {
                        calendar.add(6, offset);
                        offset = 0;
                    }
                    if (!this.moreDates(calendar, dates)) break;
                    dates.add(calendar.getTime());
                }
                ++offset;
                if (++currentDay <= 7) continue;
                currentDay = 1;
            }
            if (frequency > 1) {
                offset += 7 * (frequency - 1);
            }
            calendar.add(6, offset);
        }
    }

    private void getMonthlyDates(Calendar calendar, int frequency, List<Date> dates) {
        if (this.m_relative) {
            this.getMonthlyRelativeDates(calendar, frequency, dates);
        } else {
            this.getMonthlyAbsoluteDates(calendar, frequency, dates);
        }
    }

    private void getMonthlyRelativeDates(Calendar calendar, int frequency, List<Date> dates) {
        long startDate = calendar.getTimeInMillis();
        calendar.set(5, 1);
        int dayNumber = NumberHelper.getInt(this.m_dayNumber);
        while (this.moreDates(calendar, dates)) {
            if (dayNumber > 4) {
                this.setCalendarToLastRelativeDay(calendar);
            } else {
                this.setCalendarToOrdinalRelativeDay(calendar, dayNumber);
            }
            if (calendar.getTimeInMillis() > startDate) {
                dates.add(calendar.getTime());
                if (!this.moreDates(calendar, dates)) break;
            }
            calendar.set(5, 1);
            calendar.add(2, frequency);
        }
    }

    private void getMonthlyAbsoluteDates(Calendar calendar, int frequency, List<Date> dates) {
        int currentDayNumber = calendar.get(5);
        calendar.set(5, 1);
        int requiredDayNumber = NumberHelper.getInt(this.m_dayNumber);
        if (requiredDayNumber < currentDayNumber) {
            calendar.add(2, 1);
        }
        while (this.moreDates(calendar, dates)) {
            int useDayNumber = requiredDayNumber;
            int maxDayNumber = calendar.getActualMaximum(5);
            if (useDayNumber > maxDayNumber) {
                useDayNumber = maxDayNumber;
            }
            calendar.set(5, useDayNumber);
            dates.add(calendar.getTime());
            calendar.set(5, 1);
            calendar.add(2, frequency);
        }
    }

    private void getYearlyDates(Calendar calendar, List<Date> dates) {
        if (this.m_relative) {
            this.getYearlyRelativeDates(calendar, dates);
        } else {
            this.getYearlyAbsoluteDates(calendar, dates);
        }
    }

    private void getYearlyRelativeDates(Calendar calendar, List<Date> dates) {
        long startDate = calendar.getTimeInMillis();
        calendar.set(5, 1);
        calendar.set(2, NumberHelper.getInt(this.m_monthNumber) - 1);
        int dayNumber = NumberHelper.getInt(this.m_dayNumber);
        while (this.moreDates(calendar, dates)) {
            if (dayNumber > 4) {
                this.setCalendarToLastRelativeDay(calendar);
            } else {
                this.setCalendarToOrdinalRelativeDay(calendar, dayNumber);
            }
            if (calendar.getTimeInMillis() > startDate) {
                dates.add(calendar.getTime());
                if (!this.moreDates(calendar, dates)) break;
            }
            calendar.set(5, 1);
            calendar.add(1, 1);
        }
    }

    private void getYearlyAbsoluteDates(Calendar calendar, List<Date> dates) {
        long startDate = calendar.getTimeInMillis();
        calendar.set(5, 1);
        calendar.set(2, NumberHelper.getInt(this.m_monthNumber) - 1);
        int requiredDayNumber = NumberHelper.getInt(this.m_dayNumber);
        while (this.moreDates(calendar, dates)) {
            int useDayNumber = requiredDayNumber;
            int maxDayNumber = calendar.getActualMaximum(5);
            if (useDayNumber > maxDayNumber) {
                useDayNumber = maxDayNumber;
            }
            calendar.set(5, useDayNumber);
            if (calendar.getTimeInMillis() < startDate) {
                calendar.add(1, 1);
            }
            dates.add(calendar.getTime());
            calendar.set(5, 1);
            calendar.add(1, 1);
        }
    }

    private void setCalendarToOrdinalRelativeDay(Calendar calendar, int dayNumber) {
        int currentDayOfWeek = calendar.get(7);
        int requiredDayOfWeek = this.getDayOfWeek().getValue();
        int dayOfWeekOffset = 0;
        if (requiredDayOfWeek > currentDayOfWeek) {
            dayOfWeekOffset = requiredDayOfWeek - currentDayOfWeek;
        } else if (requiredDayOfWeek < currentDayOfWeek) {
            dayOfWeekOffset = 7 - (currentDayOfWeek - requiredDayOfWeek);
        }
        if (dayOfWeekOffset != 0) {
            calendar.add(6, dayOfWeekOffset);
        }
        if (dayNumber > 1) {
            calendar.add(6, 7 * (dayNumber - 1));
        }
    }

    private void setCalendarToLastRelativeDay(Calendar calendar) {
        calendar.set(5, calendar.getActualMaximum(5));
        int currentDayOfWeek = calendar.get(7);
        int requiredDayOfWeek = this.getDayOfWeek().getValue();
        int dayOfWeekOffset = 0;
        if (currentDayOfWeek > requiredDayOfWeek) {
            dayOfWeekOffset = requiredDayOfWeek - currentDayOfWeek;
        } else if (currentDayOfWeek < requiredDayOfWeek) {
            dayOfWeekOffset = -7 + (requiredDayOfWeek - currentDayOfWeek);
        }
        if (dayOfWeekOffset != 0) {
            calendar.add(6, dayOfWeekOffset);
        }
    }

    public void setYearlyAbsoluteFromDate(Date date) {
        if (date != null) {
            Calendar cal = DateHelper.popCalendar(date);
            this.m_dayNumber = cal.get(5);
            this.m_monthNumber = cal.get(2) + 1;
            DateHelper.pushCalendar(cal);
        }
    }

    private String getOrdinal(Integer value) {
        int index = value;
        String result = index >= ORDINAL.length ? "every " + index + "th" : ORDINAL[index];
        return result;
    }

    public String toString() {
        DateFormatSymbols dfs = new DateFormatSymbols();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.print("[RecurringData");
        pw.print(this.m_recurrenceType);
        switch (this.m_recurrenceType) {
            case DAILY: {
                pw.print(" " + this.getOrdinal(this.m_frequency));
                pw.print(this.m_workingDaysOnly ? " Working day" : " Day");
                break;
            }
            case WEEKLY: {
                pw.print(" " + this.getOrdinal(this.m_frequency));
                pw.print(" week on ");
                StringBuilder sb2 = new StringBuilder();
                for (Day day : Day.values()) {
                    if (!this.getWeeklyDay(day)) continue;
                    if (sb2.length() != 0) {
                        sb2.append(", ");
                    }
                    sb2.append(dfs.getWeekdays()[day.getValue()]);
                }
                pw.print(sb2.toString());
                break;
            }
            case MONTHLY: {
                if (this.m_relative) {
                    pw.print(" on The ");
                    pw.print(DAY_ORDINAL[this.m_dayNumber]);
                    pw.print(" ");
                    pw.print(dfs.getWeekdays()[this.getDayOfWeek().getValue()]);
                    pw.print(" of ");
                    pw.print(this.getOrdinal(this.m_frequency));
                } else {
                    pw.print(" on Day ");
                    pw.print(this.m_dayNumber);
                    pw.print(" of ");
                    pw.print(this.getOrdinal(this.m_frequency));
                }
                pw.print(" month");
                break;
            }
            case YEARLY: {
                pw.print(" on the ");
                if (this.m_relative) {
                    pw.print(DAY_ORDINAL[this.m_dayNumber]);
                    pw.print(" ");
                    pw.print(dfs.getWeekdays()[this.getDayOfWeek().getValue()]);
                    pw.print(" of ");
                    pw.print(dfs.getMonths()[this.m_monthNumber - 1]);
                    break;
                }
                pw.print(this.m_dayNumber + " " + dfs.getMonths()[this.m_monthNumber - 1]);
            }
        }
        pw.print(" From " + this.m_startDate);
        pw.print(" For " + this.m_occurrences + " occurrences");
        pw.print(" To " + this.m_finishDate);
        pw.println("]");
        pw.flush();
        return os.toString();
    }
}

