/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.ProjectEntityContainer;
import net.sf.mpxj.ProjectEntityWithID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.NumberHelper;

public abstract class ProjectEntityWithIDContainer<T extends ProjectEntityWithID & Comparable<T>>
extends ProjectEntityContainer<T> {
    protected Map<Integer, T> m_idMap = new HashMap<Integer, T>();

    public ProjectEntityWithIDContainer(ProjectFile projectFile) {
        super(projectFile);
    }

    public void renumberIDs() {
        if (!this.isEmpty()) {
            Collections.sort(this);
            ProjectEntityWithID firstEntity = (ProjectEntityWithID)this.get(0);
            int id2 = NumberHelper.getInt(firstEntity.getID());
            if (id2 != 0) {
                id2 = 1;
            }
            for (ProjectEntityWithID entity : this) {
                entity.setID(id2++);
            }
        }
    }

    public T getByID(Integer id2) {
        return (T)((ProjectEntityWithID)this.m_idMap.get(id2));
    }

    public void unmapID(Integer id2) {
        this.m_idMap.remove(id2);
    }

    public void mapID(Integer id2, T entity) {
        this.m_idMap.put(id2, entity);
    }
}

