/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.ProjectCalendarDateRanges;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.common.DateHelper;

public final class ProjectCalendarException
extends ProjectCalendarDateRanges
implements Comparable<ProjectCalendarException> {
    private Date m_fromDate;
    private Date m_toDate;
    private String m_name;
    private RecurringData m_recurring;

    ProjectCalendarException(Date fromDate, Date toDate) {
        this.m_fromDate = DateHelper.getDayStartDate(fromDate);
        this.m_toDate = DateHelper.getDayEndDate(toDate);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public Date getFromDate() {
        return this.m_fromDate;
    }

    public Date getToDate() {
        return this.m_toDate;
    }

    public RecurringData getRecurring() {
        return this.m_recurring;
    }

    public void setRecurring(RecurringData recurring) {
        this.m_recurring = recurring;
    }

    public boolean getWorking() {
        return this.getRangeCount() != 0;
    }

    public boolean contains(Date date) {
        boolean result = false;
        if (date != null) {
            result = DateHelper.compare(this.getFromDate(), this.getToDate(), date) == 0;
        }
        return result;
    }

    @Override
    public int compareTo(ProjectCalendarException o2) {
        long fromTime2;
        long fromTime1 = this.m_fromDate.getTime();
        return fromTime1 < (fromTime2 = o2.m_fromDate.getTime()) ? -1 : (fromTime1 == fromTime2 ? 0 : 1);
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("[ProjectCalendarException");
        if (this.m_name != null && !this.m_name.isEmpty()) {
            sb2.append(" name=" + this.m_name);
        }
        sb2.append(" working=" + this.getWorking());
        sb2.append(" fromDate=" + this.m_fromDate);
        sb2.append(" toDate=" + this.m_toDate);
        if (this.m_recurring != null) {
            sb2.append(" recurring=" + this.m_recurring);
        }
        for (DateRange range : this) {
            sb2.append(range.toString());
        }
        sb2.append("]");
        return sb2.toString();
    }
}

