/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.DataType;
import net.sf.mpxj.MpxjEnum;
import net.sf.mpxj.common.EnumHelper;

public enum CustomFieldValueDataType implements MpxjEnum
{
    DATE(4, 4, DataType.DATE),
    DURATION(6, 6, DataType.DURATION),
    COST(9, 5, DataType.CURRENCY),
    NUMBER(15, 7, DataType.NUMERIC),
    FLAG(17, 17, DataType.BOOLEAN),
    TEXT(21, 3, DataType.STRING),
    FINISH_DATE(27, 9, DataType.DATE);

    private static final CustomFieldValueDataType[] TYPE_VALUES;
    private static final CustomFieldValueDataType[] MASK_VALUES;
    private final int m_value;
    private final int m_maskValue;
    private final DataType m_type;

    private CustomFieldValueDataType(int value, int maskValue, DataType type) {
        this.m_value = value;
        this.m_maskValue = maskValue;
        this.m_type = type;
    }

    public static CustomFieldValueDataType getInstance(int type) {
        if (type >= 0 && type < TYPE_VALUES.length) {
            return TYPE_VALUES[type];
        }
        return null;
    }

    public static CustomFieldValueDataType getInstanceByMaskValue(int type) {
        if (type >= 0 && type < MASK_VALUES.length) {
            return MASK_VALUES[type];
        }
        return null;
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public DataType getDataType() {
        return this.m_type;
    }

    public int getMaskValue() {
        return this.m_maskValue;
    }

    static {
        TYPE_VALUES = (CustomFieldValueDataType[])EnumHelper.createTypeArray(CustomFieldValueDataType.class, (int)21);
        MASK_VALUES = new CustomFieldValueDataType[28];
        CustomFieldValueDataType[] customFieldValueDataTypeArray = CustomFieldValueDataType.values();
        int n2 = customFieldValueDataTypeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CustomFieldValueDataType value;
            CustomFieldValueDataType.MASK_VALUES[value.getMaskValue()] = value = customFieldValueDataTypeArray[i2];
        }
    }
}

