/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.txw2;

import com.sun.xml.txw2.Attribute;
import com.sun.xml.txw2.ContainerElement;
import com.sun.xml.txw2.Content;
import com.sun.xml.txw2.ContentVisitor;
import com.sun.xml.txw2.Document;
import com.sun.xml.txw2.NamespaceDecl;
import com.sun.xml.txw2.NamespaceResolver;

class StartTag
extends Content
implements NamespaceResolver {
    private String uri;
    private final String localName;
    private Attribute firstAtt;
    private Attribute lastAtt;
    private ContainerElement owner;
    private NamespaceDecl firstNs;
    private NamespaceDecl lastNs;
    final Document document;

    public StartTag(ContainerElement owner, String uri, String localName) {
        this(owner.document, uri, localName);
        this.owner = owner;
    }

    public StartTag(Document document, String uri, String localName) {
        assert (uri != null);
        assert (localName != null);
        this.uri = uri;
        this.localName = localName;
        this.document = document;
        this.addNamespaceDecl(uri, null, false);
    }

    public void addAttribute(String nsUri, String localName, Object arg) {
        this.checkWritable();
        Attribute a2 = this.firstAtt;
        while (a2 != null && !a2.hasName(nsUri, localName)) {
            a2 = a2.next;
        }
        if (a2 == null) {
            a2 = new Attribute(nsUri, localName);
            if (this.lastAtt == null) {
                assert (this.firstAtt == null);
                this.firstAtt = this.lastAtt = a2;
            } else {
                assert (this.firstAtt != null);
                this.lastAtt.next = a2;
                this.lastAtt = a2;
            }
            if (nsUri.length() > 0) {
                this.addNamespaceDecl(nsUri, null, true);
            }
        }
        this.document.writeValue(arg, this, a2.value);
    }

    public NamespaceDecl addNamespaceDecl(String uri, String prefix, boolean requirePrefix) {
        this.checkWritable();
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        if (uri.length() == 0) {
            if (requirePrefix) {
                throw new IllegalArgumentException("The empty namespace cannot have a non-empty prefix");
            }
            if (prefix != null && prefix.length() > 0) {
                throw new IllegalArgumentException("The empty namespace can be only bound to the empty prefix");
            }
            prefix = "";
        }
        NamespaceDecl n2 = this.firstNs;
        while (n2 != null) {
            if (uri.equals(n2.uri)) {
                if (prefix == null) {
                    n2.requirePrefix |= requirePrefix;
                    return n2;
                }
                if (n2.prefix == null) {
                    n2.prefix = prefix;
                    n2.requirePrefix |= requirePrefix;
                    return n2;
                }
                if (prefix.equals(n2.prefix)) {
                    n2.requirePrefix |= requirePrefix;
                    return n2;
                }
            }
            if (prefix != null && n2.prefix != null && n2.prefix.equals(prefix)) {
                throw new IllegalArgumentException("Prefix '" + prefix + "' is already bound to '" + n2.uri + '\'');
            }
            n2 = n2.next;
        }
        NamespaceDecl ns = new NamespaceDecl(this.document.assignNewId(), uri, prefix, requirePrefix);
        if (this.lastNs == null) {
            assert (this.firstNs == null);
            this.firstNs = this.lastNs = ns;
        } else {
            assert (this.firstNs != null);
            this.lastNs.next = ns;
            this.lastNs = ns;
        }
        return ns;
    }

    private void checkWritable() {
        if (this.isWritten()) {
            throw new IllegalStateException("The start tag of " + this.localName + " has already been written. " + "If you need out of order writing, see the TypedXmlWriter.block method");
        }
    }

    boolean isWritten() {
        return this.uri == null;
    }

    boolean isReadyToCommit() {
        if (this.owner != null && this.owner.isBlocked()) {
            return false;
        }
        for (Content c2 = this.getNext(); c2 != null; c2 = c2.getNext()) {
            if (!c2.concludesPendingStartTag()) continue;
            return true;
        }
        return false;
    }

    public void written() {
        this.lastAtt = null;
        this.firstAtt = null;
        this.uri = null;
        if (this.owner != null) {
            assert (this.owner.startTag == this);
            this.owner.startTag = null;
        }
    }

    boolean concludesPendingStartTag() {
        return true;
    }

    void accept(ContentVisitor visitor) {
        visitor.onStartTag(this.uri, this.localName, this.firstAtt, this.firstNs);
    }

    public String getPrefix(String nsUri) {
        NamespaceDecl ns = this.addNamespaceDecl(nsUri, null, false);
        if (ns.prefix != null) {
            return ns.prefix;
        }
        return ns.dummyPrefix;
    }
}

