/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.sax;

import com.sun.xml.fastinfoset.QualifiedName;
import com.sun.xml.fastinfoset.sax.SAXDocumentSerializer;
import com.sun.xml.fastinfoset.util.LocalNameQualifiedNamesMap;
import com.sun.xml.fastinfoset.util.StringIntMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jvnet.fastinfoset.FastInfosetException;
import org.jvnet.fastinfoset.sax.EncodingAlgorithmAttributes;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SAXDocumentSerializerWithPrefixMapping
extends SAXDocumentSerializer {
    protected Map _namespaceToPrefixMapping;
    protected Map _prefixToPrefixMapping;
    protected String _lastCheckedNamespace;
    protected String _lastCheckedPrefix;
    protected StringIntMap _declaredNamespaces;

    public SAXDocumentSerializerWithPrefixMapping(Map namespaceToPrefixMapping) {
        super(true);
        this._namespaceToPrefixMapping = new HashMap(namespaceToPrefixMapping);
        this._prefixToPrefixMapping = new HashMap();
        this._namespaceToPrefixMapping.put("", "");
        this._namespaceToPrefixMapping.put("http://www.w3.org/XML/1998/namespace", "xml");
        this._declaredNamespaces = new StringIntMap(4);
    }

    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            if (!this._elementHasNamespaces) {
                this.encodeTermination();
                this.mark();
                this._elementHasNamespaces = true;
                this.write(56);
                this._declaredNamespaces.clear();
                this._declaredNamespaces.obtainIndex(uri);
            } else if (this._declaredNamespaces.obtainIndex(uri) != -1) {
                String p2 = this.getPrefix(uri);
                if (p2 != null) {
                    this._prefixToPrefixMapping.put(prefix, p2);
                }
                return;
            }
            String p3 = this.getPrefix(uri);
            if (p3 != null) {
                this.encodeNamespaceAttribute(p3, uri);
                this._prefixToPrefixMapping.put(prefix, p3);
            } else {
                this.putPrefix(uri, prefix);
                this.encodeNamespaceAttribute(prefix, uri);
            }
        }
        catch (IOException e2) {
            throw new SAXException("startElement", e2);
        }
    }

    protected final void encodeElement(String namespaceURI, String qName, String localName) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.elementName.obtainEntry(localName);
        if (entry._valueIndex > 0) {
            if (this.encodeElementMapEntry(entry, namespaceURI)) {
                return;
            }
            if (this._v.elementName.isQNameFromReadOnlyMap(entry._value[0])) {
                entry = this._v.elementName.obtainDynamicEntry(localName);
                if (entry._valueIndex > 0 && this.encodeElementMapEntry(entry, namespaceURI)) {
                    return;
                }
            }
        }
        this.encodeLiteralElementQualifiedNameOnThirdBit(namespaceURI, this.getPrefix(namespaceURI), localName, entry);
    }

    protected boolean encodeElementMapEntry(LocalNameQualifiedNamesMap.Entry entry, String namespaceURI) throws IOException {
        QualifiedName[] names = entry._value;
        for (int i2 = 0; i2 < entry._valueIndex; ++i2) {
            if (namespaceURI != names[i2].namespaceName && !namespaceURI.equals(names[i2].namespaceName)) continue;
            this.encodeNonZeroIntegerOnThirdBit(names[i2].index);
            return true;
        }
        return false;
    }

    protected final void encodeAttributes(Attributes atts) throws IOException, FastInfosetException {
        if (atts instanceof EncodingAlgorithmAttributes) {
            EncodingAlgorithmAttributes eAtts = (EncodingAlgorithmAttributes)atts;
            for (int i2 = 0; i2 < eAtts.getLength(); ++i2) {
                String uri = atts.getURI(i2);
                if (!this.encodeAttribute(uri, atts.getQName(i2), atts.getLocalName(i2))) continue;
                Object data = eAtts.getAlgorithmData(i2);
                if (data == null) {
                    String value = eAtts.getValue(i2);
                    boolean addToTable = this.isAttributeValueLengthMatchesLimit(value.length());
                    boolean mustToBeAddedToTable = eAtts.getToIndex(i2);
                    String alphabet = eAtts.getAlpababet(i2);
                    if (alphabet == null) {
                        if (uri == "http://www.w3.org/2001/XMLSchema-instance" || uri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                            value = this.convertQName(value);
                        }
                        this.encodeNonIdentifyingStringOnFirstBit(value, this._v.attributeValue, addToTable, mustToBeAddedToTable);
                        continue;
                    }
                    if (alphabet == "0123456789-:TZ ") {
                        this.encodeDateTimeNonIdentifyingStringOnFirstBit(value, addToTable, mustToBeAddedToTable);
                        continue;
                    }
                    if (alphabet == "0123456789-+.E ") {
                        this.encodeNumericNonIdentifyingStringOnFirstBit(value, addToTable, mustToBeAddedToTable);
                        continue;
                    }
                    this.encodeNonIdentifyingStringOnFirstBit(value, this._v.attributeValue, addToTable, mustToBeAddedToTable);
                    continue;
                }
                this.encodeNonIdentifyingStringOnFirstBit(eAtts.getAlgorithmURI(i2), eAtts.getAlgorithmIndex(i2), data);
            }
        } else {
            for (int i3 = 0; i3 < atts.getLength(); ++i3) {
                String uri = atts.getURI(i3);
                if (!this.encodeAttribute(atts.getURI(i3), atts.getQName(i3), atts.getLocalName(i3))) continue;
                String value = atts.getValue(i3);
                boolean addToTable = this.isAttributeValueLengthMatchesLimit(value.length());
                if (uri == "http://www.w3.org/2001/XMLSchema-instance" || uri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                    value = this.convertQName(value);
                }
                this.encodeNonIdentifyingStringOnFirstBit(value, this._v.attributeValue, addToTable, false);
            }
        }
        this._b = 240;
        this._terminate = true;
    }

    private String convertQName(String qName) {
        String p2;
        int i2 = qName.indexOf(58);
        String prefix = "";
        String localName = qName;
        if (i2 != -1) {
            prefix = qName.substring(0, i2);
            localName = qName.substring(i2 + 1);
        }
        if ((p2 = (String)this._prefixToPrefixMapping.get(prefix)) != null) {
            if (p2.length() == 0) {
                return localName;
            }
            return p2 + ":" + localName;
        }
        return qName;
    }

    protected final boolean encodeAttribute(String namespaceURI, String qName, String localName) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.attributeName.obtainEntry(localName);
        if (entry._valueIndex > 0) {
            if (this.encodeAttributeMapEntry(entry, namespaceURI)) {
                return true;
            }
            if (this._v.attributeName.isQNameFromReadOnlyMap(entry._value[0])) {
                entry = this._v.attributeName.obtainDynamicEntry(localName);
                if (entry._valueIndex > 0 && this.encodeAttributeMapEntry(entry, namespaceURI)) {
                    return true;
                }
            }
        }
        return this.encodeLiteralAttributeQualifiedNameOnSecondBit(namespaceURI, this.getPrefix(namespaceURI), localName, entry);
    }

    protected boolean encodeAttributeMapEntry(LocalNameQualifiedNamesMap.Entry entry, String namespaceURI) throws IOException {
        QualifiedName[] names = entry._value;
        for (int i2 = 0; i2 < entry._valueIndex; ++i2) {
            if (namespaceURI != names[i2].namespaceName && !namespaceURI.equals(names[i2].namespaceName)) continue;
            this.encodeNonZeroIntegerOnSecondBitFirstBitZero(names[i2].index);
            return true;
        }
        return false;
    }

    protected final String getPrefix(String namespaceURI) {
        if (this._lastCheckedNamespace == namespaceURI) {
            return this._lastCheckedPrefix;
        }
        this._lastCheckedNamespace = namespaceURI;
        this._lastCheckedPrefix = (String)this._namespaceToPrefixMapping.get(namespaceURI);
        return this._lastCheckedPrefix;
    }

    protected final void putPrefix(String namespaceURI, String prefix) {
        this._namespaceToPrefixMapping.put(namespaceURI, prefix);
        this._lastCheckedNamespace = namespaceURI;
        this._lastCheckedPrefix = prefix;
    }
}

