/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime;

import com.sun.xml.bind.v2.model.core.ErrorHandler;
import com.sun.xml.bind.v2.runtime.IllegalAnnotationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;

public class IllegalAnnotationsException
extends JAXBException {
    private final List<IllegalAnnotationException> errors;
    private static final long serialVersionUID = 1L;

    public IllegalAnnotationsException(List<IllegalAnnotationException> errors) {
        super(errors.size() + " counts of IllegalAnnotationExceptions");
        assert (!errors.isEmpty()) : "there must be at least one error";
        this.errors = Collections.unmodifiableList(new ArrayList<IllegalAnnotationException>(errors));
    }

    @Override
    public String toString() {
        StringBuilder sb2 = new StringBuilder(super.toString());
        sb2.append('\n');
        for (IllegalAnnotationException error : this.errors) {
            sb2.append(error.toString()).append('\n');
        }
        return sb2.toString();
    }

    public List<IllegalAnnotationException> getErrors() {
        return this.errors;
    }

    public static class Builder
    implements ErrorHandler {
        private final List<IllegalAnnotationException> list = new ArrayList<IllegalAnnotationException>();

        @Override
        public void error(IllegalAnnotationException e2) {
            this.list.add(e2);
        }

        public void check() throws IllegalAnnotationsException {
            if (this.list.isEmpty()) {
                return;
            }
            throw new IllegalAnnotationsException(this.list);
        }
    }
}

