/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.api.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

class NameUtil {
    protected static final int UPPER_LETTER = 0;
    protected static final int LOWER_LETTER = 1;
    protected static final int OTHER_LETTER = 2;
    protected static final int DIGIT = 3;
    protected static final int OTHER = 4;
    private static final byte[] actionTable = new byte[25];
    private static final byte ACTION_CHECK_PUNCT = 0;
    private static final byte ACTION_CHECK_C2 = 1;
    private static final byte ACTION_BREAK = 2;
    private static final byte ACTION_NOBREAK = 3;

    NameUtil() {
    }

    protected boolean isPunct(char c2) {
        return c2 == '-' || c2 == '.' || c2 == ':' || c2 == '_' || c2 == '\u00b7' || c2 == '\u0387' || c2 == '\u06dd' || c2 == '\u06de';
    }

    protected static boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9' || Character.isDigit(c2);
    }

    protected static boolean isUpper(char c2) {
        return c2 >= 'A' && c2 <= 'Z' || Character.isUpperCase(c2);
    }

    protected static boolean isLower(char c2) {
        return c2 >= 'a' && c2 <= 'z' || Character.isLowerCase(c2);
    }

    protected boolean isLetter(char c2) {
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || Character.isLetter(c2);
    }

    private String toLowerCase(String s2) {
        return s2.toLowerCase(Locale.ENGLISH);
    }

    private String toUpperCase(char c2) {
        return String.valueOf(c2).toUpperCase(Locale.ENGLISH);
    }

    private String toUpperCase(String s2) {
        return s2.toUpperCase(Locale.ENGLISH);
    }

    public String capitalize(String s2) {
        if (!NameUtil.isLower(s2.charAt(0))) {
            return s2;
        }
        StringBuilder sb2 = new StringBuilder(s2.length());
        sb2.append(this.toUpperCase(s2.charAt(0)));
        sb2.append(this.toLowerCase(s2.substring(1)));
        return sb2.toString();
    }

    private int nextBreak(String s2, int start) {
        int n2 = s2.length();
        char c1 = s2.charAt(start);
        int t1 = this.classify(c1);
        block5: for (int i2 = start + 1; i2 < n2; ++i2) {
            int t0 = t1;
            c1 = s2.charAt(i2);
            t1 = this.classify(c1);
            switch (actionTable[t0 * 5 + t1]) {
                case 0: {
                    if (!this.isPunct(c1)) continue block5;
                    return i2;
                }
                case 1: {
                    char c2;
                    if (i2 >= n2 - 1 || !NameUtil.isLower(c2 = s2.charAt(i2 + 1))) continue block5;
                    return i2;
                }
                case 2: {
                    return i2;
                }
            }
        }
        return -1;
    }

    private static byte decideAction(int t0, int t1) {
        if (t0 == 4 && t1 == 4) {
            return 0;
        }
        if (!NameUtil.xor(t0 == 3, t1 == 3)) {
            return 2;
        }
        if (t0 == 1 && t1 != 1) {
            return 2;
        }
        if (!NameUtil.xor(t0 <= 2, t1 <= 2)) {
            return 2;
        }
        if (!NameUtil.xor(t0 == 2, t1 == 2)) {
            return 2;
        }
        if (t0 == 0 && t1 == 0) {
            return 1;
        }
        return 3;
    }

    private static boolean xor(boolean x2, boolean y2) {
        return x2 && y2 || !x2 && !y2;
    }

    protected int classify(char c0) {
        switch (Character.getType(c0)) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: 
            case 5: {
                return 2;
            }
            case 9: {
                return 3;
            }
        }
        return 4;
    }

    public List<String> toWordList(String s2) {
        ArrayList<String> ss = new ArrayList<String>();
        int n2 = s2.length();
        int i2 = 0;
        while (i2 < n2) {
            while (i2 < n2 && this.isPunct(s2.charAt(i2))) {
                ++i2;
            }
            if (i2 >= n2) break;
            int b2 = this.nextBreak(s2, i2);
            String w2 = b2 == -1 ? s2.substring(i2) : s2.substring(i2, b2);
            ss.add(NameUtil.escape(this.capitalize(w2)));
            if (b2 == -1) break;
            i2 = b2;
        }
        return ss;
    }

    protected String toMixedCaseName(List<String> ss, boolean startUpper) {
        StringBuilder sb2 = new StringBuilder();
        if (!ss.isEmpty()) {
            sb2.append(startUpper ? ss.get(0) : this.toLowerCase(ss.get(0)));
            for (int i2 = 1; i2 < ss.size(); ++i2) {
                sb2.append(ss.get(i2));
            }
        }
        return sb2.toString();
    }

    protected String toMixedCaseVariableName(String[] ss, boolean startUpper, boolean cdrUpper) {
        if (cdrUpper) {
            for (int i2 = 1; i2 < ss.length; ++i2) {
                ss[i2] = this.capitalize(ss[i2]);
            }
        }
        StringBuilder sb2 = new StringBuilder();
        if (ss.length > 0) {
            sb2.append(startUpper ? ss[0] : this.toLowerCase(ss[0]));
            for (int i3 = 1; i3 < ss.length; ++i3) {
                sb2.append(ss[i3]);
            }
        }
        return sb2.toString();
    }

    public String toConstantName(String s2) {
        return this.toConstantName(this.toWordList(s2));
    }

    public String toConstantName(List<String> ss) {
        StringBuilder sb2 = new StringBuilder();
        if (!ss.isEmpty()) {
            sb2.append(this.toUpperCase(ss.get(0)));
            for (int i2 = 1; i2 < ss.size(); ++i2) {
                sb2.append('_');
                sb2.append(this.toUpperCase(ss.get(i2)));
            }
        }
        return sb2.toString();
    }

    public static void escape(StringBuilder sb2, String s2, int start) {
        int n2 = s2.length();
        for (int i2 = start; i2 < n2; ++i2) {
            char c2 = s2.charAt(i2);
            if (Character.isJavaIdentifierPart(c2)) {
                sb2.append(c2);
                continue;
            }
            sb2.append('_');
            if (c2 <= '\u000f') {
                sb2.append("000");
            } else if (c2 <= '\u00ff') {
                sb2.append("00");
            } else if (c2 <= '\u0fff') {
                sb2.append('0');
            }
            sb2.append(Integer.toString(c2, 16));
        }
    }

    private static String escape(String s2) {
        int n2 = s2.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isJavaIdentifierPart(s2.charAt(i2))) continue;
            StringBuilder sb2 = new StringBuilder(s2.substring(0, i2));
            NameUtil.escape(sb2, s2, i2);
            return sb2.toString();
        }
        return s2;
    }

    static {
        for (int t0 = 0; t0 < 5; ++t0) {
            for (int t1 = 0; t1 < 5; ++t1) {
                NameUtil.actionTable[t0 * 5 + t1] = NameUtil.decideAction(t0, t1);
            }
        }
    }
}

