/*
 * Decompiled with CFR 0.152.
 */
package com.rtfparserkit.utils;

import java.util.Arrays;

public class HexUtils {
    private static final int[] HEX_MAP = new int[103];

    public static int parseHexDigit(int ch) {
        int b2;
        try {
            b2 = HEX_MAP[ch];
        }
        catch (IndexOutOfBoundsException ex) {
            b2 = -1;
        }
        if (b2 == -1) {
            throw new IllegalArgumentException("Invalid hex digit " + ch);
        }
        return b2;
    }

    public static final byte[] parseHexString(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid hex string");
        }
        byte[] bytes = new byte[hex.length() / 2];
        for (int byteIndex = 0; byteIndex < bytes.length; ++byteIndex) {
            int stringIndex = byteIndex * 2;
            int b2 = HexUtils.parseHexDigit(hex.charAt(stringIndex)) << 4;
            bytes[byteIndex] = (byte)(b2 += HexUtils.parseHexDigit(hex.charAt(stringIndex + 1)));
        }
        return bytes;
    }

    static {
        Arrays.fill(HEX_MAP, -1);
        HexUtils.HEX_MAP[48] = 0;
        HexUtils.HEX_MAP[49] = 1;
        HexUtils.HEX_MAP[50] = 2;
        HexUtils.HEX_MAP[51] = 3;
        HexUtils.HEX_MAP[52] = 4;
        HexUtils.HEX_MAP[53] = 5;
        HexUtils.HEX_MAP[54] = 6;
        HexUtils.HEX_MAP[55] = 7;
        HexUtils.HEX_MAP[56] = 8;
        HexUtils.HEX_MAP[57] = 9;
        HexUtils.HEX_MAP[65] = 10;
        HexUtils.HEX_MAP[66] = 11;
        HexUtils.HEX_MAP[67] = 12;
        HexUtils.HEX_MAP[68] = 13;
        HexUtils.HEX_MAP[69] = 14;
        HexUtils.HEX_MAP[70] = 15;
        HexUtils.HEX_MAP[97] = 10;
        HexUtils.HEX_MAP[98] = 11;
        HexUtils.HEX_MAP[99] = 12;
        HexUtils.HEX_MAP[100] = 13;
        HexUtils.HEX_MAP[101] = 14;
        HexUtils.HEX_MAP[102] = 15;
    }
}

