/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import com.jhlabs.image.GaussianFilter;
import com.jhlabs.image.PixelUtils;
import java.awt.image.BufferedImage;
import java.awt.image.Kernel;

public class SmartBlurFilter
extends AbstractBufferedImageOp {
    private int hRadius = 5;
    private int vRadius = 5;
    private int threshold = 10;

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        this.getRGB(src, 0, 0, width, height, inPixels);
        Kernel kernel = GaussianFilter.makeKernel(this.hRadius);
        this.thresholdBlur(kernel, inPixels, outPixels, width, height, true);
        this.thresholdBlur(kernel, outPixels, inPixels, height, width, true);
        this.setRGB(dst, 0, 0, width, height, inPixels);
        return dst;
    }

    public void thresholdBlur(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height, boolean alpha) {
        boolean index = false;
        float[] matrix = kernel.getKernelData(null);
        int cols = kernel.getWidth();
        int cols2 = cols / 2;
        for (int y2 = 0; y2 < height; ++y2) {
            int ioffset = y2 * width;
            int outIndex = y2;
            for (int x2 = 0; x2 < width; ++x2) {
                float r2 = 0.0f;
                float g2 = 0.0f;
                float b2 = 0.0f;
                float a2 = 0.0f;
                int moffset = cols2;
                int rgb1 = inPixels[ioffset + x2];
                int a1 = rgb1 >> 24 & 0xFF;
                int r1 = rgb1 >> 16 & 0xFF;
                int g1 = rgb1 >> 8 & 0xFF;
                int b1 = rgb1 & 0xFF;
                float af = 0.0f;
                float rf = 0.0f;
                float gf = 0.0f;
                float bf = 0.0f;
                for (int col = -cols2; col <= cols2; ++col) {
                    float f2 = matrix[moffset + col];
                    if (f2 == 0.0f) continue;
                    int ix = x2 + col;
                    if (0 > ix || ix >= width) {
                        ix = x2;
                    }
                    int rgb2 = inPixels[ioffset + ix];
                    int a22 = rgb2 >> 24 & 0xFF;
                    int r22 = rgb2 >> 16 & 0xFF;
                    int g22 = rgb2 >> 8 & 0xFF;
                    int b22 = rgb2 & 0xFF;
                    int d2 = a1 - a22;
                    if (d2 >= -this.threshold && d2 <= this.threshold) {
                        a2 += f2 * (float)a22;
                        af += f2;
                    }
                    if ((d2 = r1 - r22) >= -this.threshold && d2 <= this.threshold) {
                        r2 += f2 * (float)r22;
                        rf += f2;
                    }
                    if ((d2 = g1 - g22) >= -this.threshold && d2 <= this.threshold) {
                        g2 += f2 * (float)g22;
                        gf += f2;
                    }
                    if ((d2 = b1 - b22) < -this.threshold || d2 > this.threshold) continue;
                    b2 += f2 * (float)b22;
                    bf += f2;
                }
                a2 = af == 0.0f ? (float)a1 : a2 / af;
                r2 = rf == 0.0f ? (float)r1 : r2 / rf;
                g2 = gf == 0.0f ? (float)g1 : g2 / gf;
                b2 = bf == 0.0f ? (float)b1 : b2 / bf;
                int ia = alpha ? PixelUtils.clamp((int)((double)a2 + 0.5)) : 255;
                int ir = PixelUtils.clamp((int)((double)r2 + 0.5));
                int ig = PixelUtils.clamp((int)((double)g2 + 0.5));
                int ib2 = PixelUtils.clamp((int)((double)b2 + 0.5));
                outPixels[outIndex] = ia << 24 | ir << 16 | ig << 8 | ib2;
                outIndex += height;
            }
        }
    }

    public void setHRadius(int hRadius) {
        this.hRadius = hRadius;
    }

    public int getHRadius() {
        return this.hRadius;
    }

    public void setVRadius(int vRadius) {
        this.vRadius = vRadius;
    }

    public int getVRadius() {
        return this.vRadius;
    }

    public void setRadius(int radius) {
        this.hRadius = this.vRadius = radius;
    }

    public int getRadius() {
        return this.hRadius;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public String toString() {
        return "Blur/Smart Blur...";
    }
}

