/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.PointFilter;
import java.io.Serializable;

public class RGBAdjustFilter
extends PointFilter
implements Serializable {
    public float rFactor;
    public float gFactor;
    public float bFactor;

    public RGBAdjustFilter() {
        this(0.0f, 0.0f, 0.0f);
    }

    public RGBAdjustFilter(float r2, float g2, float b2) {
        this.rFactor = 1.0f + r2;
        this.gFactor = 1.0f + g2;
        this.bFactor = 1.0f + b2;
        this.canFilterIndexColorModel = true;
    }

    public void setRFactor(float rFactor) {
        this.rFactor = 1.0f + rFactor;
    }

    public float getRFactor() {
        return this.rFactor - 1.0f;
    }

    public void setGFactor(float gFactor) {
        this.gFactor = 1.0f + gFactor;
    }

    public float getGFactor() {
        return this.gFactor - 1.0f;
    }

    public void setBFactor(float bFactor) {
        this.bFactor = 1.0f + bFactor;
    }

    public float getBFactor() {
        return this.bFactor - 1.0f;
    }

    public int[] getLUT() {
        int[] lut = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            lut[i2] = this.filterRGB(0, 0, i2 << 24 | i2 << 16 | i2 << 8 | i2);
        }
        return lut;
    }

    public int filterRGB(int x2, int y2, int rgb) {
        int a2 = rgb & 0xFF000000;
        int r2 = rgb >> 16 & 0xFF;
        int g2 = rgb >> 8 & 0xFF;
        int b2 = rgb & 0xFF;
        r2 = PixelUtils.clamp((int)((float)r2 * this.rFactor));
        g2 = PixelUtils.clamp((int)((float)g2 * this.gFactor));
        b2 = PixelUtils.clamp((int)((float)b2 * this.bFactor));
        return a2 | r2 << 16 | g2 << 8 | b2;
    }

    public String toString() {
        return "Colors/Adjust RGB...";
    }
}

