/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.BinaryFilter;
import java.awt.Rectangle;

public class ErodeFilter
extends BinaryFilter {
    protected int threshold = 2;

    public ErodeFilter() {
        this.newColor = -1;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int[] outPixels = new int[width * height];
        for (int i2 = 0; i2 < this.iterations; ++i2) {
            int index = 0;
            if (i2 > 0) {
                int[] t2 = inPixels;
                inPixels = outPixels;
                outPixels = t2;
            }
            for (int y2 = 0; y2 < height; ++y2) {
                for (int x2 = 0; x2 < width; ++x2) {
                    int pixel = inPixels[y2 * width + x2];
                    if (this.blackFunction.isBlack(pixel)) {
                        int neighbours = 0;
                        for (int dy = -1; dy <= 1; ++dy) {
                            int iy = y2 + dy;
                            if (0 > iy || iy >= height) continue;
                            int ioffset = iy * width;
                            for (int dx = -1; dx <= 1; ++dx) {
                                int rgb;
                                int ix = x2 + dx;
                                if (dy == 0 && dx == 0 || 0 > ix || ix >= width || this.blackFunction.isBlack(rgb = inPixels[ioffset + ix])) continue;
                                ++neighbours;
                            }
                        }
                        if (neighbours >= this.threshold) {
                            pixel = this.colormap != null ? this.colormap.getColor((float)i2 / (float)this.iterations) : this.newColor;
                        }
                    }
                    outPixels[index++] = pixel;
                }
            }
        }
        return outPixels;
    }

    public String toString() {
        return "Binary/Erode...";
    }
}

