/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;

public class DiffusionFilter
extends WholeImageFilter {
    protected static final int[] diffusionMatrix = new int[]{0, 0, 0, 0, 0, 7, 3, 5, 1};
    private int[] matrix;
    private int sum = 16;
    private boolean serpentine = true;
    private boolean colorDither = true;
    public int levels = 6;

    public DiffusionFilter() {
        this.setMatrix(diffusionMatrix);
    }

    public void setSerpentine(boolean serpentine) {
        this.serpentine = serpentine;
    }

    public boolean getSerpentine() {
        return this.serpentine;
    }

    public void setColorDither(boolean colorDither) {
        this.colorDither = colorDither;
    }

    public boolean getColorDither() {
        return this.colorDither;
    }

    public void setMatrix(int[] matrix) {
        this.matrix = matrix;
        this.sum = 0;
        for (int i2 = 0; i2 < matrix.length; ++i2) {
            this.sum += matrix[i2];
        }
    }

    public int[] getMatrix() {
        return this.matrix;
    }

    public void setLevels(int levels) {
        this.levels = levels;
    }

    public int getLevels() {
        return this.levels;
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int[] outPixels = new int[width * height];
        int index = 0;
        int[] map = new int[this.levels];
        for (int i2 = 0; i2 < this.levels; ++i2) {
            int v2;
            map[i2] = v2 = 255 * i2 / (this.levels - 1);
        }
        int[] div = new int[256];
        for (int i3 = 0; i3 < 256; ++i3) {
            div[i3] = this.levels * i3 / 256;
        }
        for (int y2 = 0; y2 < height; ++y2) {
            int direction;
            boolean reverse;
            boolean bl = reverse = this.serpentine && (y2 & 1) == 1;
            if (reverse) {
                index = y2 * width + width - 1;
                direction = -1;
            } else {
                index = y2 * width;
                direction = 1;
            }
            for (int x2 = 0; x2 < width; ++x2) {
                int rgb1 = inPixels[index];
                int r1 = rgb1 >> 16 & 0xFF;
                int g1 = rgb1 >> 8 & 0xFF;
                int b1 = rgb1 & 0xFF;
                if (!this.colorDither) {
                    g1 = b1 = (r1 + g1 + b1) / 3;
                    r1 = b1;
                }
                int r2 = map[div[r1]];
                int g2 = map[div[g1]];
                int b2 = map[div[b1]];
                outPixels[index] = 0xFF000000 | r2 << 16 | g2 << 8 | b2;
                int er = r1 - r2;
                int eg = g1 - g2;
                int eb2 = b1 - b2;
                for (int i4 = -1; i4 <= 1; ++i4) {
                    int iy = i4 + y2;
                    if (0 > iy || iy >= height) continue;
                    for (int j2 = -1; j2 <= 1; ++j2) {
                        int w2;
                        int jx = j2 + x2;
                        if (0 > jx || jx >= width || (w2 = reverse ? this.matrix[(i4 + 1) * 3 - j2 + 1] : this.matrix[(i4 + 1) * 3 + j2 + 1]) == 0) continue;
                        int k2 = reverse ? index - j2 : index + j2;
                        rgb1 = inPixels[k2];
                        r1 = rgb1 >> 16 & 0xFF;
                        g1 = rgb1 >> 8 & 0xFF;
                        b1 = rgb1 & 0xFF;
                        inPixels[k2] = PixelUtils.clamp(r1 += er * w2 / this.sum) << 16 | PixelUtils.clamp(g1 += eg * w2 / this.sum) << 8 | PixelUtils.clamp(b1 += eb2 * w2 / this.sum);
                    }
                }
                index += direction;
            }
        }
        return outPixels;
    }

    public String toString() {
        return "Colors/Diffusion Dither...";
    }
}

