/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.internal;

import com.jgoodies.common.base.Preconditions;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public final class TableRowSorterListSelectionModel
extends DefaultListSelectionModel {
    private final ListSelectionModel delegate;
    private final JTable table;
    private final ListSelectionListener updateListener;

    public TableRowSorterListSelectionModel(ListSelectionModel listSelectionModel, JTable table) {
        this.delegate = Preconditions.checkNotNull(listSelectionModel, "The delegate ListSelectionModel must not be null.");
        this.table = Preconditions.checkNotNull(table, "The table must not be null.");
        this.updateListener = new ViewUpdateListener();
        this.initEventHandling();
    }

    private void initEventHandling() {
        this.delegate.addListSelectionListener(this.updateListener);
        this.initViewSelectionFromModel();
    }

    private void initViewSelectionFromModel() {
        int firstModelIndex = this.delegate.getMinSelectionIndex();
        int lastModelIndex = this.delegate.getMaxSelectionIndex();
        super.clearSelection();
        for (int modelIndex = firstModelIndex; modelIndex <= lastModelIndex; ++modelIndex) {
            int viewIndex = this.convertIndexToView(modelIndex);
            boolean modelSelected = this.delegate.isSelectedIndex(modelIndex);
            if (!modelSelected) continue;
            super.addSelectionInterval(viewIndex, viewIndex);
        }
    }

    private void updateViewSelectionFromModel(int firstModelIndex, int lastModelIndex) {
        for (int modelIndex = firstModelIndex; modelIndex <= lastModelIndex; ++modelIndex) {
            boolean viewSelected;
            int viewIndex = this.convertIndexToView(modelIndex);
            boolean modelSelected = this.delegate.isSelectedIndex(modelIndex);
            if (modelSelected == (viewSelected = this.isSelectedIndex(viewIndex))) continue;
            if (modelSelected) {
                super.addSelectionInterval(viewIndex, viewIndex);
                continue;
            }
            super.removeSelectionInterval(viewIndex, viewIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectionInterval(int index0, int index1) {
        super.setSelectionInterval(index0, index1);
        this.delegate.removeListSelectionListener(this.updateListener);
        try {
            if (this.getSelectionMode() == 0) {
                this.delegate.setSelectionInterval(0, this.convertIndexToModel(index1));
            } else {
                this.delegate.setValueIsAdjusting(true);
                this.delegate.clearSelection();
                int start = Math.min(index0, index1);
                int end = Math.max(index0, index1);
                for (int i2 = start; i2 <= end; ++i2) {
                    int modelIndex = this.convertIndexToModel(i2);
                    this.delegate.addSelectionInterval(modelIndex, modelIndex);
                }
                this.delegate.setValueIsAdjusting(false);
            }
        }
        finally {
            this.delegate.addListSelectionListener(this.updateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSelectionInterval(int index0, int index1) {
        super.addSelectionInterval(index0, index1);
        this.delegate.removeListSelectionListener(this.updateListener);
        try {
            if (this.getSelectionMode() == 0) {
                this.delegate.addSelectionInterval(0, this.convertIndexToModel(index1));
            } else {
                this.delegate.setValueIsAdjusting(true);
                int start = Math.min(index0, index1);
                int end = Math.max(index0, index1);
                for (int i2 = start; i2 <= end; ++i2) {
                    int modelIndex = this.convertIndexToModel(i2);
                    this.delegate.addSelectionInterval(modelIndex, modelIndex);
                }
                this.delegate.setValueIsAdjusting(false);
            }
        }
        finally {
            this.delegate.addListSelectionListener(this.updateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSelectionInterval(int index0, int index1) {
        super.removeSelectionInterval(index0, index1);
        this.delegate.removeListSelectionListener(this.updateListener);
        try {
            if (this.getSelectionMode() == 0) {
                this.delegate.removeSelectionInterval(0, this.convertIndexToModel(index1));
            } else {
                this.delegate.setValueIsAdjusting(true);
                int start = Math.min(index0, index1);
                int end = Math.max(index0, index1);
                for (int i2 = start; i2 <= end; ++i2) {
                    int modelIndex = this.convertIndexToModel(i2);
                    this.delegate.removeSelectionInterval(modelIndex, modelIndex);
                }
                this.delegate.setValueIsAdjusting(false);
            }
        }
        finally {
            this.delegate.addListSelectionListener(this.updateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSelection() {
        super.clearSelection();
        this.delegate.removeListSelectionListener(this.updateListener);
        try {
            this.delegate.clearSelection();
        }
        finally {
            this.delegate.addListSelectionListener(this.updateListener);
        }
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
        throw new UnsupportedOperationException("#insertIndexInterval not yet implemented");
    }

    @Override
    public void removeIndexInterval(int index0, int index1) {
        throw new UnsupportedOperationException("#removeIndexInterval not yet implemented");
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        this.delegate.setSelectionMode(selectionMode);
    }

    @Override
    public int getSelectionMode() {
        return this.delegate.getSelectionMode();
    }

    private int convertIndexToModel(int index) {
        if (index == -1) {
            return -1;
        }
        RowSorter<? extends TableModel> rowSorter = this.table.getRowSorter();
        return rowSorter == null ? index : rowSorter.convertRowIndexToModel(index);
    }

    private int convertIndexToView(int index) {
        if (index == -1) {
            return -1;
        }
        RowSorter<? extends TableModel> rowSorter = this.table.getRowSorter();
        return rowSorter == null ? index : rowSorter.convertRowIndexToView(index);
    }

    private final class ViewUpdateListener
    implements ListSelectionListener {
        private ViewUpdateListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e2) {
            if (e2.getValueIsAdjusting()) {
                return;
            }
            TableRowSorterListSelectionModel.this.updateViewSelectionFromModel(e2.getFirstIndex(), this.inBounds(e2.getLastIndex()));
        }

        private int inBounds(int index) {
            RowSorter<? extends TableModel> rowSorter = TableRowSorterListSelectionModel.this.table.getRowSorter();
            int rowCount = rowSorter == null ? TableRowSorterListSelectionModel.this.table.getRowCount() : rowSorter.getViewRowCount();
            return Math.min(index, rowCount - 1);
        }
    }
}

