/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.common.base.Preconditions;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Timer;

public abstract class DelayedPropertyChangeHandler
implements PropertyChangeListener {
    public static final int DEFAULT_DELAY = 200;
    private final Timer timer;
    private boolean coalesce;
    private PropertyChangeEvent pendingEvt;

    public DelayedPropertyChangeHandler() {
        this(200);
    }

    public DelayedPropertyChangeHandler(int delay) {
        this(delay, false);
    }

    public DelayedPropertyChangeHandler(int delay, boolean coalesce) {
        Preconditions.checkArgument(delay >= 0, "The delay must not be negative.");
        this.coalesce = coalesce;
        this.timer = new Timer(delay, new DelayHandler());
        this.timer.setRepeats(false);
    }

    public final int getDelay() {
        return this.timer.getDelay();
    }

    public final void setDelay(int delay) {
        this.timer.setInitialDelay(delay);
        this.timer.setDelay(delay);
    }

    public final boolean isCoalesce() {
        return this.coalesce;
    }

    public final void setCoalesce(boolean b2) {
        this.coalesce = b2;
    }

    public final void stop() {
        this.timer.stop();
    }

    public final boolean isPending() {
        return this.timer.isRunning();
    }

    @Override
    public final void propertyChange(PropertyChangeEvent evt) {
        this.pendingEvt = evt;
        if (this.coalesce) {
            this.timer.restart();
        } else {
            this.timer.start();
        }
    }

    public abstract void delayedPropertyChange(PropertyChangeEvent var1);

    private final class DelayHandler
    implements ActionListener {
        private DelayHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            DelayedPropertyChangeHandler.this.delayedPropertyChange(DelayedPropertyChangeHandler.this.pendingEvt);
            DelayedPropertyChangeHandler.this.timer.stop();
        }
    }
}

